/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import flybase.Utils;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.MessageApp;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.TestBiobase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class BioseqReader
implements BioseqReaderIface {
    public static String tempFile = "bioseqtemp.";
    public static boolean verbose;
    public static String lineEnd;
    static final boolean useBioseqBytes = true;
    static final int kBigChunk = 500000;
    int readChunkSize = 2048;
    int readFreeSize = this.readChunkSize * 100;
    public static MessageApp messageapp;
    protected boolean skipdocs;
    protected int formatId = -1;
    protected int seqlen;
    protected int seqoffset;
    protected int seqlencount;
    protected int maxseqlen;
    protected int memstep;
    protected int choice;
    protected int nseq;
    protected int margin = 0;
    protected int err = 0;
    protected int atseq = 0;
    protected boolean addit = true;
    protected boolean addfirst = false;
    protected boolean addend = true;
    protected boolean needString = false;
    protected boolean allDone = false;
    protected boolean ungetline = false;
    protected boolean ungetend = false;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected Object seqdoc;
    private Bioseq seq;
    private byte[] bases;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected TestBiobase testbase = new TestBiobase();
    protected int testbaseKind = 3;
    protected int nWaiting = 0;
    protected OpenString sWaiting = new OpenString("");
    private Reader fIns;
    private int lastc = -1;
    private final int kMaxbuf = 8192;
    private int nbuf = 0;
    private boolean fEof = false;
    private OpenString osbuf;
    private char[] osval;
    private int oslinei;
    private int oslen;
    private int osnewlinesize = 1;
    private int insreadlen;
    private char osnewline;

    public BioseqReader() {
    }

    public BioseqReader(Reader ins) {
        this();
        this.setInput(ins);
    }

    public static void message(String s) {
        if (messageapp != null) {
            messageapp.infomessage(s);
        } else {
            System.err.println(s);
        }
    }

    public void setChoice(int seqchoice) {
        this.choice = seqchoice;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int id) {
        this.formatId = id;
    }

    public Reader getInput() {
        return this.fIns;
    }

    public void setInput(InputStream ins) {
        throw new Error("InputStream not supported");
    }

    public void setInput(Reader ins) {
        this.fIns = ins;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public void doRead() throws IOException {
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        this.read();
        if (this.seqdoc == null) {
            this.seqdoc = new BasicBioseqDoc(this.seqid.toString());
        }
    }

    public int getNseq() {
        return this.nseq;
    }

    protected void setNseq(int nsequences) {
        this.nseq = nsequences;
    }

    public int getReadChunkSize() {
        return this.readChunkSize;
    }

    public void setReadChunkSize(int chunksize) {
        this.readChunkSize = Math.min(500000, Math.max(chunksize, 2048));
        this.readFreeSize = Math.max(this.readChunkSize, Math.min(500000, this.readChunkSize * 100));
        Debug.println("BioseqReader.setReadChunkSize=" + this.readChunkSize);
    }

    protected void clearSeqBuffer() {
        if (this.maxseqlen > this.readFreeSize) {
            this.maxseqlen = 0;
            this.seqlen = 0;
            this.bases = null;
        }
    }

    public void resetSeq() {
        this.seqlencount = 0;
        this.seqlen = 0;
        this.allDone = false;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
        this.seqdoc = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void skipPastHeader(int skiplines) {
        try {
            int i = skiplines;
            while (i > 0) {
                this.getline();
                --i;
            }
            do {
                OpenString s;
                if ((s = this.getline()) != null) {
                    i = s.length() - 1;
                    while (i > 0 && s.charAt(i) <= ' ') {
                        --i;
                    }
                }
                if (s == null || i != 0) return;
            } while (!this.endOfFile());
            return;
        }
        catch (IOException e) {}
    }

    public void copyto(SeqFileInfo si) {
        if (si == null) {
            return;
        }
        if (si.err == 0) {
            si.err = this.err;
        }
        si.seqlen = this.seqlen;
        si.seqdoc = this.seqdoc;
        if (si.err == 0 && (this.seqlen > 0 || this.seqdoc != null)) {
            si.atseq = this.atseq;
            if (this.atseq > si.nseq) {
                si.nseq = this.atseq;
            }
            si.seqid = this.seqid;
            si.checkSeqID();
            si.seq = this.seqlen > 0 ? new Bioseq(this.bases, 0, this.seqlen) : null;
            this.clearSeqBuffer();
        }
    }

    public void setSkipDocs(boolean turnon) {
        this.skipdocs = turnon;
    }

    public void readTo(BioseqWriterIface writer, int skipHeaderLines) throws IOException {
        int skiplines = skipHeaderLines;
        this.setSkipDocs(!writer.wantsDocument());
        boolean more = true;
        int atseqNum = 1;
        while (more) {
            this.skipPastHeader(skiplines);
            skiplines = 0;
            SeqFileInfo sfi = this.readOne(atseqNum);
            if (sfi == null) {
                more = false;
            } else {
                if (Debug.isOn || verbose) {
                    BioseqReader.message("read " + atseqNum + " id=" + sfi.seqid + " seqlen=" + sfi.seqlen);
                }
                if (writer.setSeq(sfi)) {
                    writer.writeSeqRecord();
                }
            }
            ++atseqNum;
        }
    }

    public SeqFileInfo readOne(int whichEntry) throws IOException {
        this.resetSeq();
        this.setChoice(whichEntry);
        if (this.endOfFile()) {
            return null;
        }
        this.doRead();
        if (this.err != 0) {
            Debug.println("readOne error " + this.err);
        }
        SeqFileInfo sfi = new SeqFileInfo();
        this.copyto(sfi);
        sfi.nseq = this.getNseq();
        return sfi;
    }

    public boolean endOfSequence() {
        return false;
    }

    private final int testbase(int c) {
        switch (this.testbaseKind) {
            default: {
                if (c <= 32 || c >= 48 && c <= 57) {
                    return 0;
                }
                return c;
            }
            case 2: {
                if (c < 32) {
                    return 0;
                }
                return c;
            }
            case 1: 
        }
        return this.testbase.isSeqChar(c);
    }

    protected final void addseq(OpenString s, int offset) {
        this.addseq(s, offset, s.length());
    }

    protected void addseq(OpenString s, int offset, int nb) {
        if (!this.addit) {
            return;
        }
        char[] cv = s.getValue();
        nb += (offset += s.getOffset());
        int i = offset;
        while (i < nb) {
            int c = this.testbase(cv[i]);
            if (c > 0) {
                if (this.seqlen >= this.maxseqlen && !this.expand()) {
                    return;
                }
                this.bases[this.seqlen++] = (byte)c;
            }
            ++i;
        }
    }

    protected void setSeqoffset(int seqoffset) {
        if (!this.addit) {
            return;
        }
        this.seqoffset = seqoffset;
        byte offsetc = (byte)BaseKind.indelEdge;
        int i = 0;
        while (i < seqoffset) {
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = offsetc;
            ++i;
        }
    }

    protected void addseq(char[] b, int offset, int nb) {
        if (!this.addit) {
            return;
        }
        nb += offset;
        int i = offset;
        while (i < nb) {
            int c = this.testbase(b[i]);
            if (c > 0) {
                if (this.seqlen >= this.maxseqlen && !this.expand()) {
                    return;
                }
                this.bases[this.seqlen++] = (byte)c;
            }
            ++i;
        }
    }

    protected final void countseq(OpenString s, int offset) {
        this.countseq(s, offset, s.length());
    }

    protected void countseq(OpenString s, int offset, int nb) {
        char[] cv = s.getValue();
        nb += (offset += s.getOffset());
        int i = offset;
        while (i < nb) {
            if (this.testbase(cv[i]) > 0) {
                ++this.seqlencount;
            }
            ++i;
        }
    }

    protected void countseq(char[] b, int offset, int nb) {
        nb += offset;
        int i = offset;
        while (i < nb) {
            if (this.testbase(b[i]) > 0) {
                ++this.seqlencount;
            }
            ++i;
        }
    }

    protected int countseqline(char[] b, int offset, int nb) {
        int count = 0;
        nb += offset;
        int i = offset;
        while (i < nb) {
            if (this.testbase(b[i]) > 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected void addinfo(String ids) {
        ids = Utils.formatNum(this.atseq, 3) + ")  " + ids.trim() + lineEnd;
        int i = 0;
        while (i < ids.length()) {
            char c = ids.charAt(i);
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = (byte)c;
            ++i;
        }
    }

    protected boolean expand() {
        this.maxseqlen += this.readChunkSize;
        ++this.memstep;
        if (this.bases == null) {
            this.bases = new byte[this.maxseqlen];
        } else {
            byte[] tb = new byte[this.maxseqlen];
            System.arraycopy(this.bases, 0, tb, 0, this.seqlen);
            this.bases = tb;
        }
        return this.bases != null;
    }

    protected final char getreadbuf(int i) {
        return this.osval[this.oslinei + i];
    }

    protected final void setreadbuf(int i, char c) {
        this.osval[this.oslinei + i] = c;
    }

    protected final char[] getreadchars() {
        return this.osval;
    }

    protected final int getreadcharofs() {
        return this.oslinei;
    }

    public boolean endOfFile() {
        return this.fEof;
    }

    public void ungetline() {
        this.ungetline = true;
    }

    public int getInsReadlen() {
        return this.insreadlen;
    }

    private void setReaderBuf(Reader ins) {
        this.oslinei = 0;
        this.oslen = 0;
        this.insreadlen = 0;
        if (this.osbuf != null) {
            this.osbuf.setLength(0);
        }
    }

    public void reset() {
        block2: {
            this.atseq = 0;
            this.err = 0;
            this.seqlencount = 0;
            this.seqlen = 0;
            this.nbuf = 0;
            this.allDone = false;
            this.ungetline = false;
            this.fEof = false;
            if (this.fIns == null) break block2;
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException ex) {
                Debug.println(this.getClass().getName() + ".reset() err=" + ex.getMessage());
            }
        }
    }

    public void getlineBuf() throws IOException {
        if (this.ungetline) {
            this.ungetline = false;
            this.bufToString();
        } else {
            this.readLine();
        }
    }

    public OpenString getline() throws IOException {
        if (this.ungetline) {
            this.ungetline = false;
            this.bufToString();
        } else {
            this.readLine();
        }
        return this.sWaiting;
    }

    final OpenString bufToOs(int offs, int len) {
        int at = this.oslinei + offs;
        return this.osbuf.substring(at, at + len);
    }

    protected final void bufToString() {
        int e = this.oslinei + this.nbuf;
        this.sWaiting = e > this.oslen ? this.osbuf.substring(this.oslinei) : this.osbuf.substring(this.oslinei, e);
        this.nWaiting = this.sWaiting.length();
    }

    protected final void readLine() throws IOException {
        int e;
        if (this.nbuf > 0) {
            this.oslinei += this.nbuf;
            this.nbuf = 0;
        }
        if (this.osbuf == null) {
            this.getOsBuf();
        }
        if ((e = this.osbuf.indexOf(this.osnewline, this.oslinei)) < this.oslinei) {
            this.getOsBuf();
            e = this.osbuf.indexOf(this.osnewline, this.oslinei);
        }
        if (e < this.oslinei) {
            this.sWaiting = this.oslinei >= this.oslen ? new OpenString("") : this.osbuf.substring(this.oslinei);
        } else {
            int e1 = e + this.osnewlinesize;
            if (e1 > this.oslen) {
                e1 = this.oslen;
            }
            this.sWaiting = this.osbuf.substring(this.oslinei, e1);
        }
        this.nWaiting = this.nbuf = this.sWaiting.length();
        this.insreadlen += this.nWaiting;
    }

    private void getOsBuf() throws IOException {
        int oldlen;
        int len;
        int offs;
        if (this.osbuf == null) {
            offs = 0;
            oldlen = len = 8192;
            this.osval = new char[len];
            this.osbuf = new OpenString(this.osval);
            this.oslinei = 0;
            this.oslen = 0;
        } else {
            offs = this.oslen - this.oslinei;
            len = 8192 - offs;
            oldlen = this.osbuf.length();
            if (offs > 0) {
                System.arraycopy(this.osval, this.oslinei, this.osval, 0, offs);
            }
            this.oslinei = 0;
            this.oslen = offs;
        }
        int rlen = this.fIns.read(this.osval, offs, len);
        if (rlen < 0) {
            if (this.oslen <= 0) {
                this.fEof = true;
            }
        } else {
            this.oslen += rlen;
        }
        if (this.oslen != oldlen) {
            this.osbuf = new OpenString(this.osval, 0, this.oslen);
        }
        if (this.osnewline == '\u0000') {
            this.osnewlinesize = 1;
            int i = 0;
            while (i < this.oslen) {
                if (this.osval[i] == '\n') {
                    this.osnewline = (char)10;
                    if (this.osval[i + 1] != '\r') break;
                    this.osnewlinesize = 2;
                    break;
                }
                if (this.osval[i] == '\r') {
                    this.osnewline = (char)13;
                    if (this.osval[i + 1] != '\n') break;
                    this.osnewlinesize = 2;
                    break;
                }
                ++i;
            }
        }
    }

    protected int indexOfBuf(char c) {
        return this.sWaiting.indexOf(c);
    }

    protected int indexOfBuf(String s) {
        return this.sWaiting.indexOf(s);
    }

    protected final OpenString bufSubstring(int offset, int endoff) {
        return this.bufToOs(offset, endoff - offset);
    }

    protected final OpenString bufSubstring(int endoff) {
        return this.bufToOs(0, endoff);
    }

    protected void read() throws IOException {
        this.readLoop();
    }

    protected void readLoop() throws IOException {
        boolean done;
        ++this.atseq;
        if (this.choice == -1) {
            this.addit = false;
        } else {
            boolean bl = this.addit = this.atseq == this.choice;
        }
        if (this.addit) {
            this.seqlencount = 0;
            this.seqlen = 0;
        }
        if (this.addfirst) {
            this.addseq(this.sWaiting, 0, this.nWaiting);
        }
        do {
            this.getlineBuf();
            boolean bl = done = this.endOfFile() || this.endOfSequence();
            if (!this.addit || !this.addend && done || this.nWaiting <= this.margin) continue;
            this.addseq(this.sWaiting, this.margin, this.nWaiting - this.margin);
        } while (!done);
        if (this.choice == -1) {
            this.addinfo(this.seqid);
        } else {
            boolean bl = this.allDone = this.atseq >= this.choice;
            if (this.allDone && this.ungetend) {
                this.ungetline();
            }
        }
    }

    static {
        lineEnd = "\n";
        lineEnd = System.getProperty("line.separator");
        messageapp = null;
    }
}

