/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;

public class GenbankDoc
extends BioseqDocImpl {
    public static String gbprop = "GenbankDoc";
    private static FastHashtable glabel2keys = new FastHashtable();
    private static FastProperties keys2glabel = new FastProperties();
    public static LocusIndex locIndex2000 = new LocusIndex(13, 23, 31, 34, 37, 43, 53, 63);
    public static LocusIndex locIndex2003 = new LocusIndex(13, 30, 42, 45, 48, 56, 65, 69);
    LocusIndex lco = locIndex2003;
    private boolean gotOneFT;
    private static final String fFeatureTag = "FEATURES";
    private static final int fFeatIndent = 21;
    private static final int fFieldIndent = 12;
    private static final int fFieldIndent1 = 13;
    protected boolean isAmino;

    public GenbankDoc() {
        this.gbinit();
    }

    public GenbankDoc(String idname) {
        this.gbinit();
        this.addBasicName(idname);
    }

    public GenbankDoc(BioseqDoc source) {
        super(source);
        this.gbinit();
        this.fFromForeignFormat = !(source instanceof GenbankDoc);
    }

    private void gbinit() {
        this.kLinewidth = 79;
    }

    public void setAmino(boolean turnon) {
        this.isAmino = turnon;
    }

    public void setSourceDoc(BioseqDoc source) {
        super.setSourceDoc(source);
        this.fFromForeignFormat = !(source instanceof GenbankDoc);
    }

    public void addDocLine(String line) {
        String field = null;
        String value = null;
        boolean append = false;
        int level = 1;
        int at = line.indexOf(32);
        int len = line.length();
        if (at < 0) {
            at = 0;
        }
        if (at > 0) {
            int vlen;
            level = 1;
            int cut = 12;
            if (len <= cut) {
                field = line.trim();
                value = "";
                vlen = 0;
            } else {
                field = line.substring(0, cut).trim();
                value = line.substring(cut);
                vlen = value.length();
            }
            int e = vlen;
            while (e > 0 && value.charAt(e - 1) <= ' ') {
                --e;
            }
            if (e < vlen) {
                value = value.substring(0, e);
            }
            switch (this.inFeatures) {
                case 2: {
                    this.inFeatures = 3;
                    break;
                }
                case 0: {
                    if (!field.equals(fFeatureTag)) break;
                    this.inFeatures = 1;
                }
            }
        } else if (at == 0) {
            while (at < len && line.charAt(at) == ' ' && at < 12) {
                ++at;
            }
            if (len < 2 || at >= len - 1) {
                return;
            }
            if (at >= 12 || at == len) {
                value = line.substring(at).trim();
                field = this.lastfld;
                if (this.inFeatures == 2) {
                    if (this.lastlev == 4 && !value.startsWith("/")) {
                        level = 4;
                        append = true;
                    } else {
                        level = 5;
                    }
                } else {
                    level = 3;
                    append = true;
                }
            } else {
                level = this.inFeatures == 2 ? 4 : 2;
                int e = line.indexOf(32, at);
                if (e < 0) {
                    e = len;
                }
                field = line.substring(at, e);
                at = e;
                while (at < len && line.charAt(at) == ' ') {
                    ++at;
                }
                value = line.substring(at);
            }
            if (value != null) {
                value = value.trim();
            }
        }
        if (this.inFeatures == 2) {
            this.addFeature(field, value, level, append);
        } else {
            this.addDocField(field, value, level, append);
        }
        if (this.inFeatures == 1) {
            this.inFeatures = 2;
        }
        if (level != 3) {
            this.lastfld = field;
            this.lastlev = level;
        }
    }

    private int addlinefield(String val, int vallen, int btab, int etab, String fldname, int fldkind, int fldlev) {
        btab -= 13;
        if ((etab -= 13) > vallen) {
            return -1;
        }
        String sv = val.substring(btab, etab).trim();
        if (sv.length() <= 0) {
            return 0;
        }
        super.addDocField(fldname, sv, fldkind, fldlev, false);
        return 1;
    }

    public void addDocField(String field, String val, int level, boolean append) {
        int kind = 0;
        if (level == 1 || level == 2 || level == 3) {
            kind = this.getBiodocKind(field);
            int vlen = val.length();
            switch (kind) {
                case 10: {
                    LocusIndex lcr = LocusIndex.checkin(val);
                    if (0 > this.addlinefield(val, vlen, lcr.id, lcr.len, field, 10, 1)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, lcr.len, lcr.bp, "length", 112, 1)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, lcr.ss, lcr.mol - 1, "strand", 116, 1)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, lcr.mol, lcr.cir, "mol", 113, 1)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, lcr.cir, lcr.div, "circ", 115, 1)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, lcr.div, lcr.dat, "div", 11, 1)) {
                        return;
                    }
                    this.addlinefield(val, vlen, lcr.dat, vlen + 13, "date", 80, 1);
                    return;
                }
                case 110: {
                    super.addDocField(field, "", 110, 1, false);
                    if (0 > this.addlinefield(val, vlen, 13, 20, "na", 117, 2)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, 23, 29, "nc", 118, 2)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, 32, 38, "ng", 119, 2)) {
                        return;
                    }
                    if (0 > this.addlinefield(val, vlen, 41, 47, "nt", 120, 2)) {
                        return;
                    }
                    this.addlinefield(val, vlen, 50, 56, "nn", 121, 2);
                    return;
                }
                case 60: {
                    int a = val.indexOf("(bases");
                    int e = val.indexOf(41);
                    if (a < 0 || e <= a) break;
                    String rsi = val.substring(a + "(bases".length(), e).trim();
                    val = val.substring(0, a).trim();
                    a = rsi.indexOf(" to ");
                    if (a > 0) {
                        rsi = rsi.substring(0, a) + "-" + rsi.substring(a + 4);
                    }
                    super.addDocField(field, val, 60, 1, false);
                    super.addDocField("pubseq", rsi, 65, 2, false);
                    return;
                }
            }
        }
        super.addDocField(field, val, kind, level, append);
    }

    public String getBiodockey(String field) {
        return (String)glabel2keys.get(field);
    }

    public String getFieldName(int kind) {
        this.indent = 12;
        this.subindent = 0;
        String lab = null;
        String biodockey = BioseqDocImpl.getBiodockey(kind);
        if (biodockey != null) {
            lab = (String)keys2glabel.get(biodockey);
        }
        switch (kind) {
            case 51: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.subindent = 2;
                break;
            }
            case 70: {
                this.indent = 21;
                this.gotOneFT = true;
                return fFeatureTag;
            }
            case 71: {
                return " ";
            }
            case 72: {
                return " ";
            }
        }
        return lab;
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        switch (nv.getKind()) {
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 65: 
            case 80: 
            case 90: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                break;
            }
            case 114: {
                super.writeDocItem(new DocItem(this.getFieldName(100), nv.getValue(), 100, 1), writeAll);
                break;
            }
            case 110: {
                if (this.isAmino) break;
                super.writeDocItem(nv, writeAll);
                break;
            }
            default: {
                super.writeDocItem(nv, writeAll);
            }
        }
    }

    private boolean putlinefield(StringBuffer sb, String val, int etab, int just) {
        int width = etab - 13 - sb.length();
        if (val == null) {
            sb.append(this.spaces(width));
            return false;
        }
        if (just == 2) {
            sb.append(Fmt.fmt(val, width - 1, just) + " ");
            return true;
        }
        sb.append(Fmt.fmt(val, width, just));
        return true;
    }

    protected String getFieldValue(DocItem di) {
        switch (di.getKind()) {
            case 70: {
                return "         Location/Qualifiers";
            }
            case 10: {
                int sp;
                StringBuffer sb = new StringBuffer();
                this.putlinefield(sb, di.getValue(), this.lco.len - 1, 2);
                this.putlinefield(sb, this.getDocField(112), this.lco.bp - 1, 0);
                if (this.isAmino) {
                    sb.append(" aa ");
                } else {
                    sb.append(" bp ");
                }
                if (this.putlinefield(sb, this.getDocField(116), this.lco.mol - 1, 0)) {
                    sb.append('-');
                } else {
                    sb.append(' ');
                }
                this.putlinefield(sb, this.getDocField(113), this.lco.cir, 2);
                this.putlinefield(sb, this.getDocField(115), this.lco.div, 2);
                this.putlinefield(sb, this.getDocField(11), this.lco.dat, 2);
                String dt = this.getDocField(80);
                if (dt != null && (sp = dt.indexOf(32)) > 0) {
                    dt = dt.substring(0, sp);
                }
                this.putlinefield(sb, dt, 79, 2);
                return sb.toString();
            }
            case 60: {
                StringBuffer sb = new StringBuffer(di.getValue());
                String rsi = this.getDocField(65);
                if (rsi != null) {
                    sb.append("  (bases ");
                    int mi = rsi.indexOf(45);
                    if (mi > 0 && mi < rsi.length()) {
                        sb.append(rsi.substring(0, mi));
                        sb.append(" to ");
                        sb.append(rsi.substring(mi + 1));
                    } else {
                        sb.append(rsi);
                    }
                    sb.append(')');
                }
                return sb.toString();
            }
            case 110: {
                StringBuffer sb = new StringBuffer();
                this.putlinefield(sb, this.getDocField(117), 20, 0);
                sb.append(" a");
                this.putlinefield(sb, this.getDocField(118), 29, 0);
                sb.append(" c");
                this.putlinefield(sb, this.getDocField(119), 38, 0);
                sb.append(" g");
                this.putlinefield(sb, this.getDocField(120), 47, 0);
                sb.append(" t");
                if (this.putlinefield(sb, this.getDocField(121), 56, 0)) {
                    sb.append(" others");
                }
                return sb.toString();
            }
        }
        return super.getFieldValue(di);
    }

    protected String getFieldLabel(int level, DocItem di) {
        String name = null;
        this.indent = 0;
        this.subindent = 0;
        switch (level) {
            default: {
                name = this.fFromForeignFormat ? this.getFieldName(di.getKind()) : di.getName();
                if (name == null || name.length() == 0) {
                    return null;
                }
                this.indent = 12;
                if (level == 2) {
                    this.subindent = 2;
                }
                return Fmt.fmt(this.spaces(this.subindent) + name, this.indent - 1, 2) + " ";
            }
            case 3: {
                this.indent = 12;
                return this.spaces(this.indent);
            }
            case 4: {
                this.indent = 21;
                return Fmt.fmt(this.spaces(5) + di.getName(), this.indent - 1, 2) + " ";
            }
            case 5: {
                name = di.getName();
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (di.hasValue()) {
                    name = name + "=";
                }
                this.subindent = name.length();
                this.indent = 21;
                return this.spaces(this.indent) + name;
            }
            case 6: 
        }
        this.indent = 21;
        return this.spaces(this.indent);
    }

    protected void writeTextTop(FastVector v, boolean writeAll) {
        this.gotOneFT = false;
        super.writeTextTop(v, writeAll);
    }

    static {
        String pname = System.getProperty(gbprop, gbprop);
        BioseqDocImpl.getDocProperties(pname, keys2glabel, glabel2keys);
    }

    public static class LocusIndex {
        final int id;
        final int len;
        final int bp;
        final int ss;
        final int mol;
        final int cir;
        final int div;
        final int dat;

        public LocusIndex(int i, int l, int b, int s, int m, int c, int dv, int dt) {
            this.id = i;
            this.len = l;
            this.bp = b;
            this.ss = s;
            this.mol = m;
            this.cir = c;
            this.div = dv;
            this.dat = dt;
        }

        public static LocusIndex checkin(String s) {
            if (s != null) {
                int bp = s.indexOf(" bp ");
                if (bp < 0) {
                    bp = s.indexOf(" aa ");
                }
                if (bp == 30) {
                    return locIndex2000;
                }
            }
            return locIndex2003;
        }
    }
}

