/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.WriteseqOpts;

class PearsonSeqWriter
extends BioseqWriter {
    static final int kSeqwidth = 60;
    int seqwidth = 60;

    PearsonSeqWriter() {
    }

    public void setOpts(WriteseqOpts newopts) {
        if (newopts != null) {
            this.opts.seqwidth = this.seqwidth = newopts.seqwidth;
        }
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.seqwidth = this.seqwidth;
    }

    public void writeRecordEnd() {
    }

    public void writeSeq() {
        int nout = 0;
        boolean newline = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] ba = this.bioseq.toBytes();
            for (int i = 0; i < this.seqlen; ++i) {
                this.writeByte((char)ba[this.offset + i]);
                newline = false;
                if (i % this.seqwidth != this.seqwidth - 1) continue;
                this.writeln();
                newline = true;
            }
        } else {
            for (int i = 0; i < this.seqlen; ++i) {
                char bc = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc <= '\u0000') continue;
                this.writeByte(bc);
                newline = false;
                if ((++nout - 1) % this.seqwidth != this.seqwidth - 1) continue;
                this.writeln();
                newline = true;
            }
        }
        if (!newline) {
            this.writeln();
        }
    }

    public void writeDoc() {
        this.writeString(">");
        this.writeString(this.seqid);
        String bpcheckend = String.valueOf(this.seqlen) + " bp";
        String ck = this.checksumString();
        if (ck.length() > 0) {
            bpcheckend = bpcheckend + " " + ck;
        }
        if (this.seqdoc instanceof BioseqDoc) {
            Debug.println("fasta doc from " + this.seqdoc);
            String title = ((BioseqDoc)this.seqdoc).getTitle();
            if (title != null) {
                if (title.startsWith(this.seqid) && title.startsWith(this.seqid + " " + bpcheckend)) {
                    title = null;
                }
                if (title != null) {
                    int iat = title.indexOf(this.seqid);
                    if (iat >= 0) {
                        title = title.substring(0, iat) + title.substring(iat + this.seqid.length());
                    }
                    if ((iat = title.indexOf(bpcheckend)) >= 0) {
                        title = title.substring(0, iat) + title.substring(iat + bpcheckend.length());
                    }
                    title = title.trim();
                    title = title.replace('\n', ';').replace('\r', ';');
                    this.writeString(" ");
                    this.writeString(title);
                }
            }
        }
        this.writeString(" ");
        this.writeln(bpcheckend);
    }
}

