/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastStack;
import flybase.FastVector;
import iubio.bioseq.Bioseq;
import iubio.readseq.BioseqDocVals;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.XmlDoc;
import iubio.readseq.XmlSeqFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class XmlSeqReader
implements BioseqReaderIface,
BioseqDocVals,
EntityResolver,
DTDHandler,
DocumentHandler,
ErrorHandler {
    public boolean showErrors;
    public static int readChunkSize = 2048;
    protected int formatId;
    protected int err;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected int seqoffset;
    protected int seqlencount;
    protected int maxseqlen;
    protected int choice;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected boolean skipdocs;
    protected boolean verbose;
    protected byte[] seqbytes;
    private XmlDoc xmlseqdoc;
    private FastVector seqvec;
    private boolean fEof = false;
    private Reader fIns;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected int testbaseKind = 3;
    protected int inElVal;
    protected int inFeatures;
    protected int parselevel;
    protected int docfieldlevel;
    protected Integer inEl;
    protected String inTagName;
    protected boolean inElAppend;
    protected FastStack inElStack = new FastStack();
    protected StringBuffer inFeatureKey;
    protected StringBuffer inFeatureVal;
    protected int featlevel;
    boolean continueOnError = true;
    protected BioseqWriterIface bioseqwriter;

    public XmlSeqReader() {
        this.showErrors = Debug.isOn;
        this.verbose = BioseqReader.verbose;
    }

    private final int testbase(int c) {
        switch (this.testbaseKind) {
            default: {
                if (c <= 32 || c >= 48 && c <= 57) {
                    return 0;
                }
                return c;
            }
            case 2: 
        }
        if (c < 32) {
            return 0;
        }
        return c;
    }

    protected void message(String s) {
        BioseqReader.message(s);
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int id) {
        this.formatId = id;
    }

    public int seqLen() {
        return this.seqlen;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void setChoice(int seqchoice) {
        this.choice = seqchoice;
    }

    public void setInput(Reader ins) {
        this.fIns = ins;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public void doRead() throws IOException {
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        if (this.seqvec == null || this.seqvec.isEmpty()) {
            this.doSaxRead();
        }
    }

    public void readTo(BioseqWriterIface writer, int skipHeaderLines) throws IOException {
        this.skipdocs = !writer.wantsDocument();
        this.setSaxWriteTo(writer);
        this.doSaxRead();
        this.setSaxWriteTo(null);
    }

    public SeqFileInfo readOne(int whichEntry) throws IOException {
        this.resetSeq();
        this.setChoice(whichEntry);
        if (this.endOfFile()) {
            return null;
        }
        this.doRead();
        SeqFileInfo si = new SeqFileInfo();
        this.copyto(si);
        si.nseq = this.getNseq();
        si.checkSeqID();
        return si;
    }

    public boolean endOfFile() {
        if (this.seqvec != null) {
            return this.choice > this.seqvec.size();
        }
        return this.fEof;
    }

    private void setReaderBuf(Reader ins) {
        if (this.seqvec != null) {
            this.seqvec.removeAllElements();
        }
    }

    public void reset() {
        block2: {
            this.atseq = 0;
            this.err = 0;
            this.seqlencount = 0;
            this.seqlen = 0;
            this.fEof = false;
            if (this.fIns == null) break block2;
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException ex) {
                Debug.println(this.getClass().getName() + ".reset() err=" + ex.getMessage());
            }
        }
    }

    public void skipPastHeader(int skiplines) {
    }

    public void copyto(SeqFileInfo si) {
        if (si == null) {
            return;
        }
        try {
            SeqFileInfo sat = (SeqFileInfo)this.seqvec.elementAt(this.choice - 1);
            sat.copyto(si);
        }
        catch (Exception e) {
            si.err = -2;
        }
    }

    protected void storeSeq() throws IOException {
        if (this.seqlen > 0) {
            ++this.atseq;
            ++this.nseq;
            Bioseq bseq = new Bioseq(this.seqbytes, 0, this.seqlen);
            SeqFileInfo si = new SeqFileInfo(bseq, 0, this.seqlen);
            si.atseq = this.atseq;
            si.nseq = this.nseq;
            si.seqid = this.seqid;
            si.err = this.err;
            si.seqdoc = this.xmlseqdoc;
            if (Debug.isOn || this.verbose) {
                this.message("saxread " + si.nseq + " id=" + si.seqid + " seqlen=" + si.seqlen);
            }
            if (this.seqvec == null) {
                this.seqvec = new FastVector();
            }
            if (this.bioseqwriter != null) {
                if (this.bioseqwriter.setSeq(si)) {
                    this.bioseqwriter.writeSeqRecord();
                }
                SeqFileInfo sidum = new SeqFileInfo();
                sidum.seqid = si.seqid;
                sidum.atseq = si.atseq;
                this.seqvec.addElement(sidum);
            } else {
                this.seqvec.addElement(si);
            }
        }
    }

    public void setSeqName(String name) {
        this.seqid = name;
        this.seqid = this.seqid.trim();
        int i = this.seqid.indexOf(32);
        if (i <= 0) {
            i = this.seqid.length();
        }
        if (i > 30) {
            i = 30;
        }
        this.idword = this.seqid.substring(0, i).toString();
    }

    protected void doSaxRead() throws IOException {
        try {
            Parser parser;
            try {
                parser = ParserFactory.makeParser(XmlSeqFormat.saxParserClass);
            }
            catch (Exception ep) {
                parser = ParserFactory.makeParser();
            }
            if (parser == null) {
                throw new IOException("Can't instantiate an XML parser");
            }
            parser.setDocumentHandler(this);
            parser.setDTDHandler(this);
            parser.setErrorHandler(this);
            InputSource inputSource = new InputSource(this.fIns);
            parser.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected void setSaxWriteTo(BioseqWriterIface writer) {
        this.bioseqwriter = writer;
    }

    protected void initSaxDoc() {
        this.nseq = 0;
        this.atseq = 0;
        this.inFeatures = 0;
        this.inElVal = 0;
        this.inEl = null;
        this.inTagName = null;
        this.inElAppend = false;
        this.inElStack.removeAllElements();
        this.inFeatureKey = new StringBuffer();
        this.inFeatureVal = new StringBuffer();
        this.resetSaxSeq();
    }

    protected void resetSaxSeq() {
        this.resetSeq();
        this.xmlseqdoc = new XmlDoc();
        this.xmlseqdoc.setSkipDocs(this.skipdocs);
    }

    public void resetSeq() {
        this.seqlencount = 0;
        this.seqlen = 0;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
    }

    protected void addseq(char[] b, int offset, int nb) {
        nb += offset;
        int i = offset;
        while (i < nb) {
            int c = this.testbase(b[i]);
            if (c > 0) {
                if (this.seqlen >= this.maxseqlen && !this.expand()) {
                    return;
                }
                this.seqbytes[this.seqlen++] = (byte)c;
            }
            ++i;
        }
    }

    protected boolean expand() {
        this.maxseqlen += readChunkSize;
        if (this.seqbytes == null) {
            this.seqbytes = new byte[this.maxseqlen];
        } else {
            byte[] tb = new byte[this.maxseqlen];
            System.arraycopy(this.seqbytes, 0, tb, 0, this.seqlen);
            this.seqbytes = tb;
        }
        return this.seqbytes != null;
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorOut("error: ", e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errorOut("fatalError: ", e);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errorOut("warning: ", e);
    }

    protected void errorOut(String kind, SAXParseException e) {
        ++this.err;
        if (this.showErrors) {
            int at;
            String id = e.getSystemId();
            if (id != null && (at = id.lastIndexOf(47)) > 0) {
                id = id.substring(at + 1);
            }
            this.message(id + ":" + e.getLineNumber() + ":" + e.getColumnNumber() + " ");
            this.message(kind + e.getMessage());
        }
    }

    public void startDocument() throws SAXException {
        try {
            if (this.xmlseqdoc == null || this.nseq > 0) {
                this.initSaxDoc();
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        this.fEof = true;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        try {
            int lastel = this.inElVal;
            if (this.inEl != null) {
                this.inElStack.push(new Pair(this.inTagName, this.inEl));
            }
            this.inTagName = name;
            this.inElAppend = false;
            ++this.parselevel;
            this.inEl = this.xmlseqdoc.getBiodocInteger(name);
            this.inElVal = this.inEl != null ? this.inEl : 0;
            switch (this.inElVal) {
                case 1: 
                case 2: 
                case 3: {
                    this.xmlseqdoc.addDocField(this.inTagName, "", this.inElVal, 1, false);
                    this.docfieldlevel = this.parselevel + 1;
                    break;
                }
                case 70: {
                    this.inFeatures = 2;
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    this.xmlseqdoc.addDocField(this.inTagName, "", this.inElVal, 1, false);
                    break;
                }
                case 71: {
                    break;
                }
                case 72: {
                    if (this.inFeatureKey.length() <= 0 || lastel != 71) break;
                    this.xmlseqdoc.startFeature(71, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
                case 74: 
                case 75: {
                    if (this.inFeatureVal.length() > 0) {
                        // empty if block
                    }
                    this.inFeatureVal.setLength(0);
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String name) throws SAXException {
        try {
            switch (this.inElVal) {
                case 2: {
                    this.storeSeq();
                    this.resetSaxSeq();
                    break;
                }
                case 70: {
                    this.inFeatures = 3;
                    break;
                }
                case 71: {
                    this.xmlseqdoc.endFeature(71, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
                case 72: {
                    this.xmlseqdoc.endFeature(72, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
            }
            --this.parselevel;
            if (!this.inElStack.empty()) {
                Pair p = (Pair)this.inElStack.pop();
                this.inEl = p.val;
                this.inTagName = p.name;
                this.inElVal = this.inEl != null ? this.inEl : 0;
                this.inElAppend = true;
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    protected String charsToString(char[] val, int offset, int length) {
        while (length > 0 && val[offset + length - 1] <= ' ') {
            --length;
        }
        int i = 0;
        while (i < length && val[offset + i] <= ' ') {
            ++i;
        }
        if (i > 0) {
            offset += i;
            length -= i;
        }
        if (length <= 0) {
            return null;
        }
        String sval = new String(val, offset, length);
        sval = sval.replace('\n', ' ');
        return sval;
    }

    protected StringBuffer charsToString(StringBuffer oldval, char[] val, int offset, int length) {
        String snew = this.charsToString(val, offset, length);
        if (oldval != null) {
            if (snew == null) {
                return oldval;
            }
            oldval.append(snew);
            return oldval;
        }
        return new StringBuffer(snew);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (!this.xmlseqdoc.keepField(this.inElVal)) {
                return;
            }
            switch (this.inElVal) {
                case 111: {
                    this.addseq(ch, start, length);
                    break;
                }
                case 10: {
                    this.docfieldlevel = this.parselevel;
                    String sval = this.charsToString(ch, start, length);
                    if (sval != null) {
                        this.setSeqName(sval);
                        this.xmlseqdoc.addDocField(this.inTagName, sval, this.inElVal, 1, this.inElAppend);
                        this.inElAppend = true;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.docfieldlevel = this.parselevel + 1;
                }
                case 70: 
                case 200: {
                    break;
                }
                default: {
                    String sval = this.charsToString(ch, start, length);
                    if (sval != null || !this.inElAppend) {
                        int fldlevel = this.parselevel > this.docfieldlevel ? 2 : 1;
                        this.xmlseqdoc.addDocField(this.inTagName, sval, this.inElVal, fldlevel, this.inElAppend);
                        this.inElAppend = true;
                    }
                    break;
                }
                case 74: 
                case 75: {
                    this.inFeatureVal = this.charsToString(this.inFeatureVal, ch, start, length);
                    break;
                }
                case 71: {
                    this.inFeatureKey = this.charsToString(this.inFeatureKey, ch, start, length);
                    break;
                }
                case 72: {
                    this.inFeatureKey = this.charsToString(this.inFeatureKey, ch, start, length);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    class Pair {
        Integer val;
        String name;

        Pair(String nm, Integer v) {
            this.name = nm;
            this.val = v;
        }
    }
}

