/*
 * Decompiled with CFR 0.152.
 */
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.EmblDoc;
import iubio.readseq.Readseq;
import iubio.readseq.SeqFileInfo;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class mergedocseq {
    static String outformat = "embl";

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: jre -cp .:readseq.jar [out=output-file] [format=output-format] inputfile(s)");
        } else {
            try {
                Vector<String> names = new Vector<String>();
                PrintStream out = System.out;
                int iarg = 0;
                while (iarg < args.length) {
                    String arg = args[iarg];
                    if (arg.startsWith("format=")) {
                        outformat = arg.substring("format=".length());
                    } else if (arg.startsWith("out=")) {
                        String outfile = arg.substring("out=".length());
                        out = new PrintStream(new FileOutputStream(outfile));
                    } else {
                        names.addElement(arg);
                    }
                    ++iarg;
                }
                BioseqWriterIface writer = BioseqFormats.newWriter(BioseqFormats.formatFromName(outformat));
                writer.setOutput(out);
                writer.writeHeader();
                Readseq rd = new Readseq();
                Enumeration en = names.elements();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String seqname = rd.setInputObject(name);
                    String docname = name + ".doc";
                    System.err.println("Merging " + docname + " with " + seqname);
                    if (!rd.isKnownFormat() || !rd.readInit()) continue;
                    while (rd.readNext()) {
                        SeqFileInfo sfi = rd.nextSeq();
                        sfi.seqdoc = mergedocseq.parseDoc(new EmblDoc(), docname);
                        if (writer.setSeq(sfi)) {
                            writer.writeSeqRecord();
                            continue;
                        }
                        System.err.println("Failed to write " + sfi);
                    }
                }
                writer.writeTrailer();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static BioseqDoc parseDoc(BioseqDoc doc, String docfile) throws Exception {
        String line;
        BufferedReader docf = new BufferedReader(new FileReader(docfile));
        while ((line = docf.readLine()) != null) {
            void var3_3;
            doc.addDocLine((String)var3_3);
        }
        docf.close();
        return doc;
    }
}

