/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybBatchUpdateException;
import com.sybase.jdbc2.jdbc.SybSQLException;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.UnimplementedOperationException;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ResourceBundle;

public class ErrorMessage {
    private static ResourceBundle _messages;
    public static final String ERR_LOADING_SYBSOCKET_FACTORY = "JZ0NF";
    public static final String ERR_URL_AND_SYBSOCKET_FACTORY = "JZ0US";
    public static final String ERR_USERNAME_TOO_LONG = "JZ001";
    public static final String ERR_PASSWORD_TOO_LONG = "JZ002";
    public static final String ERR_URL_FORMAT_ERROR = "JZ003";
    public static final String ERR_URL_FORMAT_ERROR_WITH_NFE = "JZ0NE";
    public static final String WARN_USE_FAILED = "010UF";
    public static final String ERR_BAD_CONVERT_TYPE_COMBINATION = "JZ0TC";
    public static final String ERR_ILLEGAL_HEX_CHAR = "JZ0HC";
    public static final String IO_TRUNCATION_WITH_STRING = "JZ0TS";
    public static final String IO_THREAD_DEATH = "JZ0TD";
    public static final String ERR_USERNAME_MISSING = "JZ004";
    public static final String ERR_BAD_COOKIE = "JZ0BC";
    public static final String ERR_BAD_COOKIE_MESSAGE = "JZ0BM";
    public static final String ERR_IO_EXCEPTION = "JZ006";
    public static final String ERR_BAD_COLUMN_INDEX = "JZ008";
    public static final String ERR_WASNULL_NO_COLUMN = "JZ0NC";
    public static final String ERR_BAD_CONVERT = "JZ009";
    public static final String ERR_LOGIN = "JZ00L";
    public static final String WARN_TDS_VERSION = "0100V";
    public static final String ERR_NUMERIC_OFLO = "JZ00B";
    public static final String ERR_CURSOR_ALREADY = "JZ00F";
    public static final String ERR_CUR_NOT_FOUND = "JZ00D";
    public static final String ERR_CURSOR_IN_USE = "JZ00E";
    public static final String ERR_UPDATE_NOT_SET = "JZ00G";
    public static final String ERR_NOT_UPDATABLE = "JZ00H";
    public static final String ERR_ROW_MODIFIED = "JZ0RM";
    public static final String ERR_INVALID_STREAM = "JZ0IS";
    public static final String ERR_BAD_METHOD_FOR_TYPE = "JZ0BT";
    public static final String ERR_BAD_METHOD_FOR_ROW = "JZ0BR";
    public static final String WARN_RESULTSET_TYPE_CHANGE = "010RC";
    public static final String ERR_BAD_DATA = "JZ0BD";
    public static final String ERR_NOT_REGISTERED = "JZ0D0";
    public static final String ERR_INVALID_KEY = "JZ0D1";
    public static final String ERR_EXPIRED = "JZ0D2";
    public static final String INFO_EXPIRES_SOON = "000D3";
    public static final String ERR_BAD_PROTOCOL = "JZ0D4";
    public static final String ERR_LOADING_PROTOCOL = "JZ0D5";
    public static final String ERR_UNKNOWN_VERSION = "JZ0D6";
    public static final String ERR_LOADING_URL_PROVIDER = "JZ0D7";
    public static final String ERR_INITIALIZING_URL_PROVIDER = "JZ0D8";
    public static final String ERR_CONNECTION_PROP = "JZ011";
    public static final String ERR_PROPERTY_ACCESS = "JZ012";
    public static final String ERR_JNDI_ENTRY = "JZ013";
    public static final String ERR_TRANS_NONE = "JZ014";
    public static final String WARN_DUPLICATE_PROPERTY = "010DP";
    public static final String WARN_UNKNOWN_PROPERTY = "010UP";
    public static final String WARN_HOSTNAME_TRUNCATED = "010HT";
    public static final String ERR_CONNECTION_DEAD = "JZ0C0";
    public static final String ERR_STATEMENT_BUSY = "JZ0S0";
    public static final String ERR_STATEMENT_IDLE = "JZ0S1";
    public static final String ERR_STATEMENT_CLOSED = "JZ0S2";
    public static final String ERR_RESULTSET_DEAD = "JZ0R0";
    public static final String ERR_RESULTSET_IDLE = "JZ0R1";
    public static final String ERR_RESULTSET_NULL = "JZ0R2";
    public static final String ERR_INVALID_COLUMN_NAME = "S0022";
    public static final String ERR_COLUMN_DEAD = "JZ0R3";
    public static final String ERR_BAD_TXTPTR = "JZ0R4";
    public static final String ERR_WRONG_LENGTH = "JZ0J0";
    public static final String ERR_UNEXPECTED_RESULTTYPE = "JZ0P1";
    public static final String WARN_UNPROCESSED_PARAM = "010P4";
    public static final String WARN_UNPROCESSED_ROW = "010P6";
    public static final String ERR_PROTOCOL_ERROR = "JZ0P4";
    public static final String ERR_NOT_CACHED = "JZ0P7";
    public static final String ERR_EVENT_INIT = "JZ0H0";
    public static final String ERR_EVENT_NOTFOUND = "JZ0H1";
    public static final String ERR_BAD_ARGUMENT = "JZ0I3";
    public static final String ERR_BAD_CHARSET = "JZ0I5";
    public static final String ERR_CHARSET_CONVERT = "JZ0I6";
    public static final String IO_NO_GATEWAY_RESPONSE = "JZ0I7";
    public static final String IO_GATEWAY_REFUSED = "JZ0I8";
    public static final String IO_TRUNCATION = "JZ0IA";
    public static final String IO_INPUTSTREAM_CLOSED = "JZ0I9";
    public static final String ERR_READ_STREAM = "JZ0T2";
    public static final String ERR_READ_TIMEOUT = "JZ0T3";
    public static final String ERR_WRITE_TIMEOUT = "JZ0T4";
    public static final String IO_CACHE_FULL = "JZ0T5";
    public static final String ERR_TUNNELLED_URL = "JZ0T6";
    public static final String ERR_READ_STREAM_THREAD_DEATH = "JZ0T7";
    public static final String ERR_READ_STREAM_SYNC = "JZ0T8";
    public static final String ERR_WRITE_STREAM_SYNC = "JZ0T9";
    public static final String ERR_READ_EOM = "JZ0EM";
    public static final String ERR_ESCAPE_SYNTAX = "JZ0S8";
    public static final String ERR_NO_FUNCTION_INFO = "JZ0SH";
    public static final String ERR_FUNCTION_ESCAPE_NOT_IMPL = "JZ0SI";
    public static final String ERR_METADATA_INFO = "JZ0SJ";
    public static final String WARN_METADATA_INFO_WITH_EXCEPTION = "010MX";
    public static final String WARN_METADATA_INFO = "010SJ";
    public static final String WARN_OLD_METADATA_INFO = "010SL";
    public static final String ERR_OUTER_JOINS_NOT_SUPPORTED = "JZ0SK";
    public static final String WARN_OPT_NOT_AVAIL = "010SK";
    public static final String ERR_INPARAM_NOT_SET = "JZ0SA";
    public static final String ERR_BAD_PARAM_INDEX = "JZ0SB";
    public static final String ERR_BAD_INPARAM_INDEX = "JZ0SC";
    public static final String ERR_NO_OUTPARAM = "JZ0SD";
    public static final String ERR_NOT_JDBC_OBJ = "JZ0SE";
    public static final String ERR_NOT_EXPECTING_PARAM = "JZ0SF";
    public static final String ERR_MISSING_PARAMS = "JZ0SG";
    public static final String ERR_INVALID_METHOD = "JZ0S3";
    public static final String ERR_EMPTY_QUERY = "JZ0S4";
    public static final String ERR_SQL_TYPE = "JZ0SM";
    public static final String ERR_NEGATIVE_FIELD_SIZE = "JZ0SN";
    public static final String ERR_INVALID_RESULTSET_CONCUR_TYPE = "JZ0SO";
    public static final String ERR_INVALID_RESULTSET_TYPE = "JZ0SP";
    public static final String ERR_INVALID_UDT_TYPE = "JZ0SQ";
    public static final String ERR_COLUMNTYPE_UNKN = "JZ0P8";
    public static final String ERR_COMPUTE_BY = "JZ0P9";
    public static final String ERR_CANCELLED = "JZ0PA";
    public static final String ERR_NOT_IMPLEMENTED = "ZZ00A";
    public static final String ERR_NOT_SUPPORTED = "JZ0NS";
    public static final String ERR_ASSERT_FAILED = "JZ0AF";
    public static final String WARN_ASSERT_FAILED = "010AF";
    public static final String ERR_UPDATECOUNT_UNAVAILABLE = "JZ0CU";
    public static final String ERR_NO_OUTPARAMS_ALLOWED = "JZ0BP";
    public static final String ERR_BATCH_STMTS_NOTSUPPORTED = "JZ0BS";
    public static final String ERR_BATCH_UPDATE_EXCEPTION = "JZ0BE";
    public static final String WARN_CAPABILITY_MISMATCH = "010SM";
    public static final String ERR_DESERIALIZATION = "JZ010";
    public static final String WARN_WRITE_ACCESS_DENIED = "010SN";
    public static final String WARN_FILEIO_FAILED = "010SP";
    public static final String WARN_SERVER_CHARSET_USED = "010TP";
    public static final String ERR_UNSUPPORTED_CAPABILITY = "JZ0PB";
    public static final String WARN_CONNECTION_LOGIN_REFUSED = "010SQ";

    static {
        try {
            _messages = ResourceBundle.getBundle("com.sybase.jdbc2.jdbc.resource.Messages");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ErrorMessage() {
    }

    private static String cookieReplace(String string, String string2, int n, String string3) {
        String string4 = "%" + n + "s";
        int n2 = string2.indexOf(string4);
        String string5 = string2;
        if (n2 == -1) {
            if (string5.indexOf(ErrorMessage.makeMessage(false, ERR_BAD_COOKIE_MESSAGE)) == -1) {
                string5 = string5.concat(ErrorMessage.makeMessage(false, ERR_BAD_COOKIE_MESSAGE));
            }
            string5 = string5.concat(ErrorMessage.makeMessage(false, ERR_BAD_COOKIE, String.valueOf(n), string3));
            return string5;
        }
        int n3 = n2 + string4.length();
        string5 = String.valueOf(string2.substring(0, n2)) + string3 + string2.substring(n3);
        return string5;
    }

    public static SQLWarning createWarning(String string) {
        return new SQLWarning(ErrorMessage.makeMessage(true, string), string);
    }

    public static SQLWarning createWarning(String string, String string2) {
        return new SQLWarning(ErrorMessage.makeMessage(true, string, string2), string);
    }

    private static String getMessage(boolean bl, String string) {
        String string2;
        try {
            string2 = _messages.getString(string);
            if (bl) {
                string2 = String.valueOf(string) + ": " + string2;
            }
        }
        catch (Exception exception) {
            string2 = "Internal error, missing message for: " + string + " exception: " + exception.toString();
        }
        return string2;
    }

    public static IOException makeIOException(String string) {
        return new IOException(ErrorMessage.makeMessage(true, string));
    }

    public static SQLException makeIOReportableException(String string, Exception exception) {
        String string2 = ErrorMessage.makeMessage(true, string);
        if (exception != null) {
            string2 = String.valueOf(string2) + ": " + exception.toString();
        }
        return new SQLException(string2, string);
    }

    private static String makeMessage(boolean bl, String string) {
        String string2 = ErrorMessage.getMessage(bl, string);
        return string2;
    }

    private static String makeMessage(boolean bl, String string, String string2) {
        String string3 = ErrorMessage.getMessage(bl, string);
        string3 = ErrorMessage.cookieReplace(string, string3, 1, string2);
        return string3;
    }

    private static String makeMessage(boolean bl, String string, String string2, String string3) {
        String string4 = ErrorMessage.getMessage(bl, string);
        string4 = ErrorMessage.cookieReplace(string, string4, 1, string2);
        string4 = ErrorMessage.cookieReplace(string, string4, 2, string3);
        return string4;
    }

    private static String makeMessage(boolean bl, String string, String[] stringArray) {
        String string2 = ErrorMessage.getMessage(bl, string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string2 = ErrorMessage.cookieReplace(string, string2, n + 1, stringArray[n]);
                ++n;
            }
        }
        return string2;
    }

    public static void print(String string, String string2) {
        System.out.println(ErrorMessage.makeMessage(false, string, string2));
    }

    public static void raiseBatchUpdateException(SybSQLException sybSQLException, int[] nArray) throws BatchUpdateException {
        throw new SybBatchUpdateException(sybSQLException, ErrorMessage.makeMessage(true, ERR_BATCH_UPDATE_EXCEPTION, sybSQLException.getMessage()), ERR_BATCH_UPDATE_EXCEPTION, 0, nArray);
    }

    public static void raiseError(String string) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.makeMessage(true, string), string);
        throw sQLException;
    }

    public static void raiseError(String string, String string2) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.makeMessage(true, string, string2), string);
        throw sQLException;
    }

    public static void raiseError(String string, String string2, String string3) throws SQLException {
        SQLException sQLException = new SQLException(ErrorMessage.makeMessage(true, string, string2, string3), string);
        throw sQLException;
    }

    public static void raiseIOException(String string) throws IOException {
        throw new IOException(ErrorMessage.makeMessage(true, string));
    }

    public static void raiseIOException(String string, String string2) throws IOException {
        throw new IOException(ErrorMessage.makeMessage(true, string, string2));
    }

    public static void raiseRuntimeException(String string, String[] stringArray) throws RuntimeException {
        String string2 = ErrorMessage.makeMessage(false, string, stringArray);
        if (string.equals(ERR_NOT_SUPPORTED)) {
            throw new UnsupportedOperationException(string2);
        }
        if (string.equals(ERR_NOT_IMPLEMENTED)) {
            throw new UnimplementedOperationException(string2);
        }
        if (string.equals(ERR_ASSERT_FAILED)) {
            RuntimeException runtimeException = new RuntimeException(string2);
            Debug.printStackTrace(null, runtimeException);
            throw runtimeException;
        }
        if (string.equals(WARN_ASSERT_FAILED)) {
            Debug.println(string2);
        }
    }

    public static void raiseWarning(String string) throws SQLWarning {
        throw ErrorMessage.createWarning(string);
    }

    public static void raiseWarning(String string, String string2) throws SQLWarning {
        throw ErrorMessage.createWarning(string, string2);
    }

    public static void raiseWarning(String string, String string2, String string3) throws SQLWarning {
        throw new SQLWarning(ErrorMessage.makeMessage(true, string, string2, string3), string);
    }
}

