/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybDebug;
import com.sybase.jdbc2.jdbc.SybKey;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.utils.Misc;
import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;

public class SybDriver
implements com.sybase.jdbcx.SybDriver {
    private static final long TWO_WEEKS = 1209600000L;
    public static final int DEFAULT_DRIVER_VERSION = 5;
    private SybKey _sybKey = null;
    protected int _version = 5;
    private static Calendar _today = new GregorianCalendar();
    private SybMessageHandler _msgHandler;

    static {
        SybDriver sybDriver = new SybDriver();
    }

    public SybDriver() {
        try {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                if (!(driver instanceof SybDriver)) continue;
                DriverManager.deregisterDriver(driver);
            }
            DriverManager.registerDriver(this);
        }
        catch (SQLException sQLException) {}
    }

    public boolean acceptsURL(String string) throws SQLException {
        SybUrlManager sybUrlManager;
        SybUrlProvider sybUrlProvider;
        int n = string.indexOf(47);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((sybUrlProvider = (sybUrlManager = new SybUrlManager(string, null, null)).getUrlProvider()) == null) {
            return false;
        }
        Protocol protocol = sybUrlProvider.getProtocol();
        return protocol != null;
    }

    public final Connection connect(String string, Properties properties) throws SQLException {
        SQLWarning sQLWarning;
        SybUrlProvider sybUrlProvider;
        Object object;
        Object object2;
        if (this._sybKey == null) {
            object2 = null;
            try {
                object = Class.forName("com.sybase.jdbc2.jdbc.SybDriverKey");
                object2 = (SybKey)((Class)object).newInstance();
            }
            catch (Exception exception) {
                ErrorMessage.raiseError("JZ0D0");
            }
            this.setKey((SybKey)object2);
        }
        if ((sybUrlProvider = ((SybUrlManager)(object = new SybUrlManager(string, properties, (SybProperty)(object2 = new SybProperty(properties, this._version))))).getUrlProvider()) == null) {
            return null;
        }
        Protocol protocol = sybUrlProvider.getProtocol();
        if (protocol == null) {
            return null;
        }
        SybConnection sybConnection = new SybConnection(sybUrlProvider.getHostPortList(), string, sybUrlProvider.getSybProps(), protocol, sybUrlProvider.getDatabaseName());
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = ((SybProperty)object2).getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    private static StringBuffer escapeSpecialCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '\\' || c == ',') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer;
    }

    public final Debug getDebug() {
        return new SybDebug();
    }

    public int getMajorVersion() {
        return 5;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        int n;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[34];
        SybProperty sybProperty = new SybProperty(properties, this._version);
        if (string != null && (n = string.indexOf(63)) > 0 && n++ < string.length()) {
            sybProperty.parsePropertyString(string.substring(n));
        }
        n = 0;
        while (n < 34) {
            driverPropertyInfoArray[n] = new DriverPropertyInfo(SybProperty.PROPNAME[n], sybProperty._propValue[n] == null ? null : sybProperty._propValue[n].toString());
            driverPropertyInfoArray[n].required = false;
            driverPropertyInfoArray[n].description = SybProperty.DESCRIPTION[n];
            ++n;
        }
        driverPropertyInfoArray[3].required = true;
        driverPropertyInfoArray[4].required = true;
        String string2 = null;
        if (this._sybKey != null) {
            driverPropertyInfoArray[11].value = this._sybKey.k3() != null ? this._sybKey.k3().toString() : "";
            string2 = this._sybKey.k2();
        }
        if (string2 == null) {
            string2 = "(Unlicenced)";
        }
        driverPropertyInfoArray[10].value = driverPropertyInfoArray[10].value.concat("\n" + string2);
        return driverPropertyInfoArray;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._msgHandler;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    private boolean keyMatch(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final void setKey(SybKey sybKey) throws SQLException {
        Date date;
        String string;
        byte[] byArray = Misc.makeKey(sybKey.k4(), sybKey.k2(), sybKey.k3());
        byte[] byArray2 = sybKey.k1();
        if (!this.keyMatch(byArray2, byArray)) {
            ErrorMessage.raiseError("JZ0D1");
        }
        if ((string = sybKey.k5()) != null) {
            com.sybase.jdbc2.utils.Debug.println(string);
        }
        if ((date = sybKey.k3()) != null) {
            long l = _today.getTime().getTime();
            long l2 = date.getTime();
            if (l2 < l) {
                ErrorMessage.raiseError("JZ0D2", date.toString());
            } else if (l2 - l < 1209600000L) {
                ErrorMessage.print("000D3", date.toString());
            }
        }
        this._sybKey = sybKey;
    }

    public final void setRemotePassword(String string, String string2, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = SybProperty.PROPNAME[9];
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(',');
        if (string != null) {
            stringBuffer.append((Object)SybDriver.escapeSpecialCharacters(string));
        }
        stringBuffer.append(',');
        if (string2 != null) {
            stringBuffer.append((Object)SybDriver.escapeSpecialCharacters(string2));
        }
        ((Hashtable)properties).put(string3, stringBuffer.toString());
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._msgHandler = sybMessageHandler;
    }

    public void setVersion(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this._version = n;
                return;
            }
        }
        ErrorMessage.raiseError("JZ0D6", String.valueOf(n));
    }
}

