/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataInputStream;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.Chainable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Calendar;

public abstract class TdsDataObject
extends TdsDataInputStream
implements JdbcDataObject,
Chainable {
    public static final int UNKNOWN = -1;
    public static final int UNINITIALIZED = -2;
    protected TdsProtocolContext _context;
    protected int _state;
    protected DataFormat _dataFmt;
    protected boolean _isNull;
    protected int _dataLength = -2;
    protected int _textptrlen = 0;
    protected byte[] _textptr = null;
    protected byte[] _timestamp = null;
    protected int _classIDLen;
    protected byte[] _classID;
    protected int _dbID;
    protected int _classNum;
    TdsDataObject _next = null;
    TdsDataObject _prev = null;

    public TdsDataObject(TdsProtocolContext tdsProtocolContext) throws IOException {
        super((Tds)tdsProtocolContext._protocol, tdsProtocolContext._inFormat);
        this._context = tdsProtocolContext;
        this.setBigEndian(tdsProtocolContext._bigEndian);
        this.initialize();
    }

    protected void badConversion(String string) throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ009", string);
    }

    protected void badConversionCombination() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.toString());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0TC");
    }

    protected abstract void beginRead() throws IOException;

    public abstract void cache() throws IOException;

    public abstract void clear() throws IOException;

    protected void copyInto(TdsDataObject tdsDataObject) throws IOException {
        tdsDataObject._state = this._state;
        tdsDataObject._dataFmt = this._dataFmt;
        tdsDataObject._isNull = this._isNull;
        tdsDataObject._dataLength = this._dataLength;
        tdsDataObject._textptrlen = this._textptrlen;
        tdsDataObject._classIDLen = this._classIDLen;
        tdsDataObject._dbID = this._dbID;
        tdsDataObject._classNum = this._classNum;
    }

    protected abstract TdsDataObject createCachedCopy() throws IOException, SQLException;

    protected void doRead() throws SQLException {
        try {
            this.beginRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.toString());
        }
    }

    protected void endRead() throws SQLException {
    }

    protected byte[] funkyBinaryReader() throws IOException {
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this._context._maxFieldSize != 0) {
            n = Math.min(this._dataLength, this._context._maxFieldSize);
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                n2 = Math.min(this._context._maxFieldSize, this._dataFmt._length) - n;
            }
            n3 = this._dataLength - n;
        } else {
            n = this._dataLength;
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                n2 = this._dataFmt._length - n;
            }
        }
        switch (this._dataFmt._datatype) {
            case 34: 
            case 37: 
            case 45: 
            case 225: {
                byArray = new byte[n + n2];
                this.in.read(byArray, 0, n);
                int n4 = n;
                while (n4 < byArray.length) {
                    byArray[n4] = 0;
                    ++n4;
                }
                if (this._context._maxFieldSize > 0 && this._context._maxFieldSize < this._dataLength) {
                    this.in.read(new byte[n3]);
                    break;
                }
                this.in.skip(n3);
                break;
            }
        }
        return byArray;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    public InputStream getBinaryStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract boolean getBoolean() throws SQLException;

    public abstract byte getByte() throws SQLException;

    public byte[] getBytes() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract double getDouble() throws SQLException;

    public abstract float getFloat() throws SQLException;

    public abstract int getInt() throws SQLException;

    public abstract long getLong() throws SQLException;

    public Chainable getNext() {
        return this._next;
    }

    public abstract Object getObject() throws SQLException;

    public Chainable getPrevious() {
        return this._prev;
    }

    public abstract short getShort() throws SQLException;

    protected void getSize() throws IOException {
        if (this._dataLength != -2) {
            return;
        }
        block0 : switch (this._dataFmt._datatype) {
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: {
                this._dataLength = this._dataFmt._length;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this._dataLength = this.readUnsignedByte();
                break;
            }
            case 34: 
            case 35: {
                this._textptrlen = this.readUnsignedByte();
                if (this._textptrlen == 0) {
                    this._dataLength = 0;
                    break;
                }
                this._textptr = new byte[this._textptrlen + 8];
                this.in.read(this._textptr, 0, this._textptrlen + 8);
            }
            case 175: 
            case 225: {
                this._dataLength = this.readInt();
                break;
            }
            case 36: {
                this._dataLength = -1;
                int n = this.readUnsignedByte();
                this._classIDLen = this.readShort();
                switch (this._dataFmt._blobType) {
                    case 1: {
                        if (this._classIDLen <= 0) break block0;
                        this._classID = new byte[this._classIDLen];
                        this.read(this._classID, 0, this._classIDLen);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this._classIDLen <= 0) break block0;
                        this.skip(this._classIDLen);
                        break;
                    }
                    default: {
                        this.skip(this._classIDLen);
                        break;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0P4");
            }
        }
        if (this._dataLength == 0) {
            this._isNull = true;
        }
    }

    public abstract String getString() throws SQLException;

    public TextPointer getTextPtr() throws SQLException {
        this.noTextPointer();
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public void initialize() {
        this._state = 0;
        this._isNull = false;
        this._dataLength = -2;
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    protected void noTextPointer() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0R4");
    }

    protected final TdsDateTime readDATETIMN() throws IOException, SQLException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n = this.readUnsignedShort();
                int n2 = this.readUnsignedShort();
                return new TdsDateTime(n, n2, 0);
            }
            case 8: {
                int n = this.readInt();
                int n3 = this.readInt();
                return new TdsDateTime(n, n3);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final double readFLTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0.0;
            }
            case 4: {
                return this.readFloat();
            }
            case 8: {
                return this.readDouble();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0.0;
    }

    protected final long readINTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.readUnsignedByte();
            }
            case 2: {
                return this.readShort();
            }
            case 4: {
                return this.readInt();
            }
            case 8: {
                return this.readLong();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0L;
    }

    protected final BigDecimal readMONEYN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n = this.readInt();
                return new BigDecimal(BigInteger.valueOf(n), 4);
            }
            case 8: {
                long l = this.readLong();
                return new BigDecimal(BigInteger.valueOf(l), 4);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final BigDecimal readNUMERIC(int n, int n2) throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        byte[] byArray = new byte[this._dataLength];
        this.in.read(byArray);
        return TdsNumeric.numericValue(byArray, n, n2);
    }

    protected final String readString() throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        if (this._context._maxFieldSize != 0) {
            n = Math.min(this._dataLength, this._context._maxFieldSize);
            n2 = this._dataLength - n;
        } else {
            n = this._dataLength;
        }
        byte[] byArray = new byte[n];
        this.in.read(byArray, 0, n);
        this.in.skip(n2);
        return this._tds._charsetConverter.toUnicode(byArray);
    }

    public void setNext(Chainable chainable) {
        this._next = (TdsDataObject)chainable;
    }

    public void setPrevious(Chainable chainable) {
        this._prev = (TdsDataObject)chainable;
    }

    public void startRead() throws IOException {
        switch (this._state) {
            case 0: {
                if (this._prev != null && this._prev._state != 3) {
                    this._prev.cache();
                }
                this._state = 1;
                this.getSize();
            }
        }
    }
}

