/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.biojava.bio.Annotatable;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.agave.AGAVEAnnotFilter;
import org.biojava.bio.seq.io.agave.AGAVEDbId;
import org.biojava.bio.seq.io.agave.AGAVEIdAlias;
import org.biojava.bio.seq.io.agave.AGAVEMapLocation;
import org.biojava.bio.seq.io.agave.AGAVEMatchRegion;
import org.biojava.bio.seq.io.agave.AGAVEProperty;
import org.biojava.bio.seq.io.agave.AGAVEQueryRegion;
import org.biojava.bio.seq.io.agave.AGAVERelatedAnnot;
import org.biojava.bio.seq.io.agave.AGAVEXrefs;
import org.biojava.bio.seq.io.agave.PCDATAFilterWriter;
import org.biojava.bio.seq.io.agave.SimpleAnnotFilter;

public class AgaveWriter {
    public static final String INDENT = "  ";
    protected PrintWriter mOut;
    protected Indent mIndent;
    protected PCDATAFilterWriter mFilter;
    protected AGAVEAnnotFilter mAnnotFilter;
    protected boolean mWriteDocType = true;

    public AgaveWriter() {
        this.mAnnotFilter = SimpleAnnotFilter.SIMPLE_ANNOT_FILTER_FACTORY.getInstance();
        this.mIndent = new Indent();
    }

    public AgaveWriter(AGAVEAnnotFilter filter) {
        this.mAnnotFilter = filter;
        this.mIndent = new Indent();
    }

    public void setWriteDocType(boolean writeDocType) {
        this.mWriteDocType = writeDocType;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        this.mOut = new PrintWriter(os);
        this.mFilter = new PCDATAFilterWriter(this.mOut);
        this.mOut.println("<?xml version=\"1.0\"?>");
        if (this.mWriteDocType) {
            this.mOut.println("<!DOCTYPE sciobj SYSTEM \"agave.dtd\">");
        }
        this.writeHeader();
        this.write(seq);
        this.writeFooter();
    }

    protected void writeHeader() {
        this.mOut.println("<sciobj version=\"2\">");
    }

    protected void writeFooter() {
        this.mOut.println("</sciobj>");
        this.mOut.flush();
    }

    protected void write(Sequence seq) throws IOException {
        String chrom_num = this.mAnnotFilter.getChromNum(seq.getAnnotation());
        if (chrom_num != null) {
            this.mIndent.indent();
            this.mOut.print(this.mIndent);
            this.mOut.println("<chromosome number=\"" + chrom_num + "\">");
            this.writeContig(seq);
            this.mOut.print(this.mIndent);
            this.mOut.println("</chromosome>");
            this.mIndent.unIndent();
        } else if (seq instanceof SimpleAssembly) {
            this.writeContig(seq);
        } else {
            this.writeBioSequence(seq);
        }
    }

    protected void writeContig(Annotatable seq) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<contig");
        this.mOut.print(" length=\"");
        this.mOut.print(((Sequence)seq).length());
        this.mOut.print('\"');
        this.mOut.println(">");
        this.writeDbId(seq);
        this.writeNote(seq);
        this.writeAssembly(seq);
        this.writeDNA(seq);
        this.writeMapLocation(seq);
        this.mOut.print(this.mIndent);
        this.mOut.println("</contig>");
        this.mIndent.unIndent();
    }

    protected void writeAssembly(Annotatable seq) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<assembly>");
        if (seq instanceof SimpleSequence) {
            this.write((Sequence)seq);
        } else if (seq instanceof SimpleAssembly) {
            Iterator i = ((Sequence)seq).features();
            while (i.hasNext()) {
                Feature subf = (Feature)i.next();
                if (!(subf instanceof ComponentFeature)) continue;
                this.writeBioSequence(((ComponentFeature)subf).getComponentSequence());
            }
        }
        this.mOut.print(this.mIndent);
        this.mOut.println("</assembly>");
        this.mIndent.unIndent();
    }

    protected void writeBioSequence(Annotatable seq) throws IOException {
        String s;
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<bio_sequence");
        if (seq instanceof Sequence) {
            this.mOut.print(" seq_length=\"");
            this.mOut.print(((Sequence)seq).length());
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getOrganism(seq.getAnnotation())) != null) {
            this.mOut.print(" organism_name=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getMolType(seq.getAnnotation())) == null && seq instanceof Sequence) {
            s = ((Sequence)seq).getAlphabet().getName();
        }
        if (s != null) {
            this.mOut.print(" molecule_type=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getElementId(seq.getAnnotation())) == null && seq instanceof Sequence) {
            s = ((Sequence)seq).getName();
        }
        if (s != null) {
            this.mOut.print(" element_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getSequenceId(seq.getAnnotation())) != null) {
            this.mOut.print(" sequence_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getTaxonId(seq.getAnnotation())) != null) {
            this.mOut.print(" taxon_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getCloneId(seq.getAnnotation())) != null) {
            this.mOut.print(" clone_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getCloneLibrary(seq.getAnnotation())) != null) {
            this.mOut.print(" clone_library=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getChromosome(seq.getAnnotation())) != null) {
            this.mOut.print(" chromosome=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getMapPosition(seq.getAnnotation())) != null) {
            this.mOut.print(" map_position=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getEcNumber(seq.getAnnotation())) != null) {
            this.mOut.print(" ec_number=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getCreateDate(seq.getAnnotation())) != null) {
            this.mOut.print(" update_date=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        this.mOut.println(">");
        this.writeDbId(seq);
        this.writeDNA(seq);
        this.writeAltIds(seq);
        this.writeXrefs(seq);
        this.writeSequenceMap2(seq);
        this.writeMapLocation(seq);
        this.writeClassification(seq);
        this.mIndent.unIndent();
        this.mOut.print(this.mIndent);
        this.mOut.println("</bio_sequence>");
    }

    protected void writeSequenceMap(Annotatable seq) throws IOException {
        Iterator i = ((FeatureHolder)((Object)seq)).features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            String type = f.getSource();
            if (type.equalsIgnoreCase("classification")) continue;
            this.writeSequenceMap2(f);
        }
    }

    protected void writeClassification(Annotatable seq) throws IOException {
        Iterator i = ((FeatureHolder)((Object)seq)).features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            String type = f.getSource();
            if (!type.equalsIgnoreCase("classification")) continue;
            this.writeClassification2(f);
        }
    }

    private void writeClassification2(Annotatable f) throws IOException {
        this.mOut.print(this.mIndent);
        this.mOut.print("<classification");
        this.mIndent.indent();
        String s = this.mAnnotFilter.getClassifySystem(f.getAnnotation());
        if (s != null) {
            this.mOut.print(" system=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getClassifyId(f.getAnnotation())) != null) {
            this.mOut.print(" id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getClassifyType(f.getAnnotation())) != null) {
            this.mOut.print(" type=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        this.mOut.println(">");
        this.writeDescription(f);
        this.writeIdAlias(f);
        this.writeEvidence(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</classification>");
        this.mIndent.unIndent();
    }

    private void writeIdAlias(Annotatable f) throws IOException {
        AGAVEIdAlias[] annots = this.mAnnotFilter.getIdAlias(f.getAnnotation());
        if (annots != null) {
            this.mIndent.indent();
            int i = 0;
            while (i < annots.length) {
                this.mOut.print(annots[i].toString(this.mIndent.toString(), INDENT));
                ++i;
            }
            this.mIndent.unIndent();
        }
    }

    protected void writeSequenceMap2(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<sequence_map");
        String label = this.mAnnotFilter.getLabel(f.getAnnotation());
        if (label != null) {
            this.mOut.print(" label=\"");
            this.mFilter.write(label);
            this.mOut.print('\"');
        }
        this.mOut.println(">");
        this.writeNote(f);
        this.writeAnnotations((FeatureHolder)((Object)f));
        this.mOut.print(this.mIndent);
        this.mOut.println("</sequence_map>");
        this.mIndent.unIndent();
    }

    protected void writeAnnotations(FeatureHolder f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<annotations>");
        Iterator i = f.features();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            String type = feature.getSource();
            if (type == null || type.equalsIgnoreCase("seq_feature")) {
                this.writeSeqFeature(feature);
                continue;
            }
            if (type.equalsIgnoreCase("gene")) {
                this.writeGene(feature);
                continue;
            }
            this.writeSeqFeature(feature);
        }
        this.mOut.print(this.mIndent);
        this.mOut.println("</annotations>");
        this.mIndent.unIndent();
    }

    protected void writeGene(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<gene");
        String s = this.mAnnotFilter.getElementId(f.getAnnotation());
        if (s != null) {
            this.mOut.print(" element_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getLabel(f.getAnnotation())) != null) {
            this.mOut.print(" label=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        this.mOut.println('>');
        this.writeNote(f);
        this.writeSeqLocation(f);
        this.writeXrefs(f);
        this.writeEvidence(f);
        this.writeProperty(f, "qualifier");
        this.writeSubSeqFeature(f);
        this.writeRelatedAnnot(f);
        this.writeTranscript(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</gene>");
        this.mIndent.unIndent();
    }

    protected void writeTranscript(Annotatable f) throws IOException {
        Iterator i = ((FeatureHolder)((Object)f)).features();
        while (i.hasNext()) {
            Feature subf = (Feature)i.next();
            if (!subf.getSource().equalsIgnoreCase("transcript")) continue;
            this.writeTranscript2(subf);
        }
    }

    private void writeTranscript2(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<transcript>");
        this.writeExons(f);
        Iterator i = ((FeatureHolder)((Object)f)).features();
        while (i.hasNext()) {
            Feature subf = (Feature)i.next();
            String type = subf.getSource();
            if (type.equalsIgnoreCase("cds")) {
                this.writeCds(subf);
                continue;
            }
            if (type.equalsIgnoreCase("mrna")) {
                this.writeMrna(subf);
                continue;
            }
            if (!type.equalsIgnoreCase("predicted_protein")) continue;
            this.writePredictedProtein(subf);
        }
        this.mOut.print(this.mIndent);
        this.mOut.println("</transcript>");
        this.mIndent.unIndent();
    }

    private void writeExons(Annotatable f) throws IOException {
        String[] ids = this.mAnnotFilter.getExonIds(f.getAnnotation());
        if (ids != null) {
            this.mIndent.indent();
            this.mOut.print(this.mIndent);
            this.mOut.println("<exons>");
            int i = 0;
            while (i < ids.length) {
                this.mOut.println(this.mIndent + INDENT + "<element_id id=\"" + ids[i] + "\"/>");
                ++i;
            }
            this.mOut.print(this.mIndent);
            this.mOut.println("</exons>");
            this.mIndent.unIndent();
        }
    }

    private void writeCds(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<cds>");
        this.writeBioSequence(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</cds>");
        this.mIndent.unIndent();
    }

    private void writeMrna(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<mrna>");
        this.writeBioSequence(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</mrna>");
        this.mIndent.unIndent();
    }

    private void writePredictedProtein(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.println("<predicted_protein>");
        this.writeBioSequence(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</predicted_protein>");
        this.mIndent.unIndent();
    }

    protected void writeSeqFeature(Annotatable f) throws IOException {
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<seq_feature");
        String s = this.mAnnotFilter.getFeatureType(f.getAnnotation());
        if (s == null) {
            s = ((Feature)f).getType();
        }
        this.mOut.print(" feature_type=\"");
        this.mFilter.write(s == null ? "default" : s);
        this.mOut.print('\"');
        s = this.mAnnotFilter.getElementId(f.getAnnotation());
        if (s != null) {
            this.mOut.print(" element_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getLabel(f.getAnnotation())) != null) {
            this.mOut.print(" label=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        this.mOut.println('>');
        this.writeNote(f);
        this.writeSeqLocation(f);
        this.writeXrefs(f);
        this.writeEvidence(f);
        this.writeProperty(f, "qualifier");
        this.writeSubSeqFeature(f);
        this.writeRelatedAnnot(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</seq_feature>");
        this.mIndent.unIndent();
    }

    private void writeRelatedAnnot(Annotatable f) {
        AGAVERelatedAnnot[] annots = this.mAnnotFilter.getRelatedAnnot(f.getAnnotation());
        if (annots != null) {
            int i = 0;
            while (i < annots.length) {
                this.mOut.print(annots[i].toString(this.mIndent + INDENT, INDENT));
                ++i;
            }
        }
    }

    private void writeEvidence(Annotatable f) throws IOException {
        Iterator i = ((FeatureHolder)((Object)f)).features();
        while (i.hasNext()) {
            Feature subf = (Feature)i.next();
            if (!subf.getSource().equalsIgnoreCase("evidence")) continue;
            this.writeEvidence2(subf);
        }
    }

    private void writeEvidence2(Annotatable f) throws IOException {
        this.writeElementIds(f);
        Iterator i = ((FeatureHolder)((Object)f)).features();
        while (i.hasNext()) {
            Feature subf = (Feature)i.next();
            this.writeCompResult(subf);
        }
    }

    private void writeElementIds(Annotatable f) throws IOException {
        String[] ids = this.mAnnotFilter.getElementIds(f.getAnnotation());
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                this.mOut.println(this.mIndent + INDENT + "<element_id id=\"" + ids[i] + "\"/>");
                ++i;
            }
        }
    }

    protected void writeCompResult(Annotatable f) throws IOException {
        char mark;
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<comp_result");
        String s = this.mAnnotFilter.getResultType(f.getAnnotation());
        this.mOut.print(" result_type=\"");
        this.mFilter.write(s == null ? "default" : s);
        this.mOut.print('\"');
        s = this.mAnnotFilter.getElementId(f.getAnnotation());
        if (s != null) {
            this.mOut.print(" element_id=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        String strand = "false";
        if (f instanceof StrandedFeature && (mark = ((StrandedFeature)f).getStrand().getToken()) == '-') {
            strand = "true";
        }
        this.mOut.print(" on_complement_strand=\"");
        this.mFilter.write(strand);
        this.mOut.print('\"');
        s = this.mAnnotFilter.getGroupOrder(f.getAnnotation());
        if (s != null) {
            this.mOut.print(" group_order=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getFeatureType(f.getAnnotation())) != null) {
            this.mOut.print(" feature_type=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getConfidence(f.getAnnotation())) != null) {
            this.mOut.print(" confidence=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getAlignLength(f.getAnnotation())) != null) {
            this.mOut.print(" align_length=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        if ((s = this.mAnnotFilter.getAlignUnits(f.getAnnotation())) != null) {
            this.mOut.print(" align_units=\"");
            this.mFilter.write(s);
            this.mOut.print('\"');
        }
        this.mOut.println(">");
        this.writeNote(f);
        this.writeMatchDesc(f);
        this.writeMatchAlign(f);
        this.writeQueryRegion(f);
        this.writeMatchRegion(f);
        this.writeProperty(f, "result_property");
        this.writeResultGroup(f);
        this.writeRelatedAnnot(f);
        this.mOut.print(this.mIndent);
        this.mOut.println("</comp_result>");
        this.mIndent.unIndent();
    }

    /*
     * Unable to fully structure code
     */
    private void writeResultGroup(Annotatable f) throws IOException {
        i = ((FeatureHolder)f).features();
        if (i != null) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            subf = (Feature)i.next();
            type = subf.getSource();
            if (type != null && type.equalsIgnoreCase("result_group")) {
                this.mIndent.indent();
                this.mOut.println(this.mIndent + "<result_group>");
                k = subf.features();
                while (k.hasNext()) {
                    this.writeCompResult((Feature)k.next());
                }
                this.mOut.println(this.mIndent + "</result_group>");
                this.mIndent.unIndent();
                continue;
            }
            this.mIndent.indent();
            this.mOut.println(this.mIndent + "<result_group>");
            this.writeCompResult(subf);
            this.mOut.println(this.mIndent + "</result_group>");
            this.mIndent.unIndent();
lbl21:
            // 3 sources

            ** while (i.hasNext())
        }
lbl22:
        // 1 sources

    }

    private void writeQueryRegion(Annotatable f) throws IOException {
        AGAVEQueryRegion s = this.mAnnotFilter.getQueryRegion(f.getAnnotation());
        if (s != null) {
            this.mIndent.indent();
            this.mOut.println(s.toString(this.mIndent.toString(), INDENT));
            this.mIndent.unIndent();
        }
    }

    private void writeMatchRegion(Annotatable f) throws IOException {
        AGAVEMatchRegion s = this.mAnnotFilter.getMatchRegion(f.getAnnotation());
        if (s != null) {
            this.mIndent.indent();
            this.mOut.println(s.toString(this.mIndent.toString(), INDENT));
            this.mIndent.unIndent();
        }
    }

    private void writeMatchAlign(Annotatable f) throws IOException {
        String s = this.mAnnotFilter.getMatchAlign(f.getAnnotation());
        if (s != null) {
            if (s.startsWith("<match_align")) {
                this.mFilter.write(s);
            } else {
                this.mIndent.indent();
                this.mOut.print(this.mIndent);
                this.mOut.print("<match_align>");
                this.mFilter.write(s);
                this.mOut.println("</match_align>");
                this.mIndent.unIndent();
            }
        }
    }

    private void writeMatchDesc(Annotatable f) throws IOException {
        String s = this.mAnnotFilter.getMatchDesc(f.getAnnotation());
        if (s != null) {
            if (s.startsWith("<match_desc")) {
                this.mFilter.write(s);
            } else {
                this.mIndent.indent();
                this.mOut.print(this.mIndent);
                this.mOut.print("<match_desc>");
                this.mFilter.write(s);
                this.mOut.println("</match_desc>");
                this.mIndent.unIndent();
            }
        }
    }

    private void writeSubSeqFeature(Annotatable f) throws IOException {
        Iterator i = ((FeatureHolder)((Object)f)).features();
        while (i.hasNext()) {
            Feature subf = (Feature)i.next();
            if (subf.getSource().equalsIgnoreCase("evidence") || subf.getSource().equalsIgnoreCase("transcript")) continue;
            this.writeSeqFeature(subf);
        }
    }

    private void writeSeqLocation(Annotatable f) throws IOException {
        int min = ((Feature)f).getLocation().getMin();
        int max = ((Feature)f).getLocation().getMax();
        boolean on_complement_strand = false;
        if (f instanceof StrandedFeature) {
            int type = ((StrandedFeature)f).getStrand().getValue();
            if (type == 1) {
                on_complement_strand = false;
            } else if (type == -1) {
                on_complement_strand = true;
            }
        }
        this.mIndent.indent();
        this.mOut.print(this.mIndent);
        this.mOut.print("<seq_location");
        this.mOut.print(" least_start=\"");
        this.mOut.print(min);
        this.mOut.print('\"');
        this.mOut.print(" greatest_end=\"");
        this.mOut.print(max);
        this.mOut.print('\"');
        if (f instanceof StrandedFeature) {
            this.mOut.print(" on_complement_strand=\"");
            this.mOut.print(on_complement_strand ? "true" : "false");
            this.mOut.print('\"');
        }
        this.mOut.print(">");
        this.mOut.print(min + ".." + max);
        this.mOut.println("</seq_location>");
        this.mIndent.unIndent();
    }

    private void writeKeyword(Annotatable f) throws IOException {
        String s = this.mAnnotFilter.getKeyword(f.getAnnotation());
        if (s != null) {
            if (s.startsWith("<keyword")) {
                this.mFilter.write(s);
            } else {
                this.mIndent.indent();
                this.mOut.print(this.mIndent);
                this.mOut.print("<keyword>");
                this.mFilter.write(s);
                this.mOut.println("</keyword>");
                this.mIndent.unIndent();
            }
        }
    }

    private void writeDNA(Annotatable seq) throws IOException {
        int i;
        if (seq instanceof Sequence && (i = ((Sequence)seq).length()) > 0) {
            this.mIndent.indent();
            this.mOut.print(this.mIndent);
            this.mOut.print("<sequence>");
            int j = 0;
            while (j < i / 80) {
                this.mOut.print(((Sequence)seq).subList(80 * j + 1, 80 * (j + 1)).seqString() + "\n");
                ++j;
            }
            this.mOut.print(((Sequence)seq).subList(80 * j + 1, i).seqString());
            this.mOut.println("</sequence>");
            this.mIndent.unIndent();
        }
    }

    private void writeXrefs(Annotatable f) {
        AGAVEXrefs[] xrefs = this.mAnnotFilter.getXrefs(f.getAnnotation());
        if (xrefs != null) {
            this.mIndent.indent();
            int i = 0;
            while (i < xrefs.length) {
                this.mOut.print(xrefs[i].toString(this.mIndent.toString(), INDENT));
                ++i;
            }
            this.mIndent.unIndent();
        }
    }

    private void writeAltIds(Annotatable f) throws IOException {
        AGAVEDbId[] db_id = this.mAnnotFilter.getAltIds(f.getAnnotation());
        if (db_id != null) {
            this.mIndent.indent();
            this.mOut.println(this.mIndent + "<alt_ids>");
            this.mIndent.indent();
            int i = 0;
            while (i < db_id.length) {
                this.mOut.print(db_id[i].toString(this.mIndent.toString(), INDENT));
                ++i;
            }
            this.mIndent.unIndent();
            this.mOut.println(this.mIndent + "</alt_ids>");
            this.mIndent.unIndent();
        }
    }

    private void writeProperty(Annotatable f, String type) {
        AGAVEProperty[] aps = this.mAnnotFilter.getProperty(f.getAnnotation(), type);
        if (aps != null) {
            this.mIndent.indent();
            int index = 0;
            while (index < aps.length) {
                this.mOut.print(aps[index].toString(this.mIndent.toString(), INDENT));
                ++index;
            }
            this.mIndent.unIndent();
        }
    }

    private void writeMapLocation(Annotatable f) throws IOException {
        AGAVEMapLocation[] mls = this.mAnnotFilter.getMapLocation(f.getAnnotation());
        if (mls != null) {
            this.mIndent.indent();
            int i = 0;
            while (i < mls.length) {
                this.mOut.print(mls[i].toString(this.mIndent.toString(), INDENT));
                ++i;
            }
            this.mIndent.unIndent();
        }
    }

    private void writeDbId(Annotatable f) throws IOException {
        AGAVEDbId db_id = this.mAnnotFilter.getDbId(f.getAnnotation());
        if (db_id != null) {
            this.mIndent.indent();
            this.mOut.println(db_id.toString(this.mIndent.toString(), INDENT));
            this.mIndent.unIndent();
        }
    }

    private void writeDescription(Annotatable f) throws IOException {
        String s = this.mAnnotFilter.getDescription(f.getAnnotation());
        if (s != null) {
            if (s.startsWith("<description")) {
                this.mFilter.write(s);
            } else {
                this.mIndent.indent();
                this.mOut.print(this.mIndent);
                this.mOut.print("<description>");
                this.mFilter.write(s);
                this.mOut.println("</description>");
                this.mIndent.unIndent();
            }
        }
    }

    private void writeNote(Annotatable f) throws IOException {
        String note = this.mAnnotFilter.getNote(f.getAnnotation());
        if (note != null) {
            if (note.startsWith("<note")) {
                this.mFilter.write(note);
            } else {
                this.mIndent.indent();
                this.mOut.print(this.mIndent);
                this.mOut.print("<note>");
                this.mFilter.write(note);
                this.mOut.println("</note>");
                this.mIndent.unIndent();
            }
        }
    }

    protected class Indent {
        protected String mIndent = new String("  ");

        protected Indent() {
        }

        public void indent() {
            this.mIndent = this.mIndent + AgaveWriter.INDENT;
        }

        public void unIndent() {
            int iLen;
            int len = this.mIndent.length();
            if (len >= (iLen = AgaveWriter.INDENT.length())) {
                this.mIndent = this.mIndent.substring(0, len - iLen);
            }
        }

        public String toString() {
            return this.mIndent;
        }
    }
}

