/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.TranslationTable;

public class SimpleTranslationTable
implements TranslationTable,
Serializable {
    private final Map transMap;
    private final FiniteAlphabet source;
    private final Alphabet target;

    public Alphabet getSourceAlphabet() {
        return this.source;
    }

    public Alphabet getTargetAlphabet() {
        return this.target;
    }

    public Symbol translate(Symbol sym) throws IllegalSymbolException {
        Symbol s = (Symbol)this.transMap.get(sym);
        if (s == null) {
            if (sym instanceof AtomicSymbol) {
                this.getSourceAlphabet().validate(sym);
                throw new IllegalSymbolException("Unable to map " + sym.getName());
            }
            if (sym == null) {
                throw new NullPointerException("Can't translate null");
            }
            HashSet<Symbol> syms = new HashSet<Symbol>();
            Iterator i = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (i.hasNext()) {
                Symbol is = (Symbol)i.next();
                syms.add(this.translate(is));
            }
            s = this.getTargetAlphabet().getAmbiguity(syms);
        }
        return s;
    }

    public void setTranslation(AtomicSymbol from, AtomicSymbol to) throws IllegalSymbolException {
        this.source.validate(from);
        this.target.validate(to);
        this.transMap.put(from, to);
    }

    public SimpleTranslationTable(FiniteAlphabet source, Alphabet target) {
        this.source = source;
        this.target = target;
        this.transMap = new HashMap();
    }

    public SimpleTranslationTable(FiniteAlphabet source, Alphabet target, Map transMap) {
        this.source = source;
        this.target = target;
        this.transMap = transMap;
    }
}

