/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.cache;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.CacheReference;

public class FixedSizeCache
implements Cache {
    private List objects = new LinkedList();
    private int sizeLimit;

    public FixedSizeCache(int limit) {
        this.sizeLimit = limit;
    }

    public CacheReference makeReference(Object o) {
        FixedSizeCacheReference cr = new FixedSizeCacheReference(o);
        this.objects.add(new WeakReference<FixedSizeCacheReference>(cr));
        while (this.objects.size() > this.sizeLimit) {
            CacheReference old = (CacheReference)((WeakReference)this.objects.remove(0)).get();
            if (old == null) continue;
            old.clear();
        }
        return cr;
    }

    public int getLimit() {
        return this.sizeLimit;
    }

    public void setLimit(int limit) {
        this.sizeLimit = limit;
    }

    private class FixedSizeCacheReference
    implements CacheReference {
        private Object o;

        private FixedSizeCacheReference(Object o) {
            this.o = o;
        }

        public Object get() {
            return this.o;
        }

        public void clear() {
            this.o = null;
        }
    }
}

