/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAAdditional3DAxesDialog;
import org.tigr.util.FloatMatrix;

public class COADummyViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202022010001L;
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private JPopupMenu popup;
    private IFramework framework;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private Experiment experiment;

    public COADummyViewer(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.popup = this.createJPopupMenu();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.geneUMatrix);
        objectOutputStream.writeObject(this.exptUMatrix);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.geneUMatrix = (FloatMatrix)objectInputStream.readObject();
        this.exptUMatrix = (FloatMatrix)objectInputStream.readObject();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Listener listener = new Listener();
        JMenuItem jMenuItem = new JMenuItem("Add new 3-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_3D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add new 2-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_2D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer cOA2DViewer = new COA2DViewer(experiment, this.geneUMatrix, 1, n, n2);
        COA2DViewer cOA2DViewer2 = new COA2DViewer(experiment, this.geneUMatrix, 1, n2, n3);
        COA2DViewer cOA2DViewer3 = new COA2DViewer(experiment, this.geneUMatrix, 1, n, n3);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer, cOA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer2, cOA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer3, cOA2DViewer3.getJPopupMenu())));
        COA2DViewer cOA2DViewer4 = new COA2DViewer(experiment, this.exptUMatrix, 2, n, n2);
        COA2DViewer cOA2DViewer5 = new COA2DViewer(experiment, this.exptUMatrix, 2, n2, n3);
        COA2DViewer cOA2DViewer6 = new COA2DViewer(experiment, this.exptUMatrix, 2, n, n3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer4, cOA2DViewer4.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer5, cOA2DViewer5.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer6, cOA2DViewer6.getJPopupMenu())));
        COA2DViewer cOA2DViewer7 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n, n2);
        COA2DViewer cOA2DViewer8 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n2, n3);
        COA2DViewer cOA2DViewer9 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n, n3);
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer7, cOA2DViewer7.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer8, cOA2DViewer8.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer9, cOA2DViewer9.getJPopupMenu())));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        COA3DViewer cOA3DViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, n, n2, n3);
        COA3DViewer cOA3DViewer2 = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, n, n2, n3);
        COA3DViewer cOA3DViewer3 = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, n, n2, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)cOA3DViewer, cOA3DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)cOA3DViewer2, cOA3DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)cOA3DViewer3, cOA3DViewer3.getJPopupMenu())));
    }

    public void addNew3DNode() {
        COAAdditional3DAxesDialog cOAAdditional3DAxesDialog = new COAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        cOAAdditional3DAxesDialog.setVisible(true);
        if (!cOAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = cOAAdditional3DAxesDialog.getXAxis();
        int n2 = cOAAdditional3DAxesDialog.getYAxis();
        int n3 = cOAAdditional3DAxesDialog.getZAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1) + ", " + (n3 + 1));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("3D Views");
        this.add3DViewNode(this.framework.getFrame(), defaultMutableTreeNode2, this.framework.getData().getExperiment(), n, n2, n3);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(defaultMutableTreeNode3, this.framework.getData().getExperiment(), n, n2, n3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.framework.addNode(this.framework.getCurrentNode(), defaultMutableTreeNode);
    }

    public void addNew2DNode() {
        COAAdditional3DAxesDialog cOAAdditional3DAxesDialog = new COAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        cOAAdditional3DAxesDialog.setZBoxInvisible(true);
        cOAAdditional3DAxesDialog.setVisible(true);
        if (!cOAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = cOAAdditional3DAxesDialog.getXAxis();
        int n2 = cOAAdditional3DAxesDialog.getYAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1));
        COA2DViewer cOA2DViewer = new COA2DViewer(this.framework.getData().getExperiment(), this.geneUMatrix, 1, n, n2);
        COA2DViewer cOA2DViewer2 = new COA2DViewer(this.framework.getData().getExperiment(), this.exptUMatrix, 2, n, n2);
        COA2DViewer cOA2DViewer3 = new COA2DViewer(this.framework.getData().getExperiment(), this.geneUMatrix, this.exptUMatrix, 3, n, n2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Genes", (IViewer)cOA2DViewer, cOA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Expts", (IViewer)cOA2DViewer2, cOA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Both", (IViewer)cOA2DViewer3, cOA2DViewer3.getJPopupMenu())));
        this.framework.addNode(this.framework.getCurrentNode(), defaultMutableTreeNode);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(COADummyViewer.ADD_NEW_3D_CMD)) {
                COADummyViewer.this.addNew3DNode();
            } else if (string.equals(COADummyViewer.ADD_NEW_2D_CMD)) {
                COADummyViewer.this.addNew2DNode();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            COADummyViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

