/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class DAMInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header = this.createHeader();
    private JTextArea content;
    private boolean clusterGenes;
    private int numClasses;
    private int numUsedGenes;
    private int numUnUsedGenes;
    private double alpha;
    private int algorithmSelection;
    private boolean isPDA;
    private boolean preSelectGenes;

    public DAMInfoViewer(int[][] nArray, int n, int n2, int n3, int n4, double d, int n5, boolean bl, boolean bl2) {
        this.clusterGenes = true;
        this.numClasses = n2;
        this.numUsedGenes = n3;
        this.numUnUsedGenes = n4;
        this.alpha = d;
        this.algorithmSelection = n5;
        this.isPDA = bl;
        this.preSelectGenes = bl2;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public DAMInfoViewer(int[][] nArray, int n, boolean bl, int n2, int n3, int n4, double d, int n5, boolean bl2, boolean bl3) {
        this.clusterGenes = bl;
        this.numClasses = n2;
        this.numUsedGenes = n3;
        this.numUnUsedGenes = n4;
        this.alpha = d;
        this.algorithmSelection = n5;
        this.isPDA = bl2;
        this.preSelectGenes = bl3;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        int n2 = this.numUsedGenes + this.numUnUsedGenes;
        if (this.clusterGenes) {
            for (int i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                stringBuffer.append("Class " + (i + 1 - 2 * this.numClasses));
                stringBuffer.append("\t");
                stringBuffer.append("# of Genes in Class: " + nArray[i].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Genes in Class: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            if (this.preSelectGenes) {
                stringBuffer.append("alpha value =" + this.alpha);
                stringBuffer.append("\n\n");
                stringBuffer.append("# of Experiments: " + n2);
                stringBuffer.append("\n");
                stringBuffer.append("# of Selected Experiments: " + this.numUsedGenes);
                stringBuffer.append("\n");
                stringBuffer.append("# of Experiments not Selected: " + this.numUnUsedGenes);
                stringBuffer.append("\n");
            } else {
                stringBuffer.append("No Experiment Screening Applied");
            }
        } else {
            for (int i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                stringBuffer.append("Class " + (i + 1 - 2 * this.numClasses));
                stringBuffer.append("\t");
                stringBuffer.append("# of Experiments in Class: " + nArray[i].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Experiments in Class: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            if (this.preSelectGenes) {
                stringBuffer.append("alpha value =" + this.alpha);
                stringBuffer.append("\n\n");
                stringBuffer.append("# of Genes: " + n2);
                stringBuffer.append("\n");
                stringBuffer.append("# of Selected Genes: " + this.numUsedGenes);
                stringBuffer.append("\n");
                stringBuffer.append("# of Genes not Selected: " + this.numUnUsedGenes);
                stringBuffer.append("\n");
            } else {
                stringBuffer.append("No Gene Screening Applied");
            }
        }
        stringBuffer.append("\n");
        switch (this.algorithmSelection) {
            case 0: {
                stringBuffer.append("Classification Algorithm: A0");
                break;
            }
            case 1: {
                stringBuffer.append("Classification Algorithm: A1");
                break;
            }
            case 2: {
                stringBuffer.append("Classification Algorithm: A2");
                break;
            }
            case 3: {
                stringBuffer.append("Classification Algorithm: Initial Classification");
                break;
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (this.isPDA) {
            stringBuffer.append("Classification Method: PDA");
        } else {
            stringBuffer.append("Classification Method: QDA");
        }
        stringBuffer.append("\n\n");
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

