/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ListOrderDialog
extends AlgorithmDialog {
    int result = 2;
    JList list;
    Vector data;

    public ListOrderDialog(JFrame jFrame, JList jList, Vector vector, String string, String string2) {
        super(jFrame, "List Sorter", true);
        this.list = jList;
        this.data = vector;
        EventListener eventListener = new EventListener();
        ParameterPanel parameterPanel = new ParameterPanel(string);
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        parameterPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jList);
        parameterPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 20, 20, 0), 0, 0));
        ParameterPanel parameterPanel2 = new ParameterPanel("Move");
        parameterPanel2.setLayout(new GridBagLayout());
        JButton jButton = new JButton(GUIFactory.getIcon("arrow_up.gif"));
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setPreferredSize(new Dimension(30, 50));
        jButton.setActionCommand("shift-up-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton(GUIFactory.getIcon("arrow_down.gif"));
        jButton2.setFocusPainted(false);
        jButton2.setPreferredSize(new Dimension(30, 50));
        jButton2.setActionCommand("shift-down-command");
        jButton2.setBorder(BorderFactory.createBevelBorder(0));
        jButton2.addActionListener(eventListener);
        parameterPanel2.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 20), 0, 0));
        parameterPanel2.add((Component)jButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 20), 0, 0));
        parameterPanel.add((Component)parameterPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 5, 20, 20), 0, 0));
        this.addContent(parameterPanel);
        this.setActionListeners(eventListener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Vector getSortedVector() {
        return this.data;
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.add("Label1");
        vector.add("Label2");
        vector.add("Label3");
        JList jList = new JList(vector);
        ListOrderDialog listOrderDialog = new ListOrderDialog(new JFrame(), jList, vector, "Sample Label Keys", "Please Arrange Keys in Desired order.");
        listOrderDialog.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                ListOrderDialog.this.result = 0;
                ListOrderDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                ListOrderDialog.this.result = 2;
                ListOrderDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    ListOrderDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(ListOrderDialog.this, "List Sorter Dialog");
                    ListOrderDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.setVisible(false);
                        helpWindow.dispose();
                    }
                } else if (string.equals("shift-up-command")) {
                    int n = ListOrderDialog.this.list.getSelectedIndex();
                    if (n == 0) {
                        return;
                    }
                    Object e = ListOrderDialog.this.list.getSelectedValue();
                    ListOrderDialog.this.data.remove(e);
                    ListOrderDialog.this.data.insertElementAt(e, n - 1);
                    ListOrderDialog.this.list.setSelectedIndex(n - 1);
                } else if (string.equals("shift-down-command")) {
                    int n = ListOrderDialog.this.list.getSelectedIndex();
                    if (n == ListOrderDialog.this.data.size() - 1) {
                        return;
                    }
                    Object e = ListOrderDialog.this.list.getSelectedValue();
                    ListOrderDialog.this.data.remove(e);
                    ListOrderDialog.this.data.insertElementAt(e, n + 1);
                    ListOrderDialog.this.list.setSelectedIndex(n + 1);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ListOrderDialog.this.result = -1;
            ListOrderDialog.this.dispose();
        }
    }
}

