/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class EASEFileUpdateDialog
extends AlgorithmDialog {
    private JComboBox animalSpeciesBox;
    private JComboBox plantSpeciesBox;
    private JComboBox animalArrayBox;
    private JComboBox plantArrayBox;
    private JLabel animalArrayLabel;
    private JLabel plantArrayLabel;
    private Hashtable plantHash;
    private Hashtable animalHash;
    private Vector plantKeys;
    private Vector animalKeys;
    private JTabbedPane pane;
    private int result = 2;

    public EASEFileUpdateDialog(JFrame jFrame, Vector vector, Hashtable hashtable, Vector vector2, Hashtable hashtable2) {
        super(jFrame, "Ease File Update Selection", true);
        this.plantHash = hashtable;
        this.animalHash = hashtable2;
        this.plantKeys = vector;
        this.animalKeys = vector2;
        Listener listener = new Listener();
        this.plantSpeciesBox = new JComboBox(vector);
        this.plantSpeciesBox.setActionCommand("change-plant-species-command");
        this.plantSpeciesBox.addActionListener(listener);
        this.plantArrayBox = new JComboBox((Vector)((Vector)hashtable.get(vector.elementAt(0))).clone());
        JLabel jLabel = new JLabel("Species");
        jLabel.setOpaque(false);
        this.plantArrayLabel = new JLabel("Arrays for " + (String)vector.elementAt(0));
        this.plantArrayLabel.setOpaque(false);
        this.animalSpeciesBox = new JComboBox(vector2);
        this.animalSpeciesBox.setActionCommand("change-animal-species-command");
        this.animalSpeciesBox.addActionListener(listener);
        this.animalArrayBox = new JComboBox((Vector)((Vector)hashtable2.get(vector2.elementAt(0))).clone());
        JLabel jLabel2 = new JLabel("Species");
        jLabel2.setOpaque(false);
        this.animalArrayLabel = new JLabel("Arrays for " + (String)vector2.elementAt(0));
        this.animalArrayLabel.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.animalSpeciesBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        jPanel.add((Component)this.animalArrayLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.animalArrayBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.plantSpeciesBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        jPanel2.add((Component)this.plantArrayLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.plantArrayBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.pane = new JTabbedPane();
        this.pane.addTab("Animal Arrays", jPanel);
        this.pane.addTab("Plant Arrays", jPanel2);
        this.addContent(this.pane);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.pane.setSelectedIndex(0);
        this.animalSpeciesBox.setSelectedIndex(0);
    }

    public String getArrayName() {
        String string = this.pane.getSelectedIndex() == 0 ? (String)this.animalArrayBox.getSelectedItem() : (String)this.plantArrayBox.getSelectedItem();
        return string;
    }

    public String getSpeciesName() {
        String string = this.pane.getSelectedIndex() == 0 ? (String)this.animalSpeciesBox.getSelectedItem() : (String)this.plantSpeciesBox.getSelectedItem();
        return string;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("change-plant-species-command")) {
                EASEFileUpdateDialog.this.plantArrayBox.removeAllItems();
                Vector vector = (Vector)EASEFileUpdateDialog.this.plantHash.get(EASEFileUpdateDialog.this.plantSpeciesBox.getSelectedItem());
                for (int i = 0; i < vector.size(); ++i) {
                    EASEFileUpdateDialog.this.plantArrayBox.addItem(vector.elementAt(i));
                }
                EASEFileUpdateDialog.this.plantArrayLabel.setText("Arrays for " + (String)EASEFileUpdateDialog.this.plantSpeciesBox.getSelectedItem());
            } else if (string.equals("change-animal-species-command")) {
                EASEFileUpdateDialog.this.animalArrayBox.removeAllItems();
                Vector vector = (Vector)EASEFileUpdateDialog.this.animalHash.get(EASEFileUpdateDialog.this.animalSpeciesBox.getSelectedItem());
                for (int i = 0; i < vector.size(); ++i) {
                    EASEFileUpdateDialog.this.animalArrayBox.addItem(vector.elementAt(i));
                }
                EASEFileUpdateDialog.this.animalArrayLabel.setText("Arrays for " + (String)EASEFileUpdateDialog.this.animalSpeciesBox.getSelectedItem());
            } else if (object == EASEFileUpdateDialog.this.okButton) {
                EASEFileUpdateDialog.this.result = 0;
                EASEFileUpdateDialog.this.dispose();
            } else if (object == EASEFileUpdateDialog.this.cancelButton) {
                EASEFileUpdateDialog.this.result = 2;
                EASEFileUpdateDialog.this.dispose();
            } else if (object == EASEFileUpdateDialog.this.resetButton) {
                EASEFileUpdateDialog.this.resetControls();
            } else if (object == EASEFileUpdateDialog.this.infoButton) {
                HelpWindow helpWindow = new HelpWindow(EASEFileUpdateDialog.this, "EASE File Update Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            EASEFileUpdateDialog.this.result = -1;
            EASEFileUpdateDialog.this.dispose();
        }
    }
}

