/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASECentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASETableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GOTreeViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;

public class EASEGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private AlgorithmData algorithmData;
    private Experiment experiment;
    private Cluster cluster;
    private int[][] clusters;
    private String[] categoryNames;
    private String[][] resultMatrix;
    private boolean haveAccessionNumbers;
    private boolean isClusterAnalysis;
    private Logger logger;
    private Progress progress;
    private Listener listener;
    boolean stop = false;
    private String annotationKeyType;
    private String baseFileSystem;
    boolean isScripting = false;

    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        String[] stringArray;
        String[] stringArray2;
        String string;
        EASEInitDialog eASEInitDialog;
        block12: {
            this.algorithmData = new AlgorithmData();
            ClusterRepository clusterRepository = iFramework.getClusterRepository(0);
            eASEInitDialog = new EASEInitDialog(iFramework.getFrame(), clusterRepository, iFramework.getData().getFieldNames());
            if (eASEInitDialog.showModal() != 0) {
                return null;
            }
            this.listener = new Listener();
            this.logger = new Logger(iFramework.getFrame(), "EASE Analysis", this.listener);
            this.logger.show();
            this.progress = new Progress(iFramework.getFrame(), "Probability Analysis Resampling Progress", this.listener);
            this.baseFileSystem = eASEInitDialog.getBaseFileLocation();
            this.algorithmData.addParam("base-file-system", this.baseFileSystem);
            this.isClusterAnalysis = eASEInitDialog.isClusterModeSelected();
            string = eASEInitDialog.getConverterFileName();
            this.annotationKeyType = eASEInitDialog.getAnnotationKeyType();
            stringArray2 = eASEInitDialog.getAnnToGOFileList();
            int n = eASEInitDialog.getMinClusterSize();
            this.experiment = iFramework.getData().getExperiment();
            if (this.isClusterAnalysis) {
                this.cluster = eASEInitDialog.getSelectedCluster();
                this.experiment = this.cluster.getExperiment();
                int[] nArray = this.cluster.getIndices();
                this.algorithmData.addParam("report-ease-score", String.valueOf(eASEInitDialog.isEaseScoreSelected()));
                boolean bl = eASEInitDialog.isCorrectPvaluesSelected();
                this.algorithmData.addParam("p-value-corrections", String.valueOf(bl));
                if (bl) {
                    this.algorithmData.addParam("bonferroni-correction", String.valueOf(eASEInitDialog.isBonferroniSelected()));
                    this.algorithmData.addParam("bonferroni-step-down-correction", String.valueOf(eASEInitDialog.isStepDownBonferroniSelected()));
                    this.algorithmData.addParam("sidak-correction", String.valueOf(eASEInitDialog.isSidakSelected()));
                }
                this.algorithmData.addParam("run-permutation-analysis", String.valueOf(eASEInitDialog.isPermutationAnalysisSelected()));
                if (eASEInitDialog.isPermutationAnalysisSelected()) {
                    this.algorithmData.addParam("permutation-count", String.valueOf(eASEInitDialog.getPermutationCount()));
                }
                this.logger.append("Extracting Annotation Key Lists\n");
                stringArray = iFramework.getData().getAnnotationList(this.annotationKeyType, nArray);
                this.algorithmData.addStringArray("sample-list", stringArray);
                this.algorithmData.addIntArray("sample-indices", this.cluster.getExperimentIndices());
            }
            if (this.isClusterAnalysis && eASEInitDialog.isPopFileModeSelected()) {
                try {
                    stringArray = this.getPopulationKeysFromFile(eASEInitDialog.getPopulationFileName());
                    this.algorithmData.addParam("population-file-name", eASEInitDialog.getPopulationFileName());
                    if (stringArray == null) {
                        return null;
                    }
                    break block12;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(iFramework.getFrame(), "Error loading population file.", "Population File Load Error", 0);
                    return null;
                }
            }
            stringArray = iFramework.getData().getAnnotationList(this.annotationKeyType, iFramework.getData().getExperiment().getRowMappingArrayCopy());
        }
        this.algorithmData.addParam("perform-cluster-analysis", String.valueOf(this.isClusterAnalysis));
        this.algorithmData.addStringArray("population-list", stringArray);
        if (string != null) {
            this.algorithmData.addParam("converter-file-name", string);
        }
        this.algorithmData.addStringArray("annotation-file-list", stringArray2);
        this.algorithmData.addMatrix("expression", this.experiment.getMatrix());
        String[] stringArray3 = eASEInitDialog.getTrimOptions();
        this.algorithmData.addParam("trim-option", stringArray3[0]);
        this.algorithmData.addParam("trim-value", stringArray3[1]);
        this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("EASE");
        this.algorithm.addAlgorithmListener((AlgorithmListener)this.listener);
        this.algorithm.execute(this.algorithmData);
        if (this.stop) {
            return null;
        }
        this.progress.dispose();
        this.categoryNames = this.algorithmData.getStringArray("category-names");
        this.clusters = this.algorithmData.getIntMatrix("cluster-matrix");
        this.resultMatrix = (String[][])this.algorithmData.getObjectMatrix("result-matrix");
        this.haveAccessionNumbers = this.algorithmData.getParams().getBoolean("have-accession-numbers", false);
        this.logger.append("Creating Result Viewers\n");
        DefaultMutableTreeNode defaultMutableTreeNode = this.resultMatrix == null ? this.createEmptyResultNode(this.algorithmData) : this.createResultNode(this.algorithmData, this.clusters);
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        this.algorithmData = new AlgorithmData();
        EASEInitDialog eASEInitDialog = new EASEInitDialog(iFramework.getFrame(), iFramework.getData().getFieldNames());
        if (eASEInitDialog.showModal() != 0) {
            return null;
        }
        this.baseFileSystem = eASEInitDialog.getBaseFileLocation();
        this.algorithmData.addParam("base-file-system", this.baseFileSystem);
        this.isClusterAnalysis = eASEInitDialog.isClusterModeSelected();
        String string = eASEInitDialog.getConverterFileName();
        this.annotationKeyType = eASEInitDialog.getAnnotationKeyType();
        this.algorithmData.addParam("annotation-key-type", this.annotationKeyType);
        String[] stringArray = eASEInitDialog.getAnnToGOFileList();
        int n = eASEInitDialog.getMinClusterSize();
        this.experiment = iFramework.getData().getExperiment();
        if (this.isClusterAnalysis) {
            this.algorithmData.addParam("report-ease-score", String.valueOf(eASEInitDialog.isEaseScoreSelected()));
            boolean bl = eASEInitDialog.isCorrectPvaluesSelected();
            this.algorithmData.addParam("p-value-corrections", String.valueOf(bl));
            if (bl) {
                this.algorithmData.addParam("bonferroni-correction", String.valueOf(eASEInitDialog.isBonferroniSelected()));
                this.algorithmData.addParam("bonferroni-step-down-correction", String.valueOf(eASEInitDialog.isStepDownBonferroniSelected()));
                this.algorithmData.addParam("sidak-correction", String.valueOf(eASEInitDialog.isSidakSelected()));
            }
            this.algorithmData.addParam("run-permutation-analysis", String.valueOf(eASEInitDialog.isPermutationAnalysisSelected()));
            if (eASEInitDialog.isPermutationAnalysisSelected()) {
                this.algorithmData.addParam("permutation-count", String.valueOf(eASEInitDialog.getPermutationCount()));
            }
        }
        if (this.isClusterAnalysis && eASEInitDialog.isPopFileModeSelected()) {
            this.algorithmData.addParam("population-file-name", eASEInitDialog.getPopulationFileName());
        }
        this.algorithmData.addParam("perform-cluster-analysis", String.valueOf(this.isClusterAnalysis));
        if (string != null) {
            this.algorithmData.addParam("converter-file-name", string);
        }
        this.algorithmData.addStringArray("annotation-file-list", stringArray);
        String[] stringArray2 = eASEInitDialog.getTrimOptions();
        this.algorithmData.addParam("trim-option", stringArray2[0]);
        this.algorithmData.addParam("trim-value", stringArray2[1]);
        this.algorithmData.addParam("name", "EASE");
        this.algorithmData.addParam("alg-type", "cluster-genes");
        this.algorithmData.addParam("output-class", "multi-gene-cluster-output");
        String[] stringArray3 = new String[]{"Multi-cluster"};
        this.algorithmData.addStringArray("output-nodes", stringArray3);
        return this.algorithmData;
    }

    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        Object object;
        String[] stringArray;
        block9: {
            Object object2;
            this.isScripting = true;
            this.algorithmData = algorithmData;
            this.experiment = experiment;
            algorithmData.addMatrix("expression", iFramework.getData().getExperiment().getMatrix());
            AlgorithmParameters algorithmParameters = algorithmData.getParams();
            this.isClusterAnalysis = algorithmParameters.getBoolean("perform-cluster-analysis");
            this.annotationKeyType = algorithmParameters.getString("annotation-key-type");
            this.listener = new Listener();
            this.logger = new Logger(iFramework.getFrame(), "EASE Analysis", this.listener);
            this.logger.show();
            this.progress = new Progress(iFramework.getFrame(), "Probability Analysis Resampling Progress", this.listener);
            if (this.isClusterAnalysis) {
                object2 = experiment.getRowMappingArrayCopy();
                stringArray = iFramework.getData().getAnnotationList(this.annotationKeyType, object2);
                algorithmData.addStringArray("sample-list", stringArray);
                object = new int[((int[])object2).length];
                for (int i = 0; i < ((int[])object2).length; ++i) {
                    object[i] = i;
                }
                algorithmData.addIntArray("sample-indices", (int[])object);
            }
            object2 = algorithmParameters.getString("population-file-name");
            if (this.isClusterAnalysis && object2 != null) {
                try {
                    stringArray = this.getPopulationKeysFromFile(algorithmParameters.getString("population-file-name"));
                    if (stringArray == null) {
                        return null;
                    }
                    break block9;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(iFramework.getFrame(), "Error loading population file.", "Population File Load Error", 0);
                    return null;
                }
            }
            stringArray = iFramework.getData().getAnnotationList(this.annotationKeyType, iFramework.getData().getExperiment().getRowMappingArrayCopy());
        }
        algorithmData.addStringArray("population-list", stringArray);
        this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("EASE");
        this.algorithm.addAlgorithmListener((AlgorithmListener)this.listener);
        this.algorithm.execute(this.algorithmData);
        if (this.stop) {
            return null;
        }
        this.progress.dispose();
        this.categoryNames = this.algorithmData.getStringArray("category-names");
        this.clusters = this.algorithmData.getIntMatrix("cluster-matrix");
        this.resultMatrix = (String[][])this.algorithmData.getObjectMatrix("result-matrix");
        this.haveAccessionNumbers = this.algorithmData.getParams().getBoolean("have-accession-numbers", false);
        this.logger.append("Creating Result Viewers\n");
        object = this.resultMatrix == null ? (Object)this.createEmptyResultNode(this.algorithmData) : (Object)this.createResultNode(this.algorithmData, this.clusters);
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return object;
    }

    private String[] getPopulationKeysFromFile(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<String> vector = new Vector<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        return null;
    }

    private DefaultMutableTreeNode createResultNode(AlgorithmData algorithmData, int[][] nArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.isClusterAnalysis ? new DefaultMutableTreeNode("EASE Analysis") : new DefaultMutableTreeNode("EASE Survey");
        this.addTableViewer(defaultMutableTreeNode, algorithmData);
        this.addExpressionViewers(defaultMutableTreeNode, algorithmData);
        this.addGeneralInfo(defaultMutableTreeNode, algorithmData);
        if (this.isClusterAnalysis) {
            this.addGOTree(defaultMutableTreeNode, algorithmData);
        }
        return defaultMutableTreeNode;
    }

    private void addGOTree(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        GOTreeViewer gOTreeViewer;
        String[][] stringArray = (String[][])algorithmData.getObjectMatrix("result-matrix");
        String[] stringArray2 = algorithmData.getStringArray("header-names");
        String string = new String("");
        for (int i = 0; i < this.categoryNames.length; ++i) {
            string = string + this.categoryNames[i];
        }
        if (string.indexOf("GO Biological Process") != -1) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            gOTreeViewer = new GOTreeViewer("GO Biological Process", stringArray2, stringArray, defaultMutableTreeNode, this.baseFileSystem);
            defaultMutableTreeNode2.setUserObject(new LeafInfo("GO Hierarchy -- Biological Process", (IViewer)gOTreeViewer));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        if (string.indexOf("GO Cellular Component") != -1) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode();
            gOTreeViewer = new GOTreeViewer("GO Cellular Component", stringArray2, stringArray, defaultMutableTreeNode, this.baseFileSystem);
            defaultMutableTreeNode3.setUserObject(new LeafInfo("GO Hierarchy -- Cellular Component", (IViewer)gOTreeViewer));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
        if (string.indexOf("GO Molecular Function") != -1) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode();
            gOTreeViewer = new GOTreeViewer("GO Molecular Function", stringArray2, stringArray, defaultMutableTreeNode, this.baseFileSystem);
            defaultMutableTreeNode4.setUserObject(new LeafInfo("GO Hierarchy -- Molecular Function", (IViewer)gOTreeViewer));
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
        }
    }

    private DefaultMutableTreeNode createEmptyResultNode(AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("EASE");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("No Annotation Hits"));
        this.addGeneralInfo(defaultMutableTreeNode, algorithmData);
        return defaultMutableTreeNode;
    }

    private void addExpressionViewers(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Viewers");
        EASEExperimentViewer eASEExperimentViewer = new EASEExperimentViewer(this.experiment, this.clusters);
        EASECentroidViewer eASECentroidViewer = new EASECentroidViewer(this.experiment, this.clusters);
        eASECentroidViewer.setMeans(algorithmData.getMatrix((String)"means").A);
        eASECentroidViewer.setVariances(algorithmData.getMatrix((String)"variances").A);
        for (int i = 0; i < this.clusters.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Term " + String.valueOf(i + 1));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)eASEExperimentViewer, (Object)new Integer(i))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)eASECentroidViewer, (Object)new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)eASECentroidViewer, (Object)new CentroidUserObject(i, 1))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(this.resultMatrix[i][1]));
            if (this.haveAccessionNumbers) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(this.resultMatrix[i][2]));
            }
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Number of Genes: " + this.clusters[i].length));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addTableViewer(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        Object[][] objectArray = algorithmData.getObjectMatrix("result-matrix");
        String[] stringArray = algorithmData.getStringArray("header-names");
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        EASETableViewer eASETableViewer = new EASETableViewer(stringArray, objectArray, defaultMutableTreeNode, this.experiment, this.clusters, this.haveAccessionNumbers, this.isClusterAnalysis);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Table Viewer", (IViewer)eASETableViewer));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[] getDataIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("General Information");
        String string = algorithmData.getParams().getString("converter-file-name");
        if (this.isClusterAnalysis && !this.isScripting) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Input Cluster Info");
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Serial # :" + String.valueOf(this.cluster.getSerialNumber())));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Source: " + String.valueOf(this.cluster.getSource())));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Analysis Node: " + String.valueOf(this.cluster.getAlgorithmName())));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Cluster Node: " + String.valueOf(this.cluster.getClusterID())));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Label: " + String.valueOf(this.cluster.getClusterLabel())));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Cluster Size: " + String.valueOf(this.cluster.getSize())));
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if (this.isScripting) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Input Data: Script Data Input");
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Analysis Options");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Selected Index and Files");
        String string2 = algorithmData.getParams().getString("population-file-name");
        if (string2 == null) {
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Population Selection: Data in Current Viewer"));
        } else {
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Population Selection: File Input (" + string2 + ")"));
        }
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("MeV Index: " + this.annotationKeyType));
        AlgorithmParameters algorithmParameters = this.algorithmData.getParams();
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Conversion File: " + algorithmParameters.getString("converter-file-name", "Not Selected")));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Annotation-to-Theme Files");
        String[] stringArray = this.algorithmData.getStringArray("annotation-file-list");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("File: " + stringArray[i]));
            }
        }
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        if (this.isClusterAnalysis || !algorithmParameters.getString("trim-option").equals("NO_TRIM")) {
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Stat Parameters");
            if (this.isClusterAnalysis) {
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Reported Statistic:" + (algorithmParameters.getBoolean("report-ease-score") ? "EASE Score" : "Fisher's Exact")));
                if (algorithmParameters.getBoolean("bonferroni-correction", false)) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Mult.-Correct.: Bonferroni"));
                }
                if (algorithmParameters.getBoolean("bonferroni-step-down-correction", false)) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Mult.-Correct.: Bonferroni Step Down"));
                }
                if (algorithmParameters.getBoolean("sidak-correction", false)) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Mult.-Correct.: Sidak Method"));
                }
            }
            if (!algorithmParameters.getString("trim-option").equals("NO_TRIM")) {
                if (algorithmParameters.getString("trim-option").equals("N_TRIM")) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Trim out if hit number < " + algorithmParameters.getInt("trim-value")));
                } else {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Trim out if hit percent < " + algorithmParameters.getInt("trim-value")));
                }
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode6);
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        String eventDescription;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                System.out.println("abort execution");
                EASEGUI.this.stop = true;
                EASEGUI.this.algorithm.abort();
                EASEGUI.this.progress.dispose();
                EASEGUI.this.logger.dispose();
            }
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            if (algorithmEvent.getId() == 3) {
                EASEGUI.this.logger.append(algorithmEvent.getDescription());
            } else {
                this.eventDescription = algorithmEvent.getDescription();
                if (this.eventDescription.equals("SET_VALUE")) {
                    EASEGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    return;
                }
                if (this.eventDescription.equals("SET_UNITS")) {
                    EASEGUI.this.progress.setDescription("Resampling Analysis Iterations");
                    EASEGUI.this.progress.setValue(0);
                    EASEGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    EASEGUI.this.progress.show();
                    Point point = EASEGUI.this.progress.getLocation();
                    Point point2 = EASEGUI.this.logger.getLocation();
                    EASEGUI.this.progress.setLocation(point.x, point2.y - EASEGUI.this.progress.getHeight());
                    return;
                }
                EASEGUI.this.progress.setVisible(false);
                EASEGUI.this.progress.dispose();
            }
        }
    }
}

