/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEUpdateManager;

public class EASEInitDialog
extends AlgorithmDialog {
    private int result = 2;
    ConfigPanel configPanel;
    ModePanel modePanel;
    PopSelectionPanel popPanel;
    ClusterBrowser browser;
    EventListener listener;
    EaseParameterPanel easeParamPanel;
    AlphaPanel alphaPanel;
    JTabbedPane tabbedPane;
    Font font;
    String sep;
    Frame parent;

    public EASEInitDialog(Frame frame, ClusterRepository clusterRepository, String[] stringArray) {
        super(frame, "EASE: EASE Annotation Analysis", true);
        this.parent = frame;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.popPanel = new PopSelectionPanel();
        this.browser = new ClusterBrowser(clusterRepository);
        jPanel.add((Component)this.popPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", jPanel);
        this.easeParamPanel = new EaseParameterPanel(stringArray);
        this.tabbedPane.add("Annotation Parameters", this.easeParamPanel);
        this.alphaPanel = new AlphaPanel();
        this.tabbedPane.add("Statistical Parameters", this.alphaPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        this.modePanel = new ModePanel(clusterRepository != null && !clusterRepository.isEmpty());
        jPanel2.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel2);
        this.setActionListeners(this.listener);
        if (clusterRepository == null || clusterRepository.isEmpty()) {
            Component component = this.tabbedPane.getComponentAt(0);
            JPanel jPanel3 = (JPanel)component;
            jPanel3.removeAll();
            jPanel3.validate();
            jPanel3.setOpaque(false);
            jPanel3.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
            jPanel3.add((Component)new JLabel("Only Annotation Survey is Enabled"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tabbedPane.setSelectedIndex(1);
        }
        this.setSize(570, 750);
    }

    public EASEInitDialog(Frame frame, String[] stringArray) {
        super(frame, "EASE: EASE Annotation Analysis", true);
        this.parent = frame;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.popPanel = new PopSelectionPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        String string = "<center><b>Note: When running EASE in script mode the cluster<br>";
        string = string + "under analysis is determined by the preceding algorithm<br>";
        string = string + "that feeds source data into EASE.</center>";
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(Color.lightGray);
        jTextPane.setContentType("text/html");
        jTextPane.setText(string);
        jPanel2.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.popPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", jPanel);
        this.easeParamPanel = new EaseParameterPanel(stringArray);
        this.tabbedPane.add("Annotation Parameters", this.easeParamPanel);
        this.alphaPanel = new AlphaPanel();
        this.tabbedPane.add("Statistical Parameters", this.alphaPanel);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBackground(Color.white);
        this.modePanel = new ModePanel(true);
        jPanel3.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel3);
        this.setActionListeners(this.listener);
        this.setSize(570, 750);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
    }

    public boolean isClusterModeSelected() {
        return this.modePanel.clusterAnalysisButton.isSelected();
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public boolean isPopFileModeSelected() {
        return this.popPanel.fileButton.isSelected();
    }

    public String getPopulationFileName() {
        return this.popPanel.getPopFile();
    }

    public String getConverterFileName() {
        return this.easeParamPanel.getConverterFileName();
    }

    public int getMinClusterSize() {
        String string = this.easeParamPanel.minClusterSizeField.getText();
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getBaseFileLocation() {
        return this.configPanel.getBaseFileLocation();
    }

    public String getAnnotationKeyType() {
        return this.easeParamPanel.getAnnotationKeyType();
    }

    public String[] getAnnToGOFileList() {
        return this.easeParamPanel.getAnnToGOFileList();
    }

    public boolean isEaseScoreSelected() {
        return this.alphaPanel.easeBox.isSelected();
    }

    public boolean isCorrectPvaluesSelected() {
        return this.isBonferroniSelected() || this.isStepDownBonferroniSelected() || this.isSidakSelected();
    }

    public boolean isBonferroniSelected() {
        return this.alphaPanel.bonferroniBox.isSelected();
    }

    public boolean isStepDownBonferroniSelected() {
        return this.alphaPanel.bonferroniStepBox.isSelected();
    }

    public boolean isSidakSelected() {
        return this.alphaPanel.sidakBox.isSelected();
    }

    public boolean isPermutationAnalysisSelected() {
        return this.alphaPanel.permBox.isSelected();
    }

    public int getPermutationCount() {
        return Integer.parseInt(this.alphaPanel.permField.getText());
    }

    public String[] getTrimOptions() {
        String[] stringArray = new String[2];
        if (this.alphaPanel.trimBox.isSelected()) {
            if (this.alphaPanel.trimPercentBox.isSelected()) {
                stringArray[0] = "PERCENT_TRIM";
                stringArray[1] = this.alphaPanel.trimPercentField.getText();
            } else {
                stringArray[0] = "N_TRIM";
                stringArray[1] = this.alphaPanel.trimNField.getText();
            }
        } else {
            stringArray[0] = "NO_TRIM";
            stringArray[1] = "0";
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"TC#", "GB#", "Role"};
        EASEInitDialog eASEInitDialog = new EASEInitDialog((Frame)new JFrame(), stringArray2);
        eASEInitDialog.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("use-converter-command")) {
                if (EASEInitDialog.this.easeParamPanel.useAnnBox.isSelected()) {
                    EASEInitDialog.this.easeParamPanel.browserButton.setEnabled(true);
                    EASEInitDialog.this.easeParamPanel.converterFileField.setEnabled(true);
                    EASEInitDialog.this.easeParamPanel.converterFileField.setBackground(Color.white);
                    EASEInitDialog.this.easeParamPanel.fileLabel.setEnabled(true);
                } else {
                    EASEInitDialog.this.easeParamPanel.browserButton.setEnabled(false);
                    EASEInitDialog.this.easeParamPanel.converterFileField.setEnabled(false);
                    EASEInitDialog.this.easeParamPanel.converterFileField.setBackground(Color.lightGray);
                    EASEInitDialog.this.easeParamPanel.fileLabel.setEnabled(false);
                }
            } else {
                if (string.equals("converter-file-browser-command")) {
                    File file = new File(EASEInitDialog.this.getBaseFileLocation() + "/Data/Convert");
                    JFileChooser jFileChooser = new JFileChooser(file);
                    jFileChooser.setDialogTitle("Annotation Converter Selection");
                    jFileChooser.setMultiSelectionEnabled(false);
                    if (jFileChooser.showOpenDialog(EASEInitDialog.this.parent) == 0) {
                        EASEInitDialog.this.easeParamPanel.updateConverterFileField(jFileChooser.getSelectedFile().getPath());
                    }
                    return;
                }
                if (string.equals("ann-file-browser-command")) {
                    File file = new File(EASEInitDialog.this.getBaseFileLocation() + "/Data/Class/");
                    JFileChooser jFileChooser = new JFileChooser(file);
                    jFileChooser.setDialogTitle("Annotation --> GO Term, File(s) Selection");
                    jFileChooser.setMultiSelectionEnabled(true);
                    if (jFileChooser.showOpenDialog(EASEInitDialog.this.parent) == 0) {
                        EASEInitDialog.this.easeParamPanel.updateAnnFileList(jFileChooser.getSelectedFiles());
                        EASEInitDialog.this.easeParamPanel.removeButton.setEnabled(true);
                        EASEInitDialog.this.okButton.setEnabled(true);
                    }
                } else if (string.equals("remove-ann-file-command")) {
                    EASEInitDialog.this.easeParamPanel.removeSelectedFiles();
                } else if (string.equals("permutation-analysis-command")) {
                    EASEInitDialog.this.alphaPanel.setEnablePermutations();
                } else if (string.equals("trim-result-command")) {
                    EASEInitDialog.this.alphaPanel.validateTrimOptions();
                } else if (string.equals("select-file-base-command")) {
                    EASEInitDialog.this.configPanel.selectFileSystem();
                } else if (string.equals("update-files-command")) {
                    EASEUpdateManager eASEUpdateManager = new EASEUpdateManager((JFrame)EASEInitDialog.this.parent);
                    eASEUpdateManager.updateFiles();
                } else if (string.equals("ok-command")) {
                    String string2;
                    EASEInitDialog.this.result = 0;
                    if (EASEInitDialog.this.isClusterModeSelected() && EASEInitDialog.this.popPanel.fileButton.isSelected() && ((string2 = EASEInitDialog.this.popPanel.popField.getText()) == null || string2.equals("") || string2.equals(" "))) {
                        JOptionPane.showMessageDialog(EASEInitDialog.this.parent, "You have selected to use a population file but have not entered a file name.  \nPlease enter a file or use the file browser to select a file.", "EASE Initialization: Missing Parameter", 2);
                        EASEInitDialog.this.tabbedPane.setSelectedIndex(0);
                        EASEInitDialog.this.popPanel.popField.grabFocus();
                        EASEInitDialog.this.popPanel.popField.selectAll();
                        EASEInitDialog.this.popPanel.popField.setCaretPosition(0);
                        return;
                    }
                    if (EASEInitDialog.this.getAnnToGOFileList().length == 0) {
                        JOptionPane.showMessageDialog(EASEInitDialog.this.parent, "You have not selected any gene annotation/gene ontology linking files. \nPlease enter files or use the browser to select files.", "EASE Initialization: Missing Parameter", 2);
                        EASEInitDialog.this.tabbedPane.setSelectedIndex(1);
                        EASEInitDialog.this.easeParamPanel.browserButton.grabFocus();
                        return;
                    }
                    if (EASEInitDialog.this.easeParamPanel.useAnnBox.isSelected() && ((string2 = EASEInitDialog.this.easeParamPanel.getConverterFileName()) == null || string2.equals("") || string2.equals(" "))) {
                        JOptionPane.showMessageDialog(EASEInitDialog.this.parent, "You have selected to use an annotation conversion file but have not made a file selection.\nPlease enter a file name or browse to select a file.", "EASE Initialization: Missing Parameter", 2);
                        EASEInitDialog.this.tabbedPane.setSelectedIndex(1);
                        EASEInitDialog.this.easeParamPanel.browserButton.grabFocus();
                        return;
                    }
                    EASEInitDialog.this.dispose();
                } else if (string.equals("cancel-command")) {
                    EASEInitDialog.this.result = 2;
                    EASEInitDialog.this.dispose();
                } else {
                    if (string.equals("reset-command")) {
                        EASEInitDialog.this.resetControls();
                        EASEInitDialog.this.result = 2;
                        return;
                    }
                    if (string.equals("info-command")) {
                        HelpWindow helpWindow = new HelpWindow(EASEInitDialog.this, "EASE Initialization Dialog");
                        EASEInitDialog.this.result = 2;
                        if (helpWindow.getWindowContent()) {
                            helpWindow.setSize(600, 600);
                            helpWindow.setLocation();
                            helpWindow.show();
                        } else {
                            helpWindow.setVisible(false);
                            helpWindow.dispose();
                        }
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            EASEInitDialog.this.result = -1;
            EASEInitDialog.this.dispose();
        }
    }

    private class ConfigPanel
    extends ParameterPanel {
        JTextField defaultFileBaseLocation;

        public ConfigPanel() {
            super("File Updates and Configuration");
            this.setLayout(new GridBagLayout());
            JButton jButton = new JButton("Update EASE File System");
            jButton.setActionCommand("update-files-command");
            jButton.setFocusPainted(false);
            jButton.addActionListener(EASEInitDialog.this.listener);
            jButton.setToolTipText("<html>Downloads EASE annotation files<br>for a selected species and array type.</html>");
            JButton jButton2 = new JButton("Select EASE File System");
            jButton2.setActionCommand("select-file-base-command");
            jButton2.setFocusPainted(false);
            jButton2.addActionListener(EASEInitDialog.this.listener);
            jButton2.setToolTipText("<html>Helps select the EASE annotation file system<br>that corresponds the current species and array type.</html>");
            this.defaultFileBaseLocation = new JTextField(TMEV.getFile((String)"data/ease").getAbsolutePath(), 25);
            this.defaultFileBaseLocation.setEditable(true);
            this.add((Component)jButton2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this.defaultFileBaseLocation, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        public void selectFileSystem() {
            String string = this.defaultFileBaseLocation.getText();
            File file = new File(string);
            if (!file.exists() && (file = TMEV.getFile((String)"data/ease")) == null) {
                file = new File(System.getProperty("user.dir"));
            }
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(EASEInitDialog.this) == 0) {
                this.defaultFileBaseLocation.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }

        public String getBaseFileLocation() {
            return this.defaultFileBaseLocation.getText();
        }
    }

    private class AlphaPanel
    extends JPanel {
        private JCheckBox fisherBox;
        private JCheckBox easeBox;
        private JCheckBox bonferroniBox;
        private JCheckBox sidakBox;
        private JCheckBox bonferroniStepBox;
        private JCheckBox permBox;
        private JTextField permField;
        private JLabel permLabel;
        private JCheckBox trimBox;
        private JCheckBox trimNBox;
        private JLabel trimNLabel;
        private JTextField trimNField;
        private JCheckBox trimPercentBox;
        private JLabel trimPercentLabel;
        private JTextField trimPercentField;

        public AlphaPanel() {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(Color.white);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reported Statistic", 0, 0, EASEInitDialog.this.font, Color.black));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.fisherBox = new JCheckBox("Fisher Exact Probability", true);
            this.fisherBox.setBackground(Color.white);
            this.fisherBox.setFocusPainted(false);
            buttonGroup.add(this.fisherBox);
            this.easeBox = new JCheckBox("EASE Score", false);
            this.easeBox.setBackground(Color.white);
            this.easeBox.setFocusPainted(false);
            buttonGroup.add(this.easeBox);
            jPanel.add((Component)this.fisherBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.easeBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBackground(Color.white);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Multiplicity Corrections", 0, 0, EASEInitDialog.this.font, Color.black));
            this.bonferroniBox = new JCheckBox("Bonferroni Correction", false);
            this.bonferroniBox.setBackground(Color.white);
            this.bonferroniBox.setFocusPainted(false);
            this.bonferroniStepBox = new JCheckBox("Bonferroni Step Down Correction", false);
            this.bonferroniStepBox.setBackground(Color.white);
            this.bonferroniStepBox.setFocusPainted(false);
            this.sidakBox = new JCheckBox("Sidak Method", false);
            this.sidakBox.setBackground(Color.white);
            this.sidakBox.setFocusPainted(false);
            this.permBox = new JCheckBox("Resampling Probability Analysis", false);
            this.permBox.setActionCommand("permutation-analysis-command");
            this.permBox.setBackground(Color.white);
            this.permBox.setFocusPainted(false);
            this.permBox.addActionListener(EASEInitDialog.this.listener);
            this.permField = new JTextField("1000", 10);
            this.permField.setBackground(Color.white);
            this.permLabel = new JLabel("Number of Permutations");
            this.permLabel.setBackground(Color.white);
            jPanel2.add((Component)this.bonferroniBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            jPanel2.add((Component)this.sidakBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            jPanel2.add((Component)this.bonferroniStepBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
            jPanel2.add((Component)this.permBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            jPanel2.add((Component)this.permLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
            jPanel2.add((Component)this.permField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 15, 0), 0, 0));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBackground(Color.white);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Trim Parameters", 0, 0, EASEInitDialog.this.font, Color.black));
            this.trimBox = new JCheckBox("Trim Resulting Groups", false);
            this.trimBox.setActionCommand("trim-result-command");
            this.trimBox.addActionListener(EASEInitDialog.this.listener);
            this.trimBox.setBackground(Color.white);
            this.trimBox.setHorizontalAlignment(0);
            this.trimBox.setFocusPainted(false);
            buttonGroup = new ButtonGroup();
            this.trimNBox = new JCheckBox("Select Minimum Hit Number", true);
            this.trimNBox.setActionCommand("trim-result-command");
            this.trimNBox.addActionListener(EASEInitDialog.this.listener);
            this.trimNBox.setEnabled(false);
            this.trimNBox.setBackground(Color.white);
            this.trimNBox.setFocusPainted(false);
            buttonGroup.add(this.trimNBox);
            this.trimNLabel = new JLabel("Min. Hits");
            this.trimNLabel.setBackground(Color.white);
            this.trimNLabel.setEnabled(false);
            this.trimNField = new JTextField("5", 10);
            this.trimNField.setEnabled(false);
            this.trimPercentBox = new JCheckBox("Select Minimum Hit Percentage", false);
            this.trimPercentBox.setActionCommand("trim-result-command");
            this.trimPercentBox.addActionListener(EASEInitDialog.this.listener);
            this.trimPercentBox.setEnabled(false);
            this.trimPercentBox.setBackground(Color.white);
            this.trimPercentBox.setFocusPainted(false);
            buttonGroup.add(this.trimPercentBox);
            this.trimPercentLabel = new JLabel("Percent Hits");
            this.trimPercentLabel.setBackground(Color.white);
            this.trimPercentLabel.setEnabled(false);
            this.trimPercentField = new JTextField("5", 10);
            this.trimPercentField.setEnabled(false);
            jPanel3.add((Component)this.trimBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            jPanel3.add((Component)this.trimNBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel3.add((Component)this.trimNLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 20, 0, 15), 0, 0));
            jPanel3.add((Component)this.trimNField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel3.add((Component)this.trimPercentBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            jPanel3.add((Component)this.trimPercentLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 20, 0, 15), 0, 0));
            jPanel3.add((Component)this.trimPercentField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean performPermutations() {
            return this.permBox.isSelected();
        }

        public void setEnablePermutations() {
            this.permLabel.setEnabled(this.permBox.isSelected());
            this.permField.setEnabled(this.permBox.isSelected());
        }

        public void validateTrimOptions() {
            if (this.trimBox.isSelected()) {
                this.trimNBox.setEnabled(true);
                this.trimPercentBox.setEnabled(true);
                this.trimNLabel.setEnabled(this.trimNBox.isSelected());
                this.trimNField.setEnabled(this.trimNBox.isSelected());
                this.trimPercentLabel.setEnabled(!this.trimNBox.isSelected());
                this.trimPercentField.setEnabled(!this.trimNBox.isSelected());
            } else {
                this.trimNBox.setEnabled(false);
                this.trimPercentBox.setEnabled(false);
                this.trimNLabel.setEnabled(false);
                this.trimNField.setEnabled(false);
                this.trimPercentLabel.setEnabled(false);
                this.trimPercentField.setEnabled(false);
            }
        }
    }

    private class EaseParameterPanel
    extends JPanel {
        JTextField converterFileField;
        JList fileList;
        JButton browserButton;
        JTextField minClusterSizeField;
        JComboBox fieldNamesBox;
        JList annFileList;
        Vector annVector;
        JButton removeButton;
        JCheckBox useAnnBox;
        JLabel fileLabel;

        public EaseParameterPanel(String[] stringArray) {
            Serializable serializable;
            Object object;
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(Color.white);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Annotation Conversion File", 0, 0, EASEInitDialog.this.font, Color.black));
            this.useAnnBox = new JCheckBox("use annotation converter", false);
            this.useAnnBox.setActionCommand("use-converter-command");
            this.useAnnBox.addActionListener(EASEInitDialog.this.listener);
            this.useAnnBox.setBackground(Color.white);
            this.useAnnBox.setFocusPainted(false);
            this.converterFileField = new JTextField(30);
            this.converterFileField.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
            this.converterFileField.setEnabled(false);
            this.converterFileField.setBackground(Color.lightGray);
            this.browserButton = new JButton("File Browser");
            this.browserButton.setActionCommand("converter-file-browser-command");
            this.browserButton.setFocusPainted(false);
            this.browserButton.setPreferredSize(new Dimension(150, 25));
            this.browserButton.setSize(150, 25);
            this.browserButton.addActionListener(EASEInitDialog.this.listener);
            this.browserButton.setEnabled(false);
            this.fileLabel = new JLabel("File :");
            this.fileLabel.setEnabled(false);
            jPanel.add((Component)this.useAnnBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 15, 0), 0, 0));
            jPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            jPanel.add((Component)this.browserButton, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 15, 0, 0), 0, 0));
            jPanel.add((Component)this.converterFileField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBackground(Color.white);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Annotation / Gene Ontology Linking Files", 0, 0, EASEInitDialog.this.font, Color.black));
            this.annVector = new Vector();
            this.annFileList = new JList(new DefaultListModel());
            this.annFileList.setCellRenderer(new ListRenderer());
            this.annFileList.setBorder(BorderFactory.createBevelBorder(1));
            JScrollPane jScrollPane = new JScrollPane(this.annFileList);
            JButton jButton = new JButton("Add Files");
            jButton.setActionCommand("ann-file-browser-command");
            jButton.addActionListener(EASEInitDialog.this.listener);
            jButton.setFocusPainted(false);
            jButton.setPreferredSize(new Dimension(150, 25));
            jButton.setSize(150, 25);
            this.removeButton = new JButton("Remove Selected");
            this.removeButton.setActionCommand("remove-ann-file-command");
            this.removeButton.addActionListener(EASEInitDialog.this.listener);
            this.removeButton.setFocusPainted(false);
            this.removeButton.setPreferredSize(new Dimension(150, 25));
            this.removeButton.setSize(150, 25);
            this.removeButton.setEnabled(false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBackground(Color.white);
            jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            jPanel2.add((Component)this.removeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 10, 0), 0, 0));
            jPanel2.add((Component)new JLabel("Files: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)jScrollPane, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            EASEInitDialog.this.sep = System.getProperty("file.separator");
            File file = new File(EASEInitDialog.this.getBaseFileLocation() + "/Data/Convert/");
            String string = file.getPath();
            Vector<String> vector = new Vector<String>();
            this.fileList = new JList(vector);
            if (file.exists()) {
                object = file.list();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    serializable = new File(string + EASEInitDialog.this.sep + object[i]);
                    if (!((File)serializable).isFile()) continue;
                    vector.add(object[i]);
                }
                if (vector.size() > 0) {
                    this.converterFileField.setText(string + EASEInitDialog.this.sep + (String)vector.elementAt(0));
                }
            }
            this.fieldNamesBox = new JComboBox<String>(stringArray);
            this.fieldNamesBox.setEditable(false);
            this.minClusterSizeField = new JTextField(5);
            this.minClusterSizeField.setText("5");
            object = new JPanel(new GridBagLayout());
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            serializable = new JPanel(new GridBagLayout());
            ((JComponent)serializable).setBackground(Color.white);
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MeV Annotation Key  (\"Unique ID\")", 0, 0, EASEInitDialog.this.font, Color.black));
            ((Container)serializable).add(new JLabel("Annotation Key:  "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            ((Container)serializable).add(this.fieldNamesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void updateFileDirectoryField() {
            File file = new File((String)this.fileList.getSelectedValue());
            if (file == null) {
                return;
            }
            String string = file.getParent();
            int n = this.fileList.getSelectedIndex();
            String string2 = (String)this.fileList.getModel().getElementAt(this.fileList.getSelectedIndex());
            this.converterFileField.setText(string + EASEInitDialog.this.sep + string2);
        }

        private void updateAnnFileList(File[] fileArray) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (((DefaultListModel)this.annFileList.getModel()).contains(file)) continue;
                ((DefaultListModel)this.annFileList.getModel()).addElement(file);
            }
            this.annFileList.validate();
        }

        public String getConverterFileName() {
            if (this.useAnnBox.isSelected()) {
                return this.converterFileField.getText();
            }
            return null;
        }

        public String getAnnotationKeyType() {
            return (String)this.fieldNamesBox.getSelectedItem();
        }

        private void updateConverterFileField(String string) {
            this.converterFileField.setText(string);
        }

        public String[] getAnnToGOFileList() {
            String[] stringArray = new String[((DefaultListModel)this.annFileList.getModel()).size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((File)((DefaultListModel)this.annFileList.getModel()).elementAt(i)).getPath();
            }
            return stringArray;
        }

        public void removeSelectedFiles() {
            int[] nArray = this.annFileList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                ((DefaultListModel)this.annFileList.getModel()).removeElementAt(nArray[i]);
            }
            if (this.annFileList.getModel().getSize() < 1) {
                this.removeButton.setEnabled(false);
                EASEInitDialog.this.okButton.setEnabled(false);
            }
            this.annFileList.validate();
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }

        private class EaseListListener
        implements ListSelectionListener {
            private EaseListListener() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EaseParameterPanel.this.updateFileDirectoryField();
            }
        }
    }

    private class PopSelectionPanel
    extends ParameterPanel {
        JRadioButton fileButton;
        JRadioButton dataButton;
        JTextField popField;
        JButton browseButton;
        JLabel fileLabel;

        public PopSelectionPanel() {
            super("Population Selection");
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.fileButton = new JRadioButton("Population from File", true);
            this.fileButton.setBackground(Color.white);
            this.fileButton.setFocusPainted(false);
            buttonGroup.add(this.fileButton);
            this.fileButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopSelectionPanel this$1;
                {
                    this.this$1 = popSelectionPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.browseButton.setEnabled(this.this$1.fileButton.isSelected());
                    this.this$1.popField.setEnabled(this.this$1.fileButton.isSelected());
                    this.this$1.popField.setBackground(Color.white);
                    this.this$1.fileLabel.setEnabled(this.this$1.fileButton.isSelected());
                }
            });
            this.dataButton = new JRadioButton("Population from Current Viewer");
            this.dataButton.setBackground(Color.white);
            this.dataButton.setFocusPainted(false);
            buttonGroup.add(this.dataButton);
            this.dataButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopSelectionPanel this$1;
                {
                    this.this$1 = popSelectionPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.browseButton.setEnabled(this.this$1.fileButton.isSelected());
                    this.this$1.popField.setEnabled(this.this$1.fileButton.isSelected());
                    this.this$1.popField.setBackground(Color.lightGray);
                    this.this$1.fileLabel.setEnabled(this.this$1.fileButton.isSelected());
                }
            });
            this.browseButton = new JButton("File Browser");
            this.browseButton.setFocusPainted(false);
            this.browseButton.setPreferredSize(new Dimension(150, 25));
            this.browseButton.setSize(150, 25);
            this.browseButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopSelectionPanel this$1;
                {
                    this.this$1 = popSelectionPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"Data/"));
                    jFileChooser.setDialogTitle("Population File Selection");
                    jFileChooser.setMultiSelectionEnabled(false);
                    if (jFileChooser.showOpenDialog(PopSelectionPanel.access$1500((PopSelectionPanel)this.this$1).parent) == 0) {
                        PopSelectionPanel.access$1600(this.this$1, jFileChooser.getSelectedFile().getPath());
                    }
                }
            });
            this.fileLabel = new JLabel("File: ");
            this.popField = new JTextField(25);
            this.add((Component)this.fileButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.popField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.dataButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 1, new Insets(15, 30, 20, 0), 0, 0));
        }

        private void setEnableControls(boolean bl) {
            this.fileButton.setEnabled(bl);
            this.dataButton.setEnabled(bl);
            this.popField.setEnabled(bl);
            this.browseButton.setEnabled(bl);
            this.fileLabel.setEnabled(bl);
            this.setOpaque(bl);
            EASEInitDialog.this.tabbedPane.setEnabledAt(0, bl);
        }

        private void updatePopField(String string) {
            this.popField.setText(string);
        }

        private String getPopFile() {
            return this.popField.getText();
        }

        static /* synthetic */ EASEInitDialog access$1500(PopSelectionPanel popSelectionPanel) {
            return popSelectionPanel.EASEInitDialog.this;
        }

        static /* synthetic */ void access$1600(PopSelectionPanel popSelectionPanel, String string) {
            popSelectionPanel.updatePopField(string);
        }
    }

    private class ModePanel
    extends JPanel {
        private JRadioButton clusterAnalysisButton;
        private JRadioButton slideSurveyButton;

        public ModePanel(boolean bl) {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Mode Selection", 0, 0, EASEInitDialog.this.font, Color.black));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.clusterAnalysisButton = new JRadioButton("Cluster Analysis", bl);
            this.clusterAnalysisButton.setFocusPainted(false);
            this.clusterAnalysisButton.setBackground(Color.white);
            this.clusterAnalysisButton.setHorizontalAlignment(0);
            this.clusterAnalysisButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((ModePanel)this).EASEInitDialog.this.popPanel.setEnableControls(true);
                }
            });
            buttonGroup.add(this.clusterAnalysisButton);
            this.slideSurveyButton = new JRadioButton("Annotation Survey");
            this.slideSurveyButton.setToolTipText("Surveys annotation loaded in the CURRENT viewer.");
            this.slideSurveyButton.setFocusPainted(false);
            this.slideSurveyButton.setBackground(Color.white);
            this.slideSurveyButton.setHorizontalAlignment(0);
            this.slideSurveyButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ModePanel this$1;
                {
                    this.this$1 = modePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PopSelectionPanel.access$1400(ModePanel.access$1300((ModePanel)this.this$1).popPanel, false);
                }
            });
            buttonGroup.add(this.slideSurveyButton);
            if (!bl) {
                this.slideSurveyButton.setSelected(true);
                this.clusterAnalysisButton.setEnabled(false);
            }
            this.add((Component)this.clusterAnalysisButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.slideSurveyButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

