/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HTMLMessageFileChooser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEFileUpdateDialog;

public class EASEUpdateManager {
    private JFrame frame;
    private Hashtable animalHash;
    private Hashtable plantHash;
    private Vector animalKeys;
    private Vector plantKeys;
    private String currentBaseFileLocation;
    private String destLoc;
    private int BUFFERSIZE = 1024;
    private byte[] buffer;
    private Progress progress;
    boolean okStatus = true;

    public EASEUpdateManager(JFrame jFrame) {
        this.frame = jFrame;
        this.currentBaseFileLocation = "ftp://ftp.tigr.org/pub/data/tgi/Resourcerer";
        this.progress = new Progress((Frame)jFrame, "Ease File Update Progress", new Listener());
        try {
            Object object;
            URL uRL = new URL(this.currentBaseFileLocation + "/kingdom_species_cloneset_list.txt");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            int n = 0;
            byte[] byArray = new byte[this.BUFFERSIZE];
            String string = "";
            while ((n = bufferedInputStream.read(byArray, 0, this.BUFFERSIZE)) > 0) {
                if (n == this.BUFFERSIZE) {
                    string = string + new String(byArray);
                    continue;
                }
                object = new byte[n];
                System.arraycopy(byArray, 0, object, 0, ((Object)object).length);
                string = string + new String((byte[])object);
            }
            object = new StringTokenizer(string, "\n");
            this.animalHash = new Hashtable();
            this.animalKeys = new Vector();
            this.plantHash = new Hashtable();
            this.plantKeys = new Vector();
            while (((StringTokenizer)object).hasMoreElements()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)((StringTokenizer)object).nextElement(), "\t");
                if (stringTokenizer.countTokens() != 3) continue;
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                if (string2.equals("animal")) {
                    if (this.animalHash.containsKey(string3)) {
                        ((Vector)this.animalHash.get(string3)).addElement(string4);
                        continue;
                    }
                    this.animalKeys.addElement(string3);
                    this.animalHash.put(string3, new Vector());
                    ((Vector)this.animalHash.get(string3)).addElement(string4);
                    continue;
                }
                if (!string2.equals("plant")) continue;
                if (this.plantHash.containsKey(string3)) {
                    ((Vector)this.plantHash.get(string3)).addElement(string4);
                    continue;
                }
                this.plantKeys.addElement(string3);
                this.plantHash.put(string3, new Vector());
                ((Vector)this.plantHash.get(string3)).addElement(string4);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "<html>An error occurred when retrieving information onavailable<br>species and clone set files.  Update request cannot be fulfilled.", "EASE Update Error", 0);
            this.okStatus = false;
            this.progress.dispose();
        }
    }

    public void updateFiles() {
        EASEFileUpdateDialog eASEFileUpdateDialog;
        if (this.okStatus && (eASEFileUpdateDialog = new EASEFileUpdateDialog(this.frame, this.plantKeys, this.plantHash, this.animalKeys, this.animalHash)).showModal() == 0) {
            this.updateEaseFiles(eASEFileUpdateDialog.getSpeciesName(), eASEFileUpdateDialog.getArrayName());
        }
    }

    private void updateEaseFiles(String string, String string2) {
        Thread thread = new Thread(new Runner(string, string2));
        thread.start();
    }

    private File getOutputFileLocation() {
        File file = null;
        String string = "<html><center><h1>EASE Destination Selection</h1></center>";
        string = string + "Use this interface to select the location for zip file download and extraction. ";
        string = string + "Note that the ease directory will be labeled as \"ease_\" followed by the array name.<br><br>";
        string = string + "When running EASE please use the button on the first dialog page to specify this folder as the base file ";
        string = string + "system for EASE analysis. ";
        string = string + "This will become the default location for EASE annoation information.";
        string = string + "</html>";
        HTMLMessageFileChooser hTMLMessageFileChooser = new HTMLMessageFileChooser((Frame)this.frame, "EASE File Update Location", string, TMEV.getFile((String)"data"), true);
        JFileChooser jFileChooser = hTMLMessageFileChooser.getFileChooser();
        jFileChooser.setFileSelectionMode(1);
        hTMLMessageFileChooser.setSize(550, 550);
        if (hTMLMessageFileChooser.showModal() == 0) {
            file = hTMLMessageFileChooser.getSelectedFile();
        }
        return file;
    }

    private void getBaseFiles(String string, String string2) {
        String string3 = this.currentBaseFileLocation + "/" + string + "/" + string2 + "_EASE.zip";
        boolean bl = true;
        File file = this.getOutputFileLocation();
        if (file == null) {
            return;
        }
        File file2 = new File(file.getAbsolutePath() + "/ease_" + string2);
        file2.mkdir();
        file = new File(file2.getAbsolutePath() + "/" + string2 + "_EASE.zip");
        this.progress.setTitle("Download Base Zip File");
        this.progress.show();
        bl = this.downloadFile(string3, file);
        if (bl) {
            bl = this.extractZipFile(file);
        }
        String string4 = file2 + "/Data/Class/Implies_and_URL_data.zip";
        String string5 = this.currentBaseFileLocation + "/Implies_and_URL_data.zip";
        file = new File(string4);
        this.progress.setTitle("Download Implies and URL Data File");
        this.progress.setValue(0);
        if (bl) {
            bl = this.downloadFile(string5, file);
        }
        if (bl) {
            bl = this.extractZipFile(file);
        }
        this.progress.dispose();
        if (bl) {
            JOptionPane.showMessageDialog(this.frame, "The EASE file system update is complete.", "EASE File System Update", 1);
        } else {
            JOptionPane.showMessageDialog(this.frame, "The EASE file system update was terminated due to the reported error.", "EASE File System Update", 0);
        }
    }

    private boolean downloadFile(String string, File file) {
        this.buffer = new byte[this.BUFFERSIZE];
        int n = 0;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            int n2 = uRLConnection.getContentLength();
            int n3 = 0;
            this.progress.setUnits(100);
            this.progress.setValue(0);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = bufferedInputStream.read(this.buffer, 0, this.BUFFERSIZE)) > 0) {
                bufferedOutputStream.write(this.buffer, 0, n);
                this.progress.setValue((int)(100.0f * (float)(n3 += n) / (float)n2));
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            this.progress.dispose();
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when downloading " + string + ".<br>The update request cannot be fulfilled.</html>", "EASE Update Download Error", 0);
            return false;
        }
        return true;
    }

    private boolean extractZipFile(File file) {
        this.progress.setTitle("Extracting zip file: " + file.getAbsolutePath());
        try {
            ZipFile zipFile = new ZipFile(file);
            this.progress.setUnits(zipFile.size());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            File file2 = file.getParentFile();
            byte[] byArray = new byte[this.BUFFERSIZE];
            int n = 0;
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                this.progress.setValue(n2);
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    ++n2;
                    continue;
                }
                String string = zipEntry.getName();
                String string2 = new File(string).getParent();
                File file3 = new File(file2.getAbsolutePath() + "/" + string2);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath() + "/" + zipEntry.getName()));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                while ((n = bufferedInputStream.read(byArray, 0, this.BUFFERSIZE)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                ++n2;
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
        }
        catch (Exception exception) {
            this.progress.dispose();
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when extracting " + file.getAbsolutePath() + ".<br>The update request cannot be fulfilled.</html>", "EASE Update Download Error", 0);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        EASEUpdateManager eASEUpdateManager = new EASEUpdateManager(new JFrame());
        eASEUpdateManager.updateFiles();
    }

    private class Listener
    extends DialogListener
    implements WindowListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                EASEUpdateManager.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            EASEUpdateManager.this.progress.dispose();
        }
    }

    private class Runner
    implements Runnable {
        private String species;
        private String array;

        public Runner(String string, String string2) {
            this.species = string;
            this.array = string2;
        }

        public void run() {
            EASEUpdateManager.this.getBaseFiles(this.species, this.array);
        }
    }
}

