/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class EaseThresholdDialog
extends AlgorithmDialog {
    private int result = 2;
    private double origTOne;
    private double origTTwo;
    private JTextField tOneField;
    private JTextField tTwoField;

    public EaseThresholdDialog(JFrame jFrame, double d, double d2) {
        super(jFrame, "EASE Tree Thresholds", true);
        this.origTOne = d;
        this.origTTwo = d2;
        ParameterPanel parameterPanel = new ParameterPanel("Threshold Selection");
        parameterPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Lower Threshold");
        this.tOneField = new JTextField("0.01", 8);
        parameterPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 15), 0, 0));
        parameterPanel.add((Component)this.tOneField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        jLabel = new JLabel("Upper Threshold");
        this.tTwoField = new JTextField("0.05", 8);
        parameterPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 10, 15), 0, 0));
        parameterPanel.add((Component)this.tTwoField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 10, 0), 0, 0));
        this.addContent(parameterPanel);
        this.setActionListeners(new EventListener());
        this.pack();
    }

    public double getLowerThreshold() {
        return Double.parseDouble(this.tOneField.getText());
    }

    public double getUpperThreshold() {
        return Double.parseDouble(this.tTwoField.getText());
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.tOneField.setText(String.valueOf(this.origTOne));
        this.tTwoField.setText(String.valueOf(this.origTTwo));
        this.tOneField.grabFocus();
        this.tOneField.selectAll();
    }

    private boolean validate(String string, String string2) {
        double d;
        double d2;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Number format error, entered value is not recognized as a number", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Number format error, entered value is not recognized as a number", "Input Error", 0);
            this.tTwoField.grabFocus();
            this.tTwoField.selectAll();
            return false;
        }
        if (d2 <= 0.0 || d2 >= 1.0) {
            JOptionPane.showMessageDialog(this, "Threshold should be > 0 and < 1.0", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        if (d <= 0.0 || d >= 1.0) {
            JOptionPane.showMessageDialog(this, "Threshold should be > 0 and < 1.0", "Input Error", 0);
            this.tTwoField.grabFocus();
            this.tTwoField.selectAll();
            return false;
        }
        if (d2 >= d) {
            JOptionPane.showMessageDialog(this, "The lower threshold should be less that the upper threshold.", "Input Error", 0);
            this.tOneField.grabFocus();
            this.tOneField.selectAll();
            return false;
        }
        return true;
    }

    private class EventListener
    extends DialogListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (EaseThresholdDialog.this.validate(EaseThresholdDialog.this.tOneField.getText(), EaseThresholdDialog.this.tTwoField.getText())) {
                    EaseThresholdDialog.this.result = 0;
                    EaseThresholdDialog.this.dispose();
                }
            } else if (string.equals("cancel-command")) {
                EaseThresholdDialog.this.result = 2;
                EaseThresholdDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    EaseThresholdDialog.this.resetControls();
                    EaseThresholdDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(EaseThresholdDialog.this, "EASE Threshold Dialog");
                    EaseThresholdDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.setVisible(false);
                        helpWindow.dispose();
                    }
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            EaseThresholdDialog.this.result = -1;
            EaseThresholdDialog.this.dispose();
        }
    }
}

