/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class HCLCentroidViewer
extends CentroidViewer
implements Serializable {
    public static final long serialVersionUID = 202007010001L;
    private JPopupMenu popup;

    public HCLCentroidViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                HCLCentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                HCLCentroidViewer.this.onSaveClusters();
            } else if (string.equals("store-cluster-cmd")) {
                HCLCentroidViewer.this.storeCluster();
            } else if (string.equals("set-def-color-cmd")) {
                HCLCentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                HCLCentroidViewer.this.yRangeOption = CentroidViewer.USE_EXPERIMENT_MAX;
                HCLCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                HCLCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                HCLCentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                HCLCentroidViewer.this.yRangeOption = CentroidViewer.USE_CLUSTER_MAX;
                HCLCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                HCLCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                HCLCentroidViewer.this.repaint();
            } else if (string.equals("launch-new-session-cmd")) {
                HCLCentroidViewer.this.launchNewSession();
            } else if (string.equals("toggle-ref-line-cmd")) {
                HCLCentroidViewer.this.showRefLine = !HCLCentroidViewer.this.showRefLine;
                HCLCentroidViewer.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || HCLCentroidViewer.this.getCluster() == null || HCLCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            HCLCentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

