/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;

public class HCLConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField zeroTextField;
    private JTextField minTextField;
    private JTextField maxTextField;
    private JTextField numTerminalsField;
    private float zThr;
    private int minPixDist;
    private int maxPixDist;
    private float origZThr;
    private int origMinPixDist;
    private int origMaxPixDist;
    private float minDist;
    private float maxDist;
    private float distRange;
    private JButton applyButton;
    private JCheckBox createClusterViewsBox;
    private JSlider slider;
    private HCLTree tree;
    private HCLViewer viewer;

    public HCLConfigDialog(Frame frame, HCLViewer hCLViewer, float f, int n, int n2, float f2, float f3) {
        super(frame, "Tree Configuration", true);
        this.viewer = hCLViewer;
        this.zThr = f;
        this.minDist = f2;
        this.maxDist = f3;
        this.origZThr = f;
        this.origMinPixDist = n;
        this.origMaxPixDist = n2;
        this.distRange = f3 - f2;
        this.minPixDist = n;
        this.maxPixDist = n2;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Distance Treshold Adjustment", 0, 0, new Font("Dialog", 1, 12), Color.black));
        jPanel.add((Component)new JLabel("Distance threshold"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        String string = String.valueOf(f);
        string = string.substring(0, Math.min(5, string.length()));
        this.zeroTextField = new JTextField(string, 4);
        jPanel.add((Component)this.zeroTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.slider = new JSlider(0, 0, 1000, 0);
        this.slider.setBackground(Color.white);
        this.slider.setValue((int)(1000.0f * ((this.zThr - this.minDist) / (this.maxDist - this.minDist))));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("Min"));
        hashtable.put(new Integer(500), new JLabel("(Distance Range)"));
        hashtable.put(new Integer(1000), new JLabel("Max"));
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        jPanel.add((Component)this.slider, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        jPanel.add((Component)new JSeparator(1), new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)new JLabel("# of Terminal Nodes:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.numTerminalsField = new JTextField(6);
        this.numTerminalsField.setEditable(false);
        this.numTerminalsField.setSize(90, 25);
        this.numTerminalsField.setPreferredSize(new Dimension(90, 25));
        jPanel.add((Component)this.numTerminalsField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.createClusterViewsBox = new JCheckBox("Create Cluster Viewers", false);
        this.createClusterViewsBox.setFocusPainted(false);
        this.createClusterViewsBox.setBackground(Color.white);
        this.createClusterViewsBox.setForeground(UIManager.getColor("Label.foreground"));
        jPanel.add((Component)this.createClusterViewsBox, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Tree Dimension Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        jPanel2.add((Component)new JLabel("Minimum pixel height"), new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
        jPanel2.add((Component)new JLabel("Maximum pixel height"), new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
        this.minTextField = new JTextField(String.valueOf(n), 4);
        jPanel2.add((Component)this.minTextField, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.maxTextField = new JTextField(String.valueOf(n2), 4);
        jPanel2.add((Component)this.maxTextField, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.applyButton = new JButton("Apply Dimensions");
        this.applyButton.setActionCommand("apply-tree-dimensions-command");
        this.applyButton.setFocusPainted(false);
        this.applyButton.setMargin(new Insets(5, 15, 5, 15));
        this.applyButton.setSize(110, 30);
        this.applyButton.setPreferredSize(new Dimension(120, 30));
        this.applyButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.gray));
        jPanel2.add((Component)this.applyButton, new GridBagConstraints(2, 0, 1, 2, 0.8, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setForeground(Color.white);
        jPanel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel3.setBackground(Color.white);
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        this.addContent(jPanel4);
        this.slider.addChangeListener(listener);
        this.zeroTextField.addKeyListener(listener);
        this.applyButton.addActionListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void setTree(HCLTree hCLTree) {
        this.tree = hCLTree;
        this.numTerminalsField.setText(String.valueOf(this.tree.getNumberOfTerminalNodes()));
    }

    public float getZeroThreshold() {
        float f = Float.parseFloat(this.zeroTextField.getText());
        if (f <= this.minDist) {
            return this.minDist;
        }
        if (f >= this.maxDist) {
            return this.maxDist;
        }
        return f;
    }

    public int getMinDistance() {
        return Integer.parseInt(this.minTextField.getText());
    }

    public int getMaxDistance() {
        return Integer.parseInt(this.maxTextField.getText());
    }

    public boolean isCreateClusterViews() {
        return this.createClusterViewsBox.isSelected();
    }

    public static void main(String[] stringArray) {
    }

    private class Listener
    extends DialogListener
    implements ChangeListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    HCLConfigDialog.this.zThr = Float.parseFloat(HCLConfigDialog.this.zeroTextField.getText());
                    HCLConfigDialog.this.minPixDist = Integer.parseInt(HCLConfigDialog.this.minTextField.getText());
                    HCLConfigDialog.this.maxPixDist = Integer.parseInt(HCLConfigDialog.this.maxTextField.getText());
                    HCLConfigDialog.this.tree.setProperties(HCLConfigDialog.this.zThr, HCLConfigDialog.this.minPixDist, HCLConfigDialog.this.maxPixDist);
                    HCLConfigDialog.this.viewer.revalidateViewer();
                    HCLConfigDialog.this.viewer.repaint();
                    HCLConfigDialog.this.result = 0;
                    HCLConfigDialog.this.dispose();
                }
                catch (Exception exception) {
                    HCLConfigDialog.this.result = 2;
                    HCLConfigDialog.this.dispose();
                }
            } else if (string.equals("apply-tree-dimensions-command")) {
                try {
                    HCLConfigDialog.this.minPixDist = Integer.parseInt(HCLConfigDialog.this.minTextField.getText());
                    HCLConfigDialog.this.maxPixDist = Integer.parseInt(HCLConfigDialog.this.maxTextField.getText());
                    HCLConfigDialog.this.tree.setPixelHeightLimits(HCLConfigDialog.this.minPixDist, HCLConfigDialog.this.maxPixDist);
                    HCLConfigDialog.this.viewer.revalidateViewer();
                    HCLConfigDialog.this.viewer.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    HCLConfigDialog.this.result = 2;
                    HCLConfigDialog.this.dispose();
                }
            } else if (string.equals("cancel-command")) {
                HCLConfigDialog.this.tree.setProperties(HCLConfigDialog.this.origZThr, HCLConfigDialog.this.origMinPixDist, HCLConfigDialog.this.origMaxPixDist);
                HCLConfigDialog.this.viewer.revalidateViewer();
                HCLConfigDialog.this.viewer.repaint();
                HCLConfigDialog.this.result = 2;
                HCLConfigDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                HCLConfigDialog.this.zeroTextField.setText(String.valueOf(HCLConfigDialog.this.origZThr));
                HCLConfigDialog.this.minTextField.setText(String.valueOf(HCLConfigDialog.this.origMinPixDist));
                HCLConfigDialog.this.maxTextField.setText(String.valueOf(HCLConfigDialog.this.origMaxPixDist));
                HCLConfigDialog.this.tree.setProperties(HCLConfigDialog.this.origZThr, HCLConfigDialog.this.origMinPixDist, HCLConfigDialog.this.origMaxPixDist);
                HCLConfigDialog.this.slider.setValue(0);
                HCLConfigDialog.this.createClusterViewsBox.setSelected(false);
                HCLConfigDialog.this.viewer.revalidateViewer();
                HCLConfigDialog.this.viewer.repaint();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(HCLConfigDialog.this, "HCL Tree Properties");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 500);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            HCLConfigDialog.this.result = -1;
            HCLConfigDialog.this.dispose();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == HCLConfigDialog.this.slider) {
                float f = HCLConfigDialog.this.distRange * ((float)HCLConfigDialog.this.slider.getValue() / 1000.0f) + HCLConfigDialog.this.minDist;
                if (HCLConfigDialog.this.tree != null) {
                    HCLConfigDialog.this.zThr = f;
                    HCLConfigDialog.this.tree.setZeroThreshold(f);
                    HCLConfigDialog.this.zeroTextField.setText(String.valueOf(f));
                    HCLConfigDialog.this.numTerminalsField.setText(String.valueOf(HCLConfigDialog.this.tree.getNumberOfTerminalNodes()));
                    HCLConfigDialog.this.tree.repaint();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == HCLConfigDialog.this.zeroTextField) {
                try {
                    float f = Float.parseFloat(HCLConfigDialog.this.zeroTextField.getText());
                    HCLConfigDialog.this.zThr = f;
                    HCLConfigDialog.this.tree.setZeroThreshold(f);
                    HCLConfigDialog.this.numTerminalsField.setText(String.valueOf(HCLConfigDialog.this.tree.getNumberOfTerminalNodes()));
                    HCLConfigDialog.this.tree.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

