/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class HCLInitDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox genes_box;
    private JCheckBox cluster_box;
    private JRadioButton ALC;
    private JRadioButton CLC;
    private JRadioButton SLC;
    private DistanceMetricPanel metricPanel;
    private String globalMetricName;
    private boolean globalAbsoluteDistance;

    public HCLInitDialog(Frame frame) {
        this(frame, " ", false, false);
    }

    public HCLInitDialog(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, "HCL: Hierarchical Clustering", true);
        this.setResizable(false);
        this.globalMetricName = string;
        this.globalAbsoluteDistance = bl;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameterPanel = new ParameterPanel("Tree Selection");
        parameterPanel.setLayout(new GridBagLayout());
        this.genes_box = new JCheckBox("Gene Tree");
        this.genes_box.setSelected(true);
        this.genes_box.setFocusPainted(false);
        this.genes_box.setBackground(Color.white);
        this.genes_box.setForeground(UIManager.getColor("Label.foreground"));
        this.genes_box.addItemListener(listener);
        this.cluster_box = new JCheckBox("Sample Tree");
        this.cluster_box.setSelected(true);
        this.cluster_box.setFocusPainted(false);
        this.cluster_box.setBackground(Color.white);
        this.cluster_box.setForeground(UIManager.getColor("Label.foreground"));
        this.cluster_box.addItemListener(listener);
        parameterPanel.add((Component)this.genes_box, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 20), 0, 0));
        parameterPanel.add((Component)this.cluster_box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 0), 0, 0));
        this.metricPanel = new DistanceMetricPanel(string, bl, "Euclidean Distance", "HCL", true, true);
        ParameterPanel parameterPanel2 = new ParameterPanel("Linkage Method Selection");
        parameterPanel2.setLayout(new GridBagLayout());
        this.ALC = new JRadioButton("Average linkage clustering");
        this.ALC.setBackground(Color.white);
        this.ALC.setFocusPainted(false);
        this.ALC.setForeground(UIManager.getColor("Label.foreground"));
        this.ALC.setMnemonic(65);
        this.ALC.setSelected(true);
        this.CLC = new JRadioButton("Complete linkage clustering");
        this.CLC.setBackground(Color.white);
        this.CLC.setFocusPainted(false);
        this.CLC.setForeground(UIManager.getColor("Label.foreground"));
        this.CLC.setMnemonic(67);
        this.SLC = new JRadioButton("Single linkage clustering");
        this.SLC.setBackground(Color.white);
        this.SLC.setFocusPainted(false);
        this.SLC.setForeground(UIManager.getColor("Label.foreground"));
        this.SLC.setMnemonic(83);
        parameterPanel2.add((Component)this.ALC, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        parameterPanel2.add((Component)this.CLC, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        parameterPanel2.add((Component)this.SLC, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ALC);
        buttonGroup.add(this.CLC);
        buttonGroup.add(this.SLC);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (bl2) {
            jPanel.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)parameterPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            jPanel.add((Component)parameterPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.ALC.setSelected(true);
        this.genes_box.setSelected(true);
        this.cluster_box.setSelected(true);
        this.metricPanel.reset();
    }

    public boolean isClusterGenes() {
        return this.genes_box.isSelected();
    }

    public boolean isClusterExperiments() {
        return this.cluster_box.isSelected();
    }

    public int getMethod() {
        if (this.ALC.isSelected()) {
            return 0;
        }
        if (this.CLC.isSelected()) {
            return 1;
        }
        return -1;
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        while (true) {
            HCLInitDialog hCLInitDialog;
            if ((hCLInitDialog = new HCLInitDialog((Frame)jFrame, "Euclidean Distance", false, true)).showModal() != 0) {
                System.exit(0);
            }
            System.out.println("===============================");
            System.out.println(hCLInitDialog.isClusterGenes());
            System.out.println(hCLInitDialog.isClusterExperiments());
            System.out.println(hCLInitDialog.getMethod());
        }
    }

    protected void disposeDialog() {
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                HCLInitDialog.this.result = 0;
                HCLInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                HCLInitDialog.this.result = 2;
                HCLInitDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    HCLInitDialog.this.resetControls();
                    HCLInitDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(HCLInitDialog.this, "HCL Initialization Dialog");
                    HCLInitDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            HCLInitDialog.this.dispose();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            HCLInitDialog.this.okButton.setEnabled(HCLInitDialog.this.genes_box.isSelected() || HCLInitDialog.this.cluster_box.isSelected());
        }

        public void windowClosing(WindowEvent windowEvent) {
            HCLInitDialog.this.result = -1;
            HCLInitDialog.this.dispose();
        }
    }
}

