/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class NewickFileOutputDialog
extends AlgorithmDialog {
    private int result = 2;
    private boolean isGeneTree = false;
    private JComboBox annBox;
    private JTextField fileField;

    public NewickFileOutputDialog(Frame frame, String[] stringArray, int n) {
        super(frame, "Newick File Output Dialog", true);
        if (n == 0) {
            this.isGeneTree = true;
        }
        JLabel jLabel = this.isGeneTree ? new JLabel("Select a Gene Label:") : new JLabel("Select a Sample Label:");
        this.annBox = new JComboBox<String>(stringArray);
        this.annBox.setSelectedIndex(0);
        JLabel jLabel2 = new JLabel("Output File:");
        this.fileField = new JTextField(50);
        this.fileField.setMargin(new Insets(0, 3, 0, 3));
        this.fileField.setHorizontalAlignment(11);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "newick_output.txt");
        JButton jButton = new JButton("Select Output File");
        jButton.setActionCommand("browse-command");
        jButton.setFocusPainted(false);
        ParameterPanel parameterPanel = new ParameterPanel("Output Parameters");
        parameterPanel.setLayout(new GridBagLayout());
        parameterPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 5, 0), 0, 0));
        parameterPanel.add((Component)this.annBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 30, 0), 0, 0));
        parameterPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        parameterPanel.add((Component)this.fileField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        parameterPanel.add((Component)jButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 20, 20), 0, 0));
        this.addContent(parameterPanel);
        Listener listener = new Listener();
        jButton.addActionListener(listener);
        this.setActionListeners(listener);
        this.setSize(470, 300);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private boolean validateOutputFile() {
        File file = new File(this.fileField.getText());
        File file2 = file.getParentFile();
        return file2.exists() && file2.isDirectory();
    }

    private void resetControls() {
        this.annBox.setSelectedIndex(0);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "newick_output.txt");
    }

    public File getOutputFile() {
        return new File(this.fileField.getText());
    }

    public String getAnnotationKey() {
        return (String)this.annBox.getSelectedItem();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"TC", "GenBank", "Putative Role (Guess)"};
        NewickFileOutputDialog newickFileOutputDialog = new NewickFileOutputDialog(new Frame(), stringArray2, 0);
        newickFileOutputDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (!NewickFileOutputDialog.this.validateOutputFile()) {
                    JOptionPane.showMessageDialog(NewickFileOutputDialog.this, "The directory specified for file output does not exist.<BR>Please select again.", "Newick Output File Error", 2);
                    return;
                }
                NewickFileOutputDialog.this.result = 0;
                NewickFileOutputDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                NewickFileOutputDialog.this.result = 2;
                NewickFileOutputDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    NewickFileOutputDialog.this.resetControls();
                    NewickFileOutputDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(NewickFileOutputDialog.this, "Newick File Output Dialog");
                    NewickFileOutputDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
                if (string.equals("browse-command")) {
                    JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data"));
                    jFileChooser.setFileSelectionMode(0);
                    if (jFileChooser.showSaveDialog(NewickFileOutputDialog.this) == 0) {
                        NewickFileOutputDialog.this.fileField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                        NewickFileOutputDialog.this.validate();
                    }
                    return;
                }
            }
            NewickFileOutputDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            NewickFileOutputDialog.this.result = -1;
            NewickFileOutputDialog.this.dispose();
        }
    }
}

