/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;

public class OWACentroidViewer
extends CentroidViewer {
    private JPopupMenu popup;
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector fValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;

    public OWACentroidViewer(Experiment experiment, int[][] nArray, float[][] fArray, float[][] fArray2, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.rawPValues = vector;
        this.adjPValues = vector2;
        this.fValues = vector3;
        this.ssGroups = vector4;
        this.ssError = vector5;
        this.geneGroupMeans = fArray;
        this.geneGroupSDs = fArray2;
        this.dfNumValues = vector6;
        this.dfDenomValues = vector7;
        this.getContentComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = OWACentroidViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, iData, nArray);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = OWACentroidViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print("\t");
        }
        for (n = 0; n < this.geneGroupMeans[0].length; ++n) {
            printWriter.print("Group" + (n + 1) + " mean\t");
            printWriter.print("Group" + (n + 1) + " std.dev.\t");
        }
        printWriter.print("F ratio");
        printWriter.print("\t");
        printWriter.print("SS(Groups)\t");
        printWriter.print("SS(Error)\t");
        printWriter.print("df (Groups)\t");
        printWriter.print("df (Error)\t");
        printWriter.print(" raw p value\t");
        printWriter.print("adj p.value");
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                printWriter.print("\t");
            }
            for (n2 = 0; n2 < this.geneGroupMeans[n].length; ++n2) {
                printWriter.print(this.geneGroupMeans[nArray[n]][n2] + "\t");
                printWriter.print(this.geneGroupSDs[nArray[n]][n2] + "\t");
            }
            printWriter.print("" + ((Float)this.fValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.ssGroups.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.ssError.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfNumValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfDenomValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.rawPValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.adjPValues.get(nArray[n])).floatValue());
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        jFileChooser.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        jFileChooser.setFileView((FileView)new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                OWACentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                OWACentroidViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                OWACentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                OWACentroidViewer.this.yRangeOption = CentroidViewer.USE_EXPERIMENT_MAX;
                OWACentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                OWACentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                OWACentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                OWACentroidViewer.this.yRangeOption = CentroidViewer.USE_CLUSTER_MAX;
                OWACentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                OWACentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                OWACentroidViewer.this.repaint();
            } else if (string.equals("store-cluster-cmd")) {
                OWACentroidViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                OWACentroidViewer.this.launchNewSession();
            } else if (string.equals("toggle-ref-line-cmd")) {
                OWACentroidViewer.this.showRefLine = !OWACentroidViewer.this.showRefLine;
                OWACentroidViewer.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || OWACentroidViewer.this.getCluster() == null || OWACentroidViewer.this.getCluster().length == 0) {
                return;
            }
            OWACentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

