/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class PTMExperimentCentroidViewer
extends ExperimentClusterCentroidViewer {
    private JPopupMenu popup;
    private Vector templateVector;
    private int numberOfGenes;
    private String[] auxTitles;
    private Object[][] auxData;

    public PTMExperimentCentroidViewer(Experiment experiment, int[][] nArray, Vector vector, String[] stringArray, Object[][] objectArray) {
        super(experiment, nArray);
        this.numberOfGenes = experiment.getNumberOfGenes();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.templateVector = vector;
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        this.getContentComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.templateVector);
        objectOutputStream.writeInt(this.numberOfGenes);
        objectOutputStream.writeObject(this.auxData);
        objectOutputStream.writeObject(this.auxTitles);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.templateVector = (Vector)objectInputStream.readObject();
        this.numberOfGenes = objectInputStream.readInt();
        this.auxData = (Object[][])objectInputStream.readObject();
        this.auxTitles = (String[])objectInputStream.readObject();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentClusterWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle, true);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        int n2;
        super.subPaint(graphics2D, rectangle, bl);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (n5 < 5 || n6 < 5) {
            return;
        }
        int n7 = n4 + Math.round((float)n6 / 2.0f);
        int n8 = this.getCluster().length;
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float f = (float)n6 / (2.0f * this.maxYValue);
        float f2 = (float)n5 / (float)(this.numberOfGenes - 1);
        int n9 = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n2 = 0; n2 < this.numberOfGenes; ++n2) {
                if (Float.isNaN(this.means[this.clusterIndex][n2]) || Float.isNaN(this.variances[this.clusterIndex][n2]) || this.variances[this.clusterIndex][n2] < 0.0f) continue;
                graphics2D.drawLine(n3 + Math.round((float)n2 * f2), n7 - Math.round((this.means[this.clusterIndex][n2] - this.variances[this.clusterIndex][n2]) * f), n3 + Math.round((float)n2 * f2), n7 - Math.round((this.means[this.clusterIndex][n2] + this.variances[this.clusterIndex][n2]) * f));
                graphics2D.drawLine(n3 + Math.round((float)n2 * f2) - 3, n7 - Math.round((this.means[this.clusterIndex][n2] - this.variances[this.clusterIndex][n2]) * f), n3 + Math.round((float)n2 * f2) + 3, n7 - Math.round((this.means[this.clusterIndex][n2] - this.variances[this.clusterIndex][n2]) * f));
                graphics2D.drawLine(n3 + Math.round((float)n2 * f2) - 3, n7 - Math.round((this.means[this.clusterIndex][n2] + this.variances[this.clusterIndex][n2]) * f), n3 + Math.round((float)n2 * f2) + 3, n7 - Math.round((this.means[this.clusterIndex][n2] + this.variances[this.clusterIndex][n2]) * f));
            }
        }
        if (this.drawValues) {
            for (int i = 0; i < this.getCluster().length; ++i) {
                for (int j = 0; j < this.numberOfGenes - 1; ++j) {
                    float f3 = this.experiment.get(j, this.getCluster()[i]);
                    float f4 = this.experiment.get(j + 1, this.getCluster()[i]);
                    if (Float.isNaN(f3) || Float.isNaN(f4)) continue;
                    Color color = this.data.getExperimentColor(this.getCluster()[i]);
                    color = color == null ? DEF_CLUSTER_COLOR : color;
                    graphics2D.setColor(color);
                    graphics2D.drawLine(n3 + Math.round((float)j * f2), n7 - Math.round(f3 * f), n3 + Math.round((float)(j + 1) * f2), n7 - Math.round(f4 * f));
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            graphics2D.setColor(Color.gray);
            for (n2 = 0; n2 < this.numberOfGenes - 1; ++n2) {
                graphics2D.drawLine(n3 + Math.round((float)n2 * f2), n7 - Math.round(this.codes[this.clusterIndex][n2] * f), n3 + Math.round((float)(n2 + 1) * f2), n7 - Math.round(this.codes[this.clusterIndex][n2 + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n3, n7, n3 + n5, n7);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            graphics2D.setColor(Color.magenta);
            for (n2 = 0; n2 < this.numberOfGenes - 1; ++n2) {
                if (Float.isNaN(this.means[this.clusterIndex][n2]) || Float.isNaN(this.means[this.clusterIndex][n2 + 1])) continue;
                graphics2D.drawLine(n3 + Math.round((float)n2 * f2), n7 - Math.round(this.means[this.clusterIndex][n2] * f), n3 + Math.round((float)(n2 + 1) * f2), n7 - Math.round(this.means[this.clusterIndex][n2 + 1] * f));
            }
        }
        float[] fArray = new float[this.templateVector.size()];
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = ((Float)this.templateVector.get(n)).floatValue();
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = fArray[n] - 0.5f;
        }
        for (n = 0; n < this.numberOfGenes - 1; ++n) {
            graphics2D.setColor(Color.red);
            if (!Float.isNaN(fArray[n])) {
                graphics2D.fillOval(n3 + Math.round((float)n * f2) - 2, n7 - Math.round(fArray[n] * f) - 2, 5, 5);
            }
            if (!Float.isNaN(fArray[n + 1])) {
                graphics2D.fillOval(n3 + Math.round((float)(n + 1) * f2) - 2, n7 - Math.round(fArray[n + 1] * f) - 2, 5, 5);
            }
            if (Float.isNaN(fArray[n]) || Float.isNaN(fArray[n + 1])) continue;
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(n3 + Math.round((float)n * f2), n7 - Math.round(fArray[n] * f), n3 + Math.round((float)(n + 1) * f2), n7 - Math.round(fArray[n + 1] * f));
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n3, n4, n5, n6);
        for (n = 1; n < this.numberOfGenes - 1; ++n) {
            graphics2D.drawLine(n3 + Math.round((float)n * f2), n4 + n6 - 5, n3 + Math.round((float)n * f2), n4 + n6);
        }
        for (n = 1; n < n9; ++n) {
            graphics2D.drawLine(n3, n7 - Math.round((float)n * f), n3 + 5, n7 - Math.round((float)n * f));
            graphics2D.drawLine(n3, n7 + Math.round((float)n * f), n3 + 5, n7 + Math.round((float)n * f));
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n = 0; n < this.numberOfGenes; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n])) continue;
                graphics2D.fillOval(n3 + Math.round((float)n * f2) - 3, n7 - Math.round(this.means[this.clusterIndex][n] * f) - 3, 6, 6);
            }
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            graphics2D.drawString("No Experiments In Cluster", n3 + 10, n4 + 20);
        } else if (this.getCluster().length == 1) {
            graphics2D.drawString("1 Experiment", n3 + 10, n4 + 20);
        } else {
            graphics2D.drawString(this.getCluster().length + " Experiments", n3 + 10, n4 + 20);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                PTMExperimentCentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                PTMExperimentCentroidViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                PTMExperimentCentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                PTMExperimentCentroidViewer.this.yRangeOption = CentroidViewer.USE_EXPERIMENT_MAX;
                PTMExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                PTMExperimentCentroidViewer.this.yRangeOption = CentroidViewer.USE_CLUSTER_MAX;
                PTMExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidViewer.this.repaint();
            } else if (string.equals("store-cluster-cmd")) {
                PTMExperimentCentroidViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                PTMExperimentCentroidViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || PTMExperimentCentroidViewer.this.getCluster() == null || PTMExperimentCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            PTMExperimentCentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

