/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class PTMExperimentClusterViewer
extends ExperimentClusterViewer {
    private JPopupMenu popup;
    private String[] auxTitles;
    private Object[][] auxData;

    public PTMExperimentClusterViewer(Experiment experiment, int[][] nArray, String string, Vector vector, String[] stringArray, Object[][] objectArray) {
        super(experiment, nArray, string, vector);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.auxData = (Object[][])objectInputStream.readObject();
        this.auxTitles = (String[])objectInputStream.readObject();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.auxData);
        objectOutputStream.writeObject(this.auxTitles);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentClusterWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster.", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                PTMExperimentClusterViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                PTMExperimentClusterViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                PTMExperimentClusterViewer.this.onSetDefaultColor();
            } else if (string.equals("store-cluster-cmd")) {
                PTMExperimentClusterViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                PTMExperimentClusterViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || PTMExperimentClusterViewer.this.getCluster() == null || PTMExperimentClusterViewer.this.getCluster().length == 0) {
                return;
            }
            PTMExperimentClusterViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

