/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class PTMGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IData data;
    Vector templateVector;
    private float[] pValues;
    private float[] rValues;
    private boolean clusterGenes = false;
    private Object[][] auxData;
    private String[] auxTitles;
    private boolean drawSigTreesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block26: {
            Object object;
            IDistanceMenu iDistanceMenu;
            int n;
            boolean bl;
            FloatMatrix floatMatrix;
            int n2;
            Object object2;
            int n3;
            Color[] colorArray;
            int n4 = 2;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            float f = 0.8f;
            this.experiment = iFramework.getData().getExperiment();
            this.data = iFramework.getData();
            Vector<String> vector = new Vector<String>();
            int n5 = this.experiment.getNumberOfSamples();
            int n6 = this.experiment.getNumberOfGenes();
            for (int i = 0; i < n5; ++i) {
                vector.add(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
            }
            Vector<String> vector2 = new Vector<String>();
            int n7 = iFramework.getDisplayMenu().getLabelIndex();
            for (int i = 0; i < n6; ++i) {
                vector2.add(iFramework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i), n7));
            }
            Vector<Object> vector3 = new Vector<Object>();
            Color[] colorArray2 = iFramework.getData().getColors();
            boolean[] blArray = new boolean[n6];
            for (int i = 0; i < n6; ++i) {
                blArray[i] = false;
            }
            ClusterRepository clusterRepository = iFramework.getClusterRepository(0);
            for (int i = 0; i < clusterRepository.size(); ++i) {
                colorArray = clusterRepository.getClusterList(i);
                colorArray2 = new Color[colorArray.size()];
                for (n3 = 0; n3 < colorArray.size(); ++n3) {
                    object2 = new Vector();
                    org.tigr.microarray.mev.cluster.clusterUtil.Cluster cluster = colorArray.getClusterAt(n3);
                    colorArray2[n3] = cluster.getClusterColor();
                    for (int j = 0; j < n6; ++j) {
                        if (cluster.isMember(this.experiment.getGeneIndexMappedToData(j))) {
                            ((Vector)object2).add(new Integer(j));
                        }
                        blArray[j] = true;
                    }
                    vector3.add(object2);
                }
            }
            Vector vector4 = new Vector();
            colorArray = iFramework.getData().getExperimentColors();
            object2 = new boolean[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                object2[n3] = false;
            }
            ClusterRepository clusterRepository2 = iFramework.getClusterRepository(0);
            for (int i = 0; i < clusterRepository2.size(); ++i) {
                ClusterList clusterList = clusterRepository2.getClusterList(i);
                colorArray = new Color[clusterList.size()];
                for (n2 = 0; n2 < clusterList.size(); n2 += 1) {
                    Vector<Integer> vector5 = new Vector<Integer>();
                    org.tigr.microarray.mev.cluster.clusterUtil.Cluster cluster = clusterList.getClusterAt(n2);
                    colorArray[n2] = cluster.getClusterColor();
                    for (int j = 0; j < n5; ++j) {
                        if (cluster.isMember(this.experiment.getSampleIndex(j))) {
                            vector5.add(new Integer(j));
                        }
                        object2[j] = true;
                    }
                    vector4.add(vector5);
                }
            }
            PTMInitDialog pTMInitDialog = new PTMInitDialog((JFrame)iFramework.getFrame(), bl2, this.experiment.getMatrix(), vector2, vector, vector3, vector4, colorArray2, colorArray);
            int n8 = 0;
            n2 = 0;
            boolean bl5 = false;
            pTMInitDialog.setVisible(true);
            if (!pTMInitDialog.isOkPressed()) {
                return null;
            }
            this.clusterGenes = pTMInitDialog.isGeneTemplate();
            if (this.clusterGenes) {
                floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
                this.templateVector = pTMInitDialog.getTemplate();
                bl3 = pTMInitDialog.isUseAbsolute();
                bl4 = pTMInitDialog.isUseR();
                f = (float)pTMInitDialog.getThresholdR();
                bl = pTMInitDialog.isDrawTrees();
            } else {
                floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
                this.templateVector = pTMInitDialog.getTemplate();
                bl3 = pTMInitDialog.isUseAbsolute();
                bl4 = pTMInitDialog.isUseR();
                f = (float)pTMInitDialog.getThresholdR();
                bl = pTMInitDialog.isDrawTrees();
            }
            this.drawSigTreesOnly = true;
            if (bl) {
                this.drawSigTreesOnly = pTMInitDialog.drawSigTreesOnly();
            }
            if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
                n = 4;
            }
            int n9 = 4;
            boolean bl6 = false;
            if (bl) {
                object = new HCLInitDialog((Frame)new JFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n8 = ((HCLInitDialog)object).getMethod();
                n2 = ((HCLInitDialog)object).isClusterExperiments() ? 1 : 0;
                bl5 = ((HCLInitDialog)object).isClusterGenes();
                n9 = ((HCLInitDialog)object).getDistanceMetric();
                bl6 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            object = new Listener();
            try {
                int n10;
                int n11;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PTM");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                FloatMatrix floatMatrix2 = this.experiment.getMatrix();
                if (!this.clusterGenes) {
                    floatMatrix2 = floatMatrix2.transpose();
                    n11 = floatMatrix2.getRowDimension();
                }
                n11 = this.experiment.getNumberOfGenes();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", floatMatrix2);
                algorithmData.addParam("ptm-cluster-genes", String.valueOf(this.clusterGenes));
                algorithmData.addMatrix("templateVectorMatrix", floatMatrix);
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("use-absolute", String.valueOf(bl3));
                algorithmData.addParam("useR", String.valueOf(bl4));
                algorithmData.addParam("threshold", String.valueOf(f));
                algorithmData.addParam("distance-function", String.valueOf(n));
                if (bl) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                    algorithmData.addParam("method-linkage", String.valueOf(n8));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                    algorithmData.addParam("calculate-experiments", String.valueOf(n2 != 0));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n9));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                this.clusters = new int[n4][];
                for (int i = 0; i < n4; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("rValuesMatrix");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("pValuesMatrix");
                this.pValues = new float[floatMatrix4.getRowDimension()];
                this.rValues = new float[floatMatrix3.getRowDimension()];
                for (n10 = 0; n10 < this.pValues.length; ++n10) {
                    this.pValues[n10] = floatMatrix4.A[n10][0];
                    this.rValues[n10] = floatMatrix3.A[n10][0];
                }
                this.auxTitles = new String[2];
                this.auxTitles[0] = "R values";
                this.auxTitles[1] = "p Values";
                this.auxData = new Object[this.pValues.length][2];
                for (n10 = 0; n10 < this.auxData.length; ++n10) {
                    this.auxData[n10][0] = new Float(this.rValues[n10]);
                    this.auxData[n10][1] = new Float(this.pValues[n10]);
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n4;
                generalInfo.time = l2;
                generalInfo.function = iDistanceMenu.getFunctionName(n);
                generalInfo.isR = bl4;
                generalInfo.isAbsolute = bl3;
                generalInfo.threshold = f;
                generalInfo.hcl = bl;
                generalInfo.hcl_genes = bl5;
                generalInfo.hcl_samples = n2 != 0;
                generalInfo.hcl_method = n8;
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var46_58 = null;
                if (this.algorithm == null) break block26;
            }
            catch (Throwable throwable) {
                block27: {
                    Object var46_59 = null;
                    if (this.algorithm == null) break block27;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        Object object;
        IDistanceMenu iDistanceMenu;
        int n;
        boolean bl;
        FloatMatrix floatMatrix;
        int n2;
        int n3;
        Color[] colorArray;
        int n4;
        int n5 = 2;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = 0.8f;
        this.experiment = iFramework.getData().getExperiment();
        this.data = iFramework.getData();
        Vector<String> vector = new Vector<String>();
        int n6 = this.experiment.getNumberOfSamples();
        int n7 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n6; ++i) {
            vector.add(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        Vector<String> vector2 = new Vector<String>();
        int n8 = iFramework.getDisplayMenu().getLabelIndex();
        for (int i = 0; i < n7; ++i) {
            vector2.add(iFramework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i), n8));
        }
        Vector<Color[]> vector3 = new Vector<Color[]>();
        Color[] colorArray2 = iFramework.getData().getColors();
        boolean[] blArray = new boolean[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            blArray[n4] = false;
        }
        for (n4 = 0; n4 < colorArray2.length; ++n4) {
            colorArray = new Vector();
            for (int i = 0; i < n7; ++i) {
                if (blArray[i] || !colorArray2[n4].equals(iFramework.getData().getProbeColor(this.experiment.getGeneIndexMappedToData(i)))) continue;
                colorArray.add(new Integer(i));
                blArray[i] = true;
            }
            vector3.add(colorArray);
        }
        Vector vector4 = new Vector();
        colorArray = iFramework.getData().getExperimentColors();
        boolean[] blArray2 = new boolean[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            blArray2[n3] = false;
        }
        for (n3 = 0; n3 < colorArray.length; ++n3) {
            Vector<Integer> vector5 = new Vector<Integer>();
            for (n2 = 0; n2 < n6; ++n2) {
                if (blArray2[n2] || !colorArray[n3].equals(iFramework.getData().getExperimentColor(this.experiment.getSampleIndex(n2)))) continue;
                vector5.add(new Integer(n2));
                blArray2[n2] = true;
            }
            vector4.add(vector5);
        }
        PTMInitDialog pTMInitDialog = new PTMInitDialog((JFrame)iFramework.getFrame(), bl2, this.experiment.getMatrix(), vector2, vector, vector3, vector4, colorArray2, colorArray);
        n2 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        pTMInitDialog.setVisible(true);
        if (!pTMInitDialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = pTMInitDialog.isGeneTemplate();
        if (this.clusterGenes) {
            floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
            this.templateVector = pTMInitDialog.getTemplate();
            bl3 = pTMInitDialog.isUseAbsolute();
            bl4 = pTMInitDialog.isUseR();
            f = (float)pTMInitDialog.getThresholdR();
            bl = pTMInitDialog.isDrawTrees();
        } else {
            floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
            this.templateVector = pTMInitDialog.getTemplate();
            bl3 = pTMInitDialog.isUseAbsolute();
            bl4 = pTMInitDialog.isUseR();
            f = (float)pTMInitDialog.getThresholdR();
            bl = pTMInitDialog.isDrawTrees();
        }
        this.drawSigTreesOnly = true;
        if (bl) {
            this.drawSigTreesOnly = pTMInitDialog.drawSigTreesOnly();
        }
        if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
            n = 4;
        }
        int n9 = 4;
        boolean bl7 = false;
        if (bl) {
            object = new HCLInitDialog((Frame)new JFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n2 = ((HCLInitDialog)object).getMethod();
            bl5 = ((HCLInitDialog)object).isClusterExperiments();
            bl6 = ((HCLInitDialog)object).isClusterGenes();
            n9 = ((HCLInitDialog)object).getDistanceMetric();
            bl7 = ((HCLInitDialog)object).getAbsoluteSelection();
        }
        object = new AlgorithmData();
        object.addParam("ptm-cluster-genes", String.valueOf(this.clusterGenes));
        object.addMatrix("templateVectorMatrix", floatMatrix);
        object.addParam("distance-factor", String.valueOf(1.0f));
        object.addParam("use-absolute", String.valueOf(bl3));
        object.addParam("useR", String.valueOf(bl4));
        object.addParam("threshold", String.valueOf(f));
        object.addParam("distance-function", String.valueOf(n));
        if (bl) {
            object.addParam("hierarchical-tree", String.valueOf(true));
            object.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            object.addParam("method-linkage", String.valueOf(n2));
            object.addParam("calculate-genes", String.valueOf(bl6));
            object.addParam("calculate-experiments", String.valueOf(bl5));
            object.addParam("hcl-distance-function", String.valueOf(n9));
            object.addParam("hcl-distance-absolute", String.valueOf(bl7));
        }
        object.addParam("name", "PTM");
        if (this.clusterGenes) {
            object.addParam("alg-type", "cluster-genes");
        } else {
            object.addParam("alg-type", "cluster-experiments");
        }
        object.addParam("output-class", "partition-output");
        String[] stringArray = new String[]{"Significant Genes", "Non-significant Genes"};
        object.addStringArray("output-nodes", stringArray);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block8: {
            int n = 2;
            this.experiment = experiment;
            this.data = iFramework.getData();
            AlgorithmParameters algorithmParameters = algorithmData.getParams();
            this.drawSigTreesOnly = algorithmData.getParams().getBoolean("draw-sig-trees-only");
            this.clusterGenes = algorithmParameters.getBoolean("ptm-cluster-genes");
            FloatMatrix floatMatrix = algorithmData.getMatrix("templateVectorMatrix");
            this.templateVector = new Vector();
            int n2 = floatMatrix.getColumnDimension();
            for (int i = 0; i < n2; ++i) {
                this.templateVector.add(new Float(floatMatrix.A[0][i]));
            }
            Listener listener = new Listener();
            try {
                int n3;
                int n4;
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PTM");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                FloatMatrix floatMatrix2 = experiment.getMatrix();
                if (!this.clusterGenes) {
                    floatMatrix2 = floatMatrix2.transpose();
                    n4 = floatMatrix2.getRowDimension();
                }
                n4 = experiment.getNumberOfGenes();
                algorithmData.addMatrix("experiment", floatMatrix2);
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                this.clusters = new int[n][];
                for (int i = 0; i < n; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("rValuesMatrix");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("pValuesMatrix");
                this.pValues = new float[floatMatrix4.getRowDimension()];
                this.rValues = new float[floatMatrix3.getRowDimension()];
                for (n3 = 0; n3 < this.pValues.length; ++n3) {
                    this.pValues[n3] = floatMatrix4.A[n3][0];
                    this.rValues[n3] = floatMatrix3.A[n3][0];
                }
                this.auxTitles = new String[2];
                this.auxTitles[0] = "R values";
                this.auxTitles[1] = "p Values";
                this.auxData = new Object[this.pValues.length][2];
                for (n3 = 0; n3 < this.auxData.length; ++n3) {
                    this.auxData[n3][0] = new Float(this.rValues[n3]);
                    this.auxData[n3][1] = new Float(this.pValues[n3]);
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.clusters = n;
                generalInfo.time = l2;
                int n5 = algorithmParameters.getInt("distance-function");
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n5);
                generalInfo.isR = algorithmParameters.getBoolean("useR");
                generalInfo.isAbsolute = algorithmParameters.getBoolean("use-absolute");
                generalInfo.threshold = algorithmParameters.getFloat("threshold");
                generalInfo.hcl = algorithmParameters.getBoolean("hierarchical-tree");
                generalInfo.hcl_genes = algorithmParameters.getBoolean("calculate-genes");
                generalInfo.hcl_samples = algorithmParameters.getBoolean("calculate-experiments");
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters.getInt("method-linkage");
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var24_24 = null;
                if (this.algorithm == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var24_25 = null;
                    if (this.algorithm == null) break block9;
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        return defaultMutableTreeNode;
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("PTM - genes") : new DefaultMutableTreeNode("PTM - samples");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addStatsTables(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        if (this.clusterGenes) {
            PTMExperimentViewer pTMExperimentViewer = new PTMExperimentViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMExperimentViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMExperimentViewer, (Object)new Integer(i))));
            }
        } else {
            PTMExperimentClusterViewer pTMExperimentClusterViewer = new PTMExperimentClusterViewer(this.experiment, this.clusters, "Template", this.templateVector, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentClusterViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentClusterViewer, (Object)new Integer(i))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        int n = nodeList.getSize();
        Object object = null;
        if (!this.drawSigTreesOnly) {
            int n2;
            if (!this.clusterGenes) {
                object = new int[n][];
                for (n2 = 0; n2 < ((int[][])object).length; ++n2) {
                    object[n2] = nodeList.getNode(n2).getFeaturesIndexes();
                }
                if (generalInfo.hcl_samples) {
                    object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (this.clusterGenes) {
                    if (n2 == 0) {
                        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes", this.createHCLViewer(nodeList.getNode(n2), generalInfo, null))));
                        continue;
                    }
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes", this.createHCLViewer(nodeList.getNode(n2), generalInfo, null))));
                    continue;
                }
                if (n2 == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments", this.createHCLViewer(nodeList.getNode(n2), generalInfo, (int[][])object), (Object)new Integer(n2))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("UnMatched Experiments", this.createHCLViewer(nodeList.getNode(n2), generalInfo, (int[][])object), (Object)new Integer(n2))));
            }
        } else {
            int n3;
            if (!this.clusterGenes) {
                object = new int[1][];
                for (n3 = 0; n3 < ((int[][])object).length; ++n3) {
                    object[n3] = nodeList.getNode(n3).getFeaturesIndexes();
                }
                if (generalInfo.hcl_samples) {
                    object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (this.clusterGenes) {
                    if (n3 != 0) continue;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes", this.createHCLViewer(nodeList.getNode(n3), generalInfo, null))));
                    continue;
                }
                if (n3 != 0) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments", this.createHCLViewer(nodeList.getNode(n3), generalInfo, (int[][])object), (Object)new Integer(n3))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", (IViewer)new PTMInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", (IViewer)new PTMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.clusterGenes))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            PTMCentroidViewer pTMCentroidViewer = new PTMCentroidViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            pTMCentroidViewer.setMeans(this.means.A);
            pTMCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            PTMCentroidsViewer pTMCentroidsViewer = new PTMCentroidsViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            pTMCentroidsViewer.setMeans(this.means.A);
            pTMCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMCentroidsViewer, (Object)new Integer(1))));
        } else {
            PTMExperimentCentroidViewer pTMExperimentCentroidViewer = new PTMExperimentCentroidViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            float[][] fArray = this.getCodes(this.templateVector);
            pTMExperimentCentroidViewer.setMeans(this.means.A);
            pTMExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            PTMExperimentCentroidsViewer pTMExperimentCentroidsViewer = new PTMExperimentCentroidsViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            pTMExperimentCentroidsViewer.setMeans(this.means.A);
            pTMExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addStatsTables(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        if (this.clusterGenes) {
            ClusterTableViewer clusterTableViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)clusterTableViewer, (Object)new Integer(i))));
            }
        } else {
            ExperimentClusterTableViewer experimentClusterTableViewer = new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)experimentClusterTableViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)experimentClusterTableViewer, (Object)new Integer(i))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public float[][] getCodes(Vector vector) {
        int n = vector.size();
        float[][] fArray = new float[2][n];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                fArray[i][j] = ((Float)vector.elementAt(i)).intValue();
            }
        }
        return fArray;
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute: " + String.valueOf(generalInfo.isAbsolute)));
        if (generalInfo.isR) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold Pearson R: " + String.valueOf(generalInfo.threshold)));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold prob. of R: " + String.valueOf(generalInfo.threshold)));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public boolean isAbsolute;
        public boolean isR;
        public float threshold;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                PTMGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PTMGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

