/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.Hexagon;
import org.tigr.util.FloatMatrix;

public class UMatrixColorViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202016030001L;
    private int[][] clusters;
    private FloatMatrix u_matrix;
    private int dim_x;
    private int dim_y;
    private String topology;
    private boolean isAntiAliasing = true;

    public UMatrixColorViewer(int[][] nArray, FloatMatrix floatMatrix, int n, int n2, String string) {
        this.clusters = nArray;
        this.u_matrix = floatMatrix;
        this.dim_x = n;
        this.dim_y = n2;
        this.topology = string;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 10));
        this.addComponentListener(new Listener());
    }

    public void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.black, n, 0.0f, Color.white);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, 20);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, n, 20);
        graphics2D.drawString("great distance", 5, 35);
        graphics2D.drawString("small distance", n - fontMetrics.stringWidth("small distance") - 5, 35);
        graphics2D.setColor(Color.lightGray);
        if (this.topology.equals("hexagonal")) {
            float f = (float)n / ((float)this.dim_x + 0.5f);
            float f2 = (float)n2 / ((float)this.dim_y + 0.5f);
            gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 128), Math.round(f), 0.0f, new Color(0, 128, 255));
            Hexagon hexagon = new Hexagon(Math.round(f), 270);
            hexagon.translate(0, 40);
            for (int i = 0; i < this.dim_y; ++i) {
                if (i % 2 == 0) {
                    hexagon.translate(-hexagon.getA(), 0);
                } else {
                    hexagon.translate(0, 0);
                }
                for (int j = 0; j < this.dim_x; ++j) {
                    hexagon.translate(Math.round(f), 0);
                    if (this.clusters[j * this.dim_y + i].length == 0) {
                        gradientPaint = new GradientPaint(hexagon.xpoints[5], 0.0f, new Color(0, 0, 128), hexagon.xpoints[1], 0.0f, new Color(0, 128, 255));
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.fillPolygon(hexagon);
                    } else {
                        int n3 = 255 - Math.round(this.u_matrix.get(j, i) * 255.0f);
                        graphics2D.setColor(new Color(n3, n3, n3));
                        graphics2D.fillPolygon(hexagon);
                    }
                    graphics2D.setColor(Color.lightGray);
                    graphics2D.drawPolygon(hexagon);
                }
                if (i % 2 == 0) {
                    hexagon.translate(-Math.round(f) * this.dim_x + hexagon.getA(), hexagon.getB() + hexagon.getC());
                    continue;
                }
                hexagon.translate(-Math.round(f) * this.dim_x, hexagon.getB() + hexagon.getC());
            }
        } else {
            int n4;
            float f = (float)n / (float)this.dim_x;
            float f3 = ((float)n2 - 40.0f) / (float)this.dim_y;
            for (n4 = 0; n4 < this.dim_y; ++n4) {
                for (int i = 0; i < this.dim_x; ++i) {
                    if (this.clusters[i * this.dim_y + n4].length == 0) {
                        gradientPaint = new GradientPaint(Math.round((float)(i + 1) * f), 0.0f, new Color(0, 0, 128), Math.round((float)i * f), 0.0f, new Color(0, 128, 255));
                        graphics2D.setPaint(gradientPaint);
                    } else {
                        int n5 = 255 - Math.round(this.u_matrix.get(i, n4) * 255.0f);
                        graphics2D.setColor(new Color(n5, n5, n5));
                    }
                    graphics2D.drawRect(Math.round((float)i * f), Math.round((float)n4 * f3) + 40, (int)f, (int)f3);
                    graphics2D.fillRect(Math.round((float)i * f), Math.round((float)n4 * f3) + 40, (int)f, (int)f3);
                }
            }
            graphics2D.setColor(Color.lightGray);
            for (n4 = 1; n4 < this.dim_x; ++n4) {
                graphics2D.drawLine(Math.round((float)n4 * f), 40, Math.round((float)n4 * f), n2 + 40);
            }
            for (n4 = 0; n4 < this.dim_y; ++n4) {
                graphics2D.drawLine(0, Math.round((float)n4 * f3) + 40, n, Math.round((float)n4 * f3) + 40);
            }
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.setAntialiasing(iFramework.getDisplayMenu().isAntiAliasing());
    }

    public void onDataChanged(IData iData) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void updateSize() {
        if (this.topology.equals("hexagonal")) {
            float f = (float)this.getWidth() / ((float)this.dim_x + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(f), 270);
            int n = this.dim_y * (hexagon.getB() + hexagon.getC()) + hexagon.getB() + 40;
            this.setPreferredSize(new Dimension(100, n));
        } else {
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends ComponentAdapter {
        private boolean isRevalidate = true;

        private Listener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!this.isRevalidate) {
                this.isRevalidate = true;
                return;
            }
            this.isRevalidate = false;
            UMatrixColorViewer.this.updateSize();
            UMatrixColorViewer.this.revalidate();
        }
    }
}

