/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.Hexagon;
import org.tigr.util.FloatMatrix;

public class UMatrixDistanceViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202016040001L;
    private int[][] clusters;
    private FloatMatrix u_matrix;
    private int dim_x;
    private int dim_y;
    private String topology;
    private boolean isAntiAliasing = true;

    public UMatrixDistanceViewer(int[][] nArray, FloatMatrix floatMatrix, int n, int n2, String string) {
        this.clusters = nArray;
        this.u_matrix = floatMatrix;
        this.dim_x = n;
        this.dim_y = n2;
        this.topology = string;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 10));
        this.addComponentListener(new Listener());
    }

    public void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(Color.lightGray);
        if (this.topology.equals("hexagonal")) {
            int n3;
            float f = (float)n / ((float)this.dim_x + 0.5f);
            float f2 = (float)n2 / ((float)this.dim_y + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(f), 270);
            hexagon.translate(0, 0);
            for (int i = 0; i < this.dim_y; ++i) {
                if (i % 2 == 0) {
                    hexagon.translate(-hexagon.getA(), 0);
                } else {
                    hexagon.translate(0, 0);
                }
                for (n3 = 0; n3 < this.dim_x; ++n3) {
                    hexagon.translate(Math.round(f), 0);
                    if (this.clusters[n3 * this.dim_y + i].length == 0) {
                        graphics2D.setColor(new Color(230, 230, 230));
                        graphics2D.fillPolygon(hexagon);
                        graphics2D.setColor(Color.lightGray);
                    }
                    graphics2D.drawPolygon(hexagon);
                }
                if (i % 2 == 0) {
                    hexagon.translate(-Math.round(f) * this.dim_x + hexagon.getA(), hexagon.getB() + hexagon.getC());
                    continue;
                }
                hexagon.translate(-Math.round(f) * this.dim_x, hexagon.getB() + hexagon.getC());
            }
            graphics2D.setColor(Color.black);
            for (n3 = 0; n3 < this.dim_y; ++n3) {
                for (int i = 0; i < this.dim_x; ++i) {
                    int n4 = (int)(f * this.u_matrix.get(i, n3));
                    Hexagon hexagon2 = new Hexagon(n4, 270);
                    hexagon2.translate(0, 0);
                    hexagon2.translate(Math.round(f) * i, Math.round((hexagon.getB() + hexagon.getC()) * n3 + (hexagon.getHeight() - hexagon2.getHeight()) / 2));
                    if (n3 % 2 == 0) {
                        hexagon2.translate(hexagon.getA(), 0);
                    } else {
                        hexagon2.translate((int)f, 0);
                    }
                    graphics2D.drawPolygon(hexagon2);
                }
            }
        } else {
            int n5;
            int n6;
            float f = (float)n / (float)this.dim_x;
            float f3 = (float)n2 / (float)this.dim_y;
            graphics2D.setColor(new Color(230, 230, 230));
            for (n6 = 0; n6 < this.dim_y; ++n6) {
                for (n5 = 0; n5 < this.dim_x; ++n5) {
                    if (this.clusters[n5 * this.dim_y + n6].length != 0) continue;
                    graphics2D.fillRect(Math.round((float)n5 * f) + 1, Math.round((float)n6 * f3) + 1, Math.round(f) - 1, Math.round(f3) - 1);
                }
            }
            graphics2D.setColor(Color.lightGray);
            for (n6 = 0; n6 < this.dim_x; ++n6) {
                graphics2D.drawLine(Math.round((float)n6 * f), 0, Math.round((float)n6 * f), n2);
            }
            for (n6 = 0; n6 < this.dim_y; ++n6) {
                graphics2D.drawLine(0, Math.round((float)n6 * f3), n, Math.round((float)n6 * f3));
            }
            for (n6 = 0; n6 < this.dim_y; ++n6) {
                for (n5 = 0; n5 < this.dim_x; ++n5) {
                    int n7 = Math.round(f * this.u_matrix.get(n5, n6));
                    int n8 = Math.round(f3 * this.u_matrix.get(n5, n6));
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(Math.round((float)n5 * f + (f - (float)n7) / 2.0f), Math.round((float)n6 * f3 + (f3 - (float)n8) / 2.0f), n7, n8);
                }
            }
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.setAntialiasing(iFramework.getDisplayMenu().isAntiAliasing());
    }

    public void onDataChanged(IData iData) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void updateSize() {
        if (this.topology.equals("hexagonal")) {
            float f = (float)this.getWidth() / ((float)this.dim_x + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(f), 270);
            int n = this.dim_y * (hexagon.getB() + hexagon.getC()) + hexagon.getB();
            this.setPreferredSize(new Dimension(100, n));
        } else {
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends ComponentAdapter {
        private boolean isRevalidate = true;

        private Listener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!this.isRevalidate) {
                this.isRevalidate = true;
                return;
            }
            this.isRevalidate = false;
            UMatrixDistanceViewer.this.updateSize();
            UMatrixDistanceViewer.this.revalidate();
        }
    }
}

