/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class SOTADiversityViewer
extends GraphViewer
implements IViewer {
    private int numPoints;
    private float initValue;

    public SOTADiversityViewer(FloatMatrix floatMatrix) {
        super(new JFrame(), 0, floatMatrix.getRowDimension(), 0, (int)floatMatrix.get(0, 0), 0.0, (double)floatMatrix.getRowDimension(), 0.0, (double)floatMatrix.get(0, 0), 75, 75, 75, 75, "SOTA Tree Diversity History", "Cycle Number", "Diversity (% of Initial)");
        this.numPoints = floatMatrix.getRowDimension();
        this.initValue = floatMatrix.get(0, 0);
        this.setBackground(Color.lightGray);
        this.referenceLinesOn = false;
        for (int i = 0; i < this.numPoints; ++i) {
            this.addGraphElement((GraphElement)new GraphPoint((double)i, (double)floatMatrix.get(i, 0), Color.black, 4));
            if (i % 5 == 0) {
                this.addGraphElement((GraphElement)new GraphTick((double)i, 10, Color.black, 0, 5, String.valueOf(i), Color.black));
                continue;
            }
            this.addGraphElement((GraphElement)new GraphTick((double)i, 5, Color.black, 0, 5, "", Color.black));
        }
        double d = (double)this.initValue / 10.0;
        for (int i = 0; i <= 10; ++i) {
            this.addGraphElement((GraphElement)new GraphTick((double)i * d, 10, Color.black, 1, 7, String.valueOf(i * 10), Color.black));
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawVerticalTick(graphics2D, d, n, n2, color);
        this.canvas.drawString(graphics2D, string, this.convertX(d) - string.length() * this.tickFontWidth / 2, this.canvas.getSize().height - this.postYSpacing + n + 10, color2, this.tickFont);
    }

    float maxYVal(FloatMatrix floatMatrix, int n) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(floatMatrix.get(i, n) > f)) continue;
            f = floatMatrix.get(i, n);
        }
        return f;
    }

    public void onDeselected() {
    }

    public void onSelected(IFramework iFramework) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onDataChanged(IData iData) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }
}

