/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class SOTAExperimentCentroidsViewer
extends ExperimentClusterCentroidsViewer {
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    private static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    private static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    private JPopupMenu popup;
    private JMenuItem setOverallMaxMenuItem;
    private JMenuItem setClusterMaxMenuItem;

    public SOTAExperimentCentroidsViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Save all clusters", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        jPopupMenu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        jPopupMenu.add(this.setClusterMaxMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClusters((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SOTAExperimentCentroidsViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SOTAExperimentCentroidsViewer.this.onSaveClusters();
            } else if (string.equals(SOTAExperimentCentroidsViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_EXPERIMENT_MAX);
                SOTAExperimentCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(true);
                SOTAExperimentCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(false);
                SOTAExperimentCentroidsViewer.this.repaint();
            } else if (string.equals(SOTAExperimentCentroidsViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_CLUSTER_MAX);
                SOTAExperimentCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(false);
                SOTAExperimentCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(true);
                SOTAExperimentCentroidsViewer.this.repaint();
            }
        }

        private void setAllYRanges(int n) {
            int n2 = SOTAExperimentCentroidsViewer.this.getClusters().length;
            for (int i = 0; i < n2; ++i) {
                SOTAExperimentCentroidsViewer.this.centroidViewer.setClusterIndex(i);
                SOTAExperimentCentroidsViewer.this.centroidViewer.setYRangeOption(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            SOTAExperimentCentroidsViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

