/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMGUI;

public class SVMProcessInitDialog
extends AlgorithmDialog {
    int result = 2;
    private SampleSelectionPanel sampleSelectionPanel;
    private JPanel processPanel;
    private JRadioButton trainAndClassifyButton;
    private JRadioButton trainOnlyButton;
    private JRadioButton classifyOnlyButton;
    private JRadioButton oneOutValButton;
    private ButtonGroup processSelection;
    private HCLSelectionPanel hclOpsPanel;

    public SVMProcessInitDialog(Frame frame, boolean bl) {
        super(new JFrame(), "SVM Process Initialization", bl);
        this.initComponents();
        this.okButton.setText("Continue");
        this.sampleSelectionPanel.setButtonText("Classify Genes", "Classify Samples");
        Listener listener = new Listener();
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.processSelection = new ButtonGroup();
        this.processPanel = new JPanel();
        this.trainAndClassifyButton = new JRadioButton();
        this.trainOnlyButton = new JRadioButton();
        this.classifyOnlyButton = new JRadioButton();
        this.oneOutValButton = new JRadioButton();
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SVMProcessInitDialog.this.closeDialog(windowEvent);
            }
        });
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Classification Selection");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)this.sampleSelectionPanel, gridBagConstraints);
        this.processPanel.setLayout(new GridBagLayout());
        this.processPanel.setBorder(new TitledBorder(new EtchedBorder(0), "SVM Process Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.processPanel.setBackground(Color.white);
        this.trainAndClassifyButton.setToolTipText("Train SMV then immediately classify");
        this.trainAndClassifyButton.setSelected(true);
        this.trainAndClassifyButton.setText("Train SVM then Classify");
        this.trainAndClassifyButton.setBackground(Color.white);
        this.trainAndClassifyButton.setForeground(UIManager.getColor("Label.foreground"));
        this.processSelection.add(this.trainAndClassifyButton);
        this.trainAndClassifyButton.setFocusPainted(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        this.processPanel.add((Component)this.trainAndClassifyButton, gridBagConstraints2);
        this.trainOnlyButton.setToolTipText("Train SVM only... output are result SVM weights");
        this.trainOnlyButton.setText("Train SVM (skip classify)");
        this.trainOnlyButton.setBackground(Color.white);
        this.trainOnlyButton.setForeground(UIManager.getColor("Label.foreground"));
        this.processSelection.add(this.trainOnlyButton);
        this.trainOnlyButton.setFocusPainted(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        this.processPanel.add((Component)this.trainOnlyButton, gridBagConstraints2);
        this.classifyOnlyButton.setToolTipText("Trains current data using and SVM file of weights");
        this.classifyOnlyButton.setText("Classify using existing SVM file");
        this.classifyOnlyButton.setBackground(Color.white);
        this.classifyOnlyButton.setForeground(UIManager.getColor("Label.foreground"));
        this.processSelection.add(this.classifyOnlyButton);
        this.classifyOnlyButton.setFocusPainted(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        this.processPanel.add((Component)this.classifyOnlyButton, gridBagConstraints2);
        this.oneOutValButton.setToolTipText("One-out Iterative Validation");
        this.oneOutValButton.setText("One-out Iterative Validation * (see information page)");
        this.oneOutValButton.setBackground(Color.white);
        this.oneOutValButton.setForeground(UIManager.getColor("Label.foreground"));
        this.processSelection.add(this.oneOutValButton);
        this.oneOutValButton.setFocusPainted(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        this.processPanel.add((Component)this.oneOutValButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.processPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.hclOpsPanel = new HCLSelectionPanel();
        jPanel.add((Component)this.hclOpsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.addContent(jPanel);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isEvaluateGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getSVMProcessSelection() {
        if (this.trainAndClassifyButton.isSelected()) {
            return SVMGUI.TRAIN_AND_CLASSIFY;
        }
        if (this.trainOnlyButton.isSelected()) {
            return SVMGUI.TRAIN_ONLY;
        }
        if (this.classifyOnlyButton.isSelected()) {
            return SVMGUI.CLASSIFY_ONLY;
        }
        return SVMGUI.ONE_OUT_VALIDATION;
    }

    public boolean getHCLSelection() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] stringArray) {
        new SVMProcessInitDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                SVMProcessInitDialog.this.result = 0;
                SVMProcessInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SVMProcessInitDialog.this.result = 2;
                SVMProcessInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SVMProcessInitDialog.this.sampleSelectionPanel.setClusterGenesSelected(true);
                SVMProcessInitDialog.this.hclOpsPanel.setHCLSelected(false);
                SVMProcessInitDialog.this.trainAndClassifyButton.setSelected(true);
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(SVMProcessInitDialog.this, "SVM Process Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SVMProcessInitDialog.this.result = -1;
            SVMProcessInitDialog.this.dispose();
        }
    }
}

