/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class IntegerTridiagonalMatrix
extends IntegerSquareMatrix {
    protected static final int TRIDIAGONAL = 3;
    protected int[] ldiag;
    protected int[] diag;
    protected int[] udiag;

    protected IntegerTridiagonalMatrix(int n, int n2) {
        super(n, n2);
    }

    public IntegerTridiagonalMatrix(int n) {
        this(n, 3);
        this.matrix = new int[3][n];
        this.ldiag = this.matrix[0];
        this.diag = this.matrix[1];
        this.udiag = this.matrix[2];
    }

    public IntegerTridiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        int n;
        if (nArray.length == nArray[0].length) {
            this.diag[0] = nArray[0][0];
            this.udiag[0] = nArray[0][1];
            n = 1;
            while (n < nArray.length - 1) {
                this.ldiag[n] = nArray[n][n - 1];
                this.diag[n] = nArray[n][n];
                this.udiag[n] = nArray[n][n + 1];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.ldiag[n] = nArray[n][n - 1];
        this.diag[n] = nArray[n][n];
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerTridiagonalMatrix && this.numRows == ((IntegerTridiagonalMatrix)object).rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = (IntegerTridiagonalMatrix)object;
            if (this.diag[0] != integerTridiagonalMatrix.getElement(0, 0)) {
                return false;
            }
            if (this.udiag[0] != integerTridiagonalMatrix.getElement(0, 1)) {
                return false;
            }
            int n = 1;
            while (n < this.numRows - 1) {
                if (this.ldiag[n] != integerTridiagonalMatrix.getElement(n, n - 1)) {
                    return false;
                }
                if (this.diag[n] != integerTridiagonalMatrix.getElement(n, n)) {
                    return false;
                }
                if (this.udiag[n] != integerTridiagonalMatrix.getElement(n, n + 1)) {
                    return false;
                }
                ++n;
            }
            if (this.ldiag[n] != integerTridiagonalMatrix.getElement(n, n - 1)) {
                return false;
            }
            return this.diag[n] == integerTridiagonalMatrix.getElement(n, n);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.rows() * this.columns());
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public DoubleMatrix toDoubleMatrix() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diag[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiag[n];
            ++n;
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n];
        doubleTridiagonalMatrix.diag[n] = this.diag[n];
        return doubleTridiagonalMatrix;
    }

    public ComplexMatrix toComplexMatrix() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        complexTridiagonalMatrix.diagRe[0] = this.diag[0];
        complexTridiagonalMatrix.udiagRe[0] = this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
            complexTridiagonalMatrix.diagRe[n] = this.diag[n];
            complexTridiagonalMatrix.udiagRe[n] = this.udiag[n];
            ++n;
        }
        complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
        complexTridiagonalMatrix.diagRe[n] = this.diag[n];
        return complexTridiagonalMatrix;
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 >= n - 1 && n2 <= n + 1) {
                return this.matrix[n2 - n + 1][n];
            }
            return 0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 < n - 1 || n2 > n + 1) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n2 - n + 1][n] = n3;
    }

    public boolean isSymmetric() {
        if (this.ldiag[1] != this.udiag[0]) {
            return false;
        }
        int n = 1;
        while (n < this.numRows - 1) {
            if (this.ldiag[n + 1] != this.udiag[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int trace() {
        int n = this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n += this.diag[n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n;
        int n2 = Math.abs(this.diag[0]) + Math.abs(this.udiag[0]);
        int n3 = 1;
        while (n3 < this.numRows - 1) {
            n = Math.abs(this.ldiag[n3]) + Math.abs(this.diag[n3]) + Math.abs(this.udiag[n3]);
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        n = Math.abs(this.ldiag[n3]) + Math.abs(this.diag[n3]);
        if (n > n2) {
            n2 = n;
        }
        return n2;
    }

    public double frobeniusNorm() {
        int n = this.diag[0] * this.diag[0] + this.udiag[0] * this.udiag[0];
        int n2 = 1;
        while (n2 < this.numRows - 1) {
            n += this.ldiag[n2] * this.ldiag[n2] + this.diag[n2] * this.diag[n2] + this.udiag[n2] * this.udiag[n2];
            ++n2;
        }
        return Math.sqrt(n += this.ldiag[n2] * this.ldiag[n2] + this.diag[n2] * this.diag[n2]);
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(integerMatrix.matrix[n], 0, nArray[n], 0, this.numRows);
                ++n;
            }
            int[] nArray2 = nArray[0];
            nArray2[0] = nArray2[0] + this.diag[0];
            int[] nArray3 = nArray[0];
            nArray3[1] = nArray3[1] + this.udiag[0];
            int n2 = this.numCols - 1;
            int n3 = 1;
            while (n3 < n2) {
                int[] nArray4 = nArray[n3];
                int n4 = n3 - 1;
                nArray4[n4] = nArray4[n4] + this.ldiag[n3];
                int[] nArray5 = nArray[n3];
                int n5 = n3;
                nArray5[n5] = nArray5[n5] + this.diag[n3];
                int[] nArray6 = nArray[n3];
                int n6 = n3 + 1;
                nArray6[n6] = nArray6[n6] + this.udiag[n3];
                ++n3;
            }
            int[] nArray7 = nArray[n2];
            int n7 = n2 - 1;
            nArray7[n7] = nArray7[n7] + this.ldiag[n2];
            int[] nArray8 = nArray[n2];
            int n8 = n2;
            nArray8[n8] = nArray8[n8] + this.diag[n2];
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) + integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) + integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] + integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.udiag[0] = this.udiag[0] + integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] + integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] + integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.udiag[n2] = this.udiag[n2] + integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = this.ldiag[n] + integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.diag[n] = this.diag[n] + integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawAddTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.numRows;
        if (n == integerMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] + integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.udiag[0] = this.udiag[0] + integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] + integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] + integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.udiag[n2] = this.udiag[n2] + integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = this.ldiag[n] + integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.diag[n] = this.diag[n] + integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) - integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) - integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numRows];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) - integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) - integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] - integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.udiag[0] = this.udiag[0] - integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] - integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] - integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.udiag[n2] = this.udiag[n2] - integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = this.ldiag[n] - integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.diag[n] = this.diag[n] - integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawSubtractTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.numRows;
        if (n == integerMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] - integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.udiag[0] = this.udiag[0] - integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] - integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] - integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.udiag[n2] = this.udiag[n2] - integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = this.ldiag[n] - integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.diag[n] = this.diag[n] - integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int n2 = this.numRows;
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n2);
        integerTridiagonalMatrix.diag[0] = n * this.diag[0];
        integerTridiagonalMatrix.udiag[0] = n * this.udiag[0];
        --n2;
        int n3 = 1;
        while (n3 < n2) {
            integerTridiagonalMatrix.ldiag[n3] = n * this.ldiag[n3];
            integerTridiagonalMatrix.diag[n3] = n * this.diag[n3];
            integerTridiagonalMatrix.udiag[n3] = n * this.udiag[n3];
            ++n3;
        }
        integerTridiagonalMatrix.ldiag[n2] = n * this.ldiag[n2];
        integerTridiagonalMatrix.diag[n2] = n * this.diag[n2];
        return integerTridiagonalMatrix;
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        int n = this.numRows;
        if (n == integerVector.dimension()) {
            int[] nArray = new int[n];
            nArray[0] = this.diag[0] * integerVector.getComponent(0) + this.udiag[0] * integerVector.getComponent(1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                nArray[n2] = this.ldiag[n2] * integerVector.getComponent(n2 - 1) + this.diag[n2] * integerVector.getComponent(n2) + this.udiag[n2] * integerVector.getComponent(n2 + 1);
                ++n2;
            }
            nArray[n] = this.ldiag[n] * integerVector.getComponent(n - 1) + this.diag[n] * integerVector.getComponent(n);
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerMatrix);
            }
        }
        if (this.numCols == integerMatrix.rows()) {
            int[][] nArray = new int[this.numRows][integerMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < integerMatrix.columns()) {
                    nArray[n][n2] = this.getElement(n, 0) * integerMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.numCols == integerMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < integerMatrix.numCols) {
                    nArray[n][n2] = this.getElement(n, 0) * integerMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerSquareMatrix);
            }
        }
        if (this.numCols == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, 0) * integerSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numCols == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, 0) * integerSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.rows()) {
            int[][] nArray = new int[n][n];
            nArray[0][0] = this.diag[0] * integerTridiagonalMatrix.getElement(0, 0) + this.udiag[0] * integerTridiagonalMatrix.getElement(1, 0);
            nArray[0][1] = this.diag[0] * integerTridiagonalMatrix.getElement(0, 1) + this.udiag[0] * integerTridiagonalMatrix.getElement(1, 1);
            nArray[0][2] = this.udiag[0] * integerTridiagonalMatrix.getElement(1, 2);
            if (n > 3) {
                nArray[1][0] = this.ldiag[1] * integerTridiagonalMatrix.getElement(0, 0) + this.diag[1] * integerTridiagonalMatrix.getElement(1, 0);
                nArray[1][1] = this.ldiag[1] * integerTridiagonalMatrix.getElement(0, 1) + this.diag[1] * integerTridiagonalMatrix.getElement(1, 1) + this.udiag[1] * integerTridiagonalMatrix.getElement(2, 1);
                nArray[1][2] = this.diag[1] * integerTridiagonalMatrix.getElement(1, 2) + this.udiag[1] * integerTridiagonalMatrix.getElement(2, 2);
                nArray[1][3] = this.udiag[1] * integerTridiagonalMatrix.getElement(2, 3);
            }
            if (n == 3) {
                nArray[1][0] = this.ldiag[1] * integerTridiagonalMatrix.getElement(0, 0) + this.diag[1] * integerTridiagonalMatrix.getElement(1, 0);
                nArray[1][1] = this.ldiag[1] * integerTridiagonalMatrix.getElement(0, 1) + this.diag[1] * integerTridiagonalMatrix.getElement(1, 1) + this.udiag[1] * integerTridiagonalMatrix.getElement(2, 1);
                nArray[1][2] = this.diag[1] * integerTridiagonalMatrix.getElement(1, 2) + this.udiag[1] * integerTridiagonalMatrix.getElement(2, 2);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    nArray[n2][n2 - 2] = this.ldiag[n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2 - 2);
                    nArray[n2][n2 - 1] = this.ldiag[n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2 - 1) + this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2 - 1);
                    nArray[n2][n2] = this.ldiag[n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2) + this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2) + this.udiag[n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2);
                    nArray[n2][n2 + 1] = this.diag[n2] * integerTridiagonalMatrix.getElement(n2, n2 + 1) + this.udiag[n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2 + 1);
                    nArray[n2][n2 + 2] = this.udiag[n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2 + 2);
                    ++n2;
                }
            }
            if (n > 3) {
                nArray[n - 2][n - 4] = this.ldiag[n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 4);
                nArray[n - 2][n - 3] = this.ldiag[n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 3) + this.diag[n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 3);
                nArray[n - 2][n - 2] = this.ldiag[n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 2) + this.diag[n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 2) + this.udiag[n - 2] * integerTridiagonalMatrix.getElement(n - 1, n - 2);
                nArray[n - 2][n - 1] = this.diag[n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 1) + this.udiag[n - 2] * integerTridiagonalMatrix.getElement(n - 1, n - 1);
            }
            nArray[n][--n - 2] = this.ldiag[n] * integerTridiagonalMatrix.getElement(n - 1, n - 2);
            nArray[n][n - 1] = this.ldiag[n] * integerTridiagonalMatrix.getElement(n - 1, n - 1) + this.diag[n] * integerTridiagonalMatrix.getElement(n, n - 1);
            nArray[n][n] = this.ldiag[n] * integerTridiagonalMatrix.getElement(n - 1, n) + this.diag[n] * integerTridiagonalMatrix.getElement(n, n);
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix rawMultiplyTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.numRows;
        if (n == integerMatrix.numRows) {
            int[][] nArray = new int[n][n];
            nArray[0][0] = this.diag[0] * integerMatrix.matrix[1][0] + this.udiag[0] * integerMatrix.matrix[0][1];
            nArray[0][1] = this.diag[0] * integerMatrix.matrix[2][0] + this.udiag[0] * integerMatrix.matrix[1][1];
            nArray[0][2] = this.udiag[0] * integerMatrix.matrix[2][1];
            if (n > 3) {
                nArray[1][0] = this.ldiag[1] * integerMatrix.matrix[1][0] + this.diag[1] * integerMatrix.matrix[0][1];
                nArray[1][1] = this.ldiag[1] * integerMatrix.matrix[2][0] + this.diag[1] * integerMatrix.matrix[1][1] + this.udiag[1] * integerMatrix.matrix[0][2];
                nArray[1][2] = this.diag[1] * integerMatrix.matrix[2][1] + this.udiag[1] * integerMatrix.matrix[1][2];
                nArray[1][3] = this.udiag[1] * integerMatrix.matrix[2][2];
            }
            if (n == 3) {
                nArray[1][0] = this.ldiag[1] * integerMatrix.matrix[1][0] + this.diag[1] * integerMatrix.matrix[0][1];
                nArray[1][1] = this.ldiag[1] * integerMatrix.matrix[2][0] + this.diag[1] * integerMatrix.matrix[1][1] + this.udiag[1] * integerMatrix.matrix[0][2];
                nArray[1][2] = this.diag[1] * integerMatrix.matrix[2][1] + this.udiag[1] * integerMatrix.matrix[1][2];
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    nArray[n2][n2 - 2] = this.ldiag[n2] * integerMatrix.matrix[0][n2 - 1];
                    nArray[n2][n2 - 1] = this.ldiag[n2] * integerMatrix.matrix[1][n2 - 1] + this.diag[n2] * integerMatrix.matrix[0][n2];
                    nArray[n2][n2] = this.ldiag[n2] * integerMatrix.matrix[2][n2 - 1] + this.diag[n2] * integerMatrix.matrix[1][n2] + this.udiag[n2] * integerMatrix.matrix[0][n2 + 1];
                    nArray[n2][n2 + 1] = this.diag[n2] * integerMatrix.matrix[2][n2] + this.udiag[n2] * integerMatrix.matrix[1][n2 + 1];
                    nArray[n2][n2 + 2] = this.udiag[n2] * integerMatrix.matrix[2][n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                nArray[n - 2][n - 4] = this.ldiag[n - 2] * integerMatrix.matrix[0][n - 3];
                nArray[n - 2][n - 3] = this.ldiag[n - 2] * integerMatrix.matrix[1][n - 3] + this.diag[n - 2] * integerMatrix.matrix[0][n - 2];
                nArray[n - 2][n - 2] = this.ldiag[n - 2] * integerMatrix.matrix[2][n - 3] + this.diag[n - 2] * integerMatrix.matrix[1][n - 2] + this.udiag[n - 2] * integerMatrix.matrix[0][n - 1];
                nArray[n - 2][n - 1] = this.diag[n - 2] * integerMatrix.matrix[2][n - 2] + this.udiag[n - 2] * integerMatrix.matrix[1][n - 1];
            }
            nArray[n][--n - 2] = this.ldiag[n] * integerMatrix.matrix[0][n - 1];
            nArray[n][n - 1] = this.ldiag[n] * integerMatrix.matrix[1][n - 1] + this.diag[n] * integerMatrix.matrix[0][n];
            nArray[n][n] = this.ldiag[n] * integerMatrix.matrix[2][n - 1] + this.diag[n] * integerMatrix.matrix[1][n];
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiag, 1, integerTridiagonalMatrix.udiag, 0, this.ldiag.length - 1);
        System.arraycopy(this.diag, 0, integerTridiagonalMatrix.diag, 0, this.diag.length);
        System.arraycopy(this.udiag, 0, integerTridiagonalMatrix.ldiag, 1, this.udiag.length - 1);
        return integerTridiagonalMatrix;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            double d;
            n2 = 0;
            while (n2 < n3) {
                d = this.getElement(nArray[n2], n3);
                n4 = 0;
                while (n4 < n2) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                ++n2;
            }
            double d2 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                d = this.getElement(nArray[n2], n3);
                n4 = 0;
                while (n4 < n3) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                n4 = 0;
                while (n4 < n3 + 1) {
                    d = dArray2[n3][n4];
                    dArray2[n3][n4] = dArray2[n5][n4];
                    dArray2[n5][n4] = d;
                    ++n4;
                }
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d = dArray2[n3][n3];
            n2 = n3 + 1;
            while (n2 < n) {
                double[] dArray3 = dArray2[n2];
                int n6 = n3;
                dArray3[n6] = dArray3[n6] / d;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray2[n2][n3];
                dArray2[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d = Math.sqrt(this.diag[0]);
        dArray2[0][0] = d;
        dArray[0][0] = d;
        double d2 = (double)this.ldiag[1] / dArray[0][0];
        dArray2[0][1] = d2;
        dArray[1][0] = d2;
        int n2 = 1;
        while (n2 < n) {
            double d3 = this.diag[n2];
            int n3 = 0;
            while (n3 < n2) {
                d3 -= dArray[n2][n3] * dArray[n2][n3];
                ++n3;
            }
            double d4 = Math.sqrt(d3);
            dArray2[n2][n2] = d4;
            dArray[n2][n2] = d4;
            if (n2 + 1 < n) {
                d3 = this.ldiag[n2 + 1];
                int n4 = 0;
                while (n4 < n2 + 1) {
                    d3 -= dArray[n2][n4] * dArray2[n4][n2 + 1];
                    ++n4;
                }
                double d5 = d3 / dArray2[n2][n2];
                dArray2[n2][n2 + 1] = d5;
                dArray[n2 + 1][n2] = d5;
                n3 = n2 + 2;
                while (n3 < n) {
                    d3 = 0.0;
                    n4 = 0;
                    while (n4 < n3) {
                        d3 -= dArray[n2][n4] * dArray2[n4][n3];
                        ++n4;
                    }
                    double d6 = d3 / dArray2[n2][n2];
                    dArray2[n2][n3] = d6;
                    dArray[n3][n2] = d6;
                    ++n3;
                }
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return doubleSquareMatrixArray;
    }
}

