/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Double3Vector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.CStarAlgebra;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class Quaternion
implements Field.Member,
CStarAlgebra.Member {
    private static final long serialVersionUID = 1605315490425547301L;
    private double re;
    private double imi;
    private double imj;
    private double imk;
    public static final Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    public Quaternion(double d, Double3Vector double3Vector) {
        this.re = d;
        this.imi = double3Vector.vector[0];
        this.imj = double3Vector.vector[1];
        this.imk = double3Vector.vector[2];
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.re = d;
        this.imi = d2;
        this.imj = d3;
        this.imk = d4;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)object;
            return Math.abs(this.re - quaternion.re) <= GlobalSettings.ZERO_TOL && Math.abs(this.imi - quaternion.imi) <= GlobalSettings.ZERO_TOL && Math.abs(this.imj - quaternion.imj) <= GlobalSettings.ZERO_TOL && Math.abs(this.imk - quaternion.imk) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.re);
        if (this.imi >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imi);
        stringBuffer.append("i");
        if (this.imj >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imj);
        stringBuffer.append("j");
        if (this.imk >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imk);
        stringBuffer.append("k");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.imi == Double.NaN || this.imj == Double.NaN || this.imk == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.imi == Double.POSITIVE_INFINITY || this.imi == Double.NEGATIVE_INFINITY || this.imj == Double.POSITIVE_INFINITY || this.imj == Double.NEGATIVE_INFINITY || this.imk == Double.POSITIVE_INFINITY || this.imk == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public Double3Vector imag() {
        return new Double3Vector(this.imi, this.imj, this.imk);
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        return this.re * this.re + this.imi * this.imi + this.imj * this.imj + this.imk * this.imk;
    }

    public AbelianGroup.Member negate() {
        return new Quaternion(-this.re, -this.imi, -this.imj, -this.imk);
    }

    public Field.Member inverse() {
        double d = this.sumSquares();
        return new Quaternion(this.re / d, -this.imi / d, -this.imj / d, -this.imk / d);
    }

    public CStarAlgebra.Member involution() {
        return this.conjugate();
    }

    public Quaternion conjugate() {
        return new Quaternion(this.re, -this.imi, -this.imj, -this.imk);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof Quaternion) {
            return this.add((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.addReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.addReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.re + quaternion.re, this.imi + quaternion.imi, this.imj + quaternion.imj, this.imk + quaternion.imk);
    }

    public Quaternion addReal(double d) {
        return new Quaternion(this.re + d, this.imi, this.imj, this.imk);
    }

    public Quaternion addImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi + double3Vector.vector[0], this.imj + double3Vector.vector[1], this.imk + double3Vector.vector[2]);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof Quaternion) {
            return this.subtract((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.subtractReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.subtractReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.re - quaternion.re, this.imi - quaternion.imi, this.imj - quaternion.imj, this.imk - quaternion.imk);
    }

    public Quaternion subtractReal(double d) {
        return new Quaternion(this.re - d, this.imi, this.imj, this.imk);
    }

    public Quaternion subtractImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi - double3Vector.vector[0], this.imj - double3Vector.vector[1], this.imk - double3Vector.vector[2]);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.multiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.multiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof Quaternion) {
            return this.multiply((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.multiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.multiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion multiply(Quaternion quaternion) {
        return new Quaternion(this.re * quaternion.re - this.imi * quaternion.imi - this.imj * quaternion.imj - this.imk * quaternion.imk, this.re * quaternion.imi + quaternion.re * this.imi + (this.imj * quaternion.imk - quaternion.imj * this.imk), this.re * quaternion.imj + quaternion.re * this.imj + (this.imk * quaternion.imi - quaternion.imk * this.imi), this.re * quaternion.imk + quaternion.re * this.imk + (this.imi * quaternion.imj - quaternion.imi * this.imj));
    }

    public Quaternion multiply(double d) {
        return new Quaternion(d * this.re, d * this.imi, d * this.imj, d * this.imk);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Field.Member divide(Field.Member member) {
        if (member instanceof Quaternion) {
            return this.divide((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion divide(Quaternion quaternion) {
        double d = quaternion.sumSquares();
        return new Quaternion((this.re * quaternion.re + this.imi * quaternion.imi + this.imj * quaternion.imj + this.imk * quaternion.imk) / d, (quaternion.re * this.imi - this.re * quaternion.imi - (this.imj * quaternion.imk - quaternion.imj * this.imk)) / d, (quaternion.re * this.imj - this.re * quaternion.imj - (this.imk * quaternion.imi - quaternion.imk * this.imi)) / d, (quaternion.re * this.imk - this.re * quaternion.imk - (this.imi * quaternion.imj - quaternion.imi * this.imj)) / d);
    }

    public Quaternion divide(double d) {
        return new Quaternion(this.re / d, this.imi / d, this.imj / d, this.imk / d);
    }
}

