/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.Complex;
import JSci.maths.fields.Field;
import JSci.maths.polynomials.ComplexPolynomial;
import JSci.maths.polynomials.ComplexPolynomialRing;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialBasis;

public class ComplexLagrangeBasis
implements PolynomialBasis {
    private ComplexPolynomial[] _basis;
    private Complex[] _samplingsX;
    private int _dim;

    public ComplexLagrangeBasis(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        this._dim = memberArray.length;
        this._samplingsX = ComplexPolynomialRing.toComplex(memberArray);
        this.buildBasis();
    }

    public Polynomial getBasisVector(int n) {
        return this._basis[n];
    }

    public int dimension() {
        return this._dim;
    }

    public Field.Member[] getSamplingPoints() {
        return this._samplingsX;
    }

    public Polynomial superposition(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        if (memberArray.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        Complex[] complexArray = ComplexPolynomialRing.toComplex(memberArray);
        return this.superposition(complexArray);
    }

    public ComplexPolynomial superposition(Complex[] complexArray) {
        if (complexArray == null) {
            throw new NullPointerException();
        }
        if (complexArray.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + complexArray.length + " coefficients");
        }
        ComplexPolynomial complexPolynomial = (ComplexPolynomial)ComplexPolynomialRing.getInstance().zero();
        int n = 0;
        while (n < this._dim) {
            ComplexPolynomial complexPolynomial2 = (ComplexPolynomial)this.getBasisVector(n);
            ComplexPolynomial complexPolynomial3 = complexPolynomial2.multiply(complexArray[n]);
            complexPolynomial = (ComplexPolynomial)complexPolynomial.add(complexPolynomial3);
            ++n;
        }
        return complexPolynomial;
    }

    private void buildBasis() {
        this._basis = new ComplexPolynomial[this._dim];
        int n = 0;
        while (n < this._dim) {
            this._basis[n] = (ComplexPolynomial)ComplexPolynomialRing.getInstance().one();
            Complex complex = Complex.ONE;
            int n2 = 0;
            while (n2 < this._dim) {
                if (n2 != n) {
                    ComplexPolynomial complexPolynomial = new ComplexPolynomial(new Complex[]{(Complex)this._samplingsX[n2].negate(), Complex.ONE});
                    this._basis[n] = (ComplexPolynomial)this._basis[n].multiply(complexPolynomial);
                    Complex complex2 = this._samplingsX[n];
                    Complex complex3 = this._samplingsX[n2];
                    Complex complex4 = complex2.subtract(complex3);
                    complex = complex.multiply(complex4);
                }
                ++n2;
            }
            this._basis[n] = this._basis[n].divide(complex);
            ++n;
        }
    }
}

