/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ArrayVisionLoader
implements FileLoader {
    private static int b635_col_;
    private String cy3_file_name_;
    private String cy5_file_name_;
    private static int data_line_count_;
    private static int data_start_line_;
    private static int f635_col_;
    private static int flag_col_;
    private String geneid_;
    private static int geneid_col_;
    private static int num_data_lines_;
    private static SlideMatrix slide_matrix_;
    private static int xcoord_col_;
    private static int ycoord_col_;

    static {
        num_data_lines_ = 0;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        data_start_line_ = 1;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                ++num_data_lines_;
                if (read_line.indexOf("Spot labels") == -1) continue;
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                int gpr_cols = tokenizer.getCount();
                int i = 0;
                while (i < gpr_cols) {
                    String col_name = tokenizer.nextToken();
                    if (col_name.equals("Spot labels")) {
                        geneid_col_ = i;
                    }
                    if (col_name.equals("ARM Dens - Levels")) {
                        f635_col_ = i;
                    }
                    if (col_name.equals("Bkgd")) {
                        b635_col_ = i;
                    }
                    if (col_name.equals("Flag")) {
                        flag_col_ = i;
                    }
                    if (col_name.equals("Pos X - \u00b5m")) {
                        xcoord_col_ = i;
                    }
                    if (col_name.equals("Pos Y - \u00b5m")) {
                        ycoord_col_ = i;
                    }
                    ++i;
                }
            }
            file_reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        this.cy5_file_name_ = input_file.getAbsolutePath();
        this.cy3_file_name_ = input_file.getAbsolutePath();
        this.cy3_file_name_ = this.cy3_file_name_.replaceAll("cy5", "cy3");
        num_data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        data_start_line_ = 0;
        data_line_count_ = 0;
        dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            this.parseCy5ArrayVisionFile(this.cy5_file_name_);
            this.parseCy3ArrayVisionFileAndMerge(this.cy3_file_name_);
            slide_matrix_.findColsAndRowsForArrayVision();
            dummy_ma = new MicroArrayData(slide_matrix_, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dummy_ma;
    }

    private void parseCy3ArrayVisionFileAndMerge(String file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (line >= data_start_line_) {
                read_line.replaceAll(".", ",");
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                try {
                    slide_matrix_.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f635_col_)));
                    slide_matrix_.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b635_col_)));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                ++data_line_count_;
            }
            ++line;
        }
        file_reader.close();
    }

    private void parseCy5ArrayVisionFile(String file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        int cnt_bads = 0;
        slide_matrix_ = new SlideMatrix(num_data_lines_ - 1, 4);
        ArrayVisionLoader.slide_matrix_.spot_nbr_[0] = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (line >= data_start_line_) {
                ArrayVisionLoader.slide_matrix_.spot_nbr_[ArrayVisionLoader.data_line_count_] = data_line_count_ + 1;
                read_line.replaceAll(".", ",");
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                try {
                    ArrayVisionLoader.slide_matrix_.bloc_[ArrayVisionLoader.data_line_count_] = 1;
                    ArrayVisionLoader.slide_matrix_.meta_column_[ArrayVisionLoader.data_line_count_] = 1;
                    ArrayVisionLoader.slide_matrix_.meta_row_[ArrayVisionLoader.data_line_count_] = 1;
                    ArrayVisionLoader.slide_matrix_.column_[ArrayVisionLoader.data_line_count_] = 1;
                    ArrayVisionLoader.slide_matrix_.row_[ArrayVisionLoader.data_line_count_] = 1;
                    ArrayVisionLoader.slide_matrix_.gene_name_[ArrayVisionLoader.data_line_count_] = this.geneid_ = tokenizer.getToken(geneid_col_);
                    ArrayVisionLoader.slide_matrix_.gene_id_[ArrayVisionLoader.data_line_count_] = this.geneid_;
                    int flag = Integer.parseInt(tokenizer.getToken(flag_col_));
                    if (flag != 0) {
                        flag = -100;
                        ++cnt_bads;
                    }
                    ArrayVisionLoader.slide_matrix_.flag_[ArrayVisionLoader.data_line_count_] = flag;
                    ArrayVisionLoader.slide_matrix_.x_coord_[ArrayVisionLoader.data_line_count_] = Math.round(Float.parseFloat(tokenizer.getToken(xcoord_col_)));
                    ArrayVisionLoader.slide_matrix_.y_coord_[ArrayVisionLoader.data_line_count_] = Math.round(Float.parseFloat(tokenizer.getToken(ycoord_col_)));
                    slide_matrix_.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635_col_)));
                    slide_matrix_.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635_col_)));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                ++data_line_count_;
            }
            ++line;
        }
        file_reader.close();
    }

    private void printSomeValues() {
        int i = 0;
        while (i < 50) {
            System.out.println("geneid = " + ArrayVisionLoader.slide_matrix_.gene_id_[i] + ",  f635 = " + slide_matrix_.getValue(i, 0) + ",   f532 = " + slide_matrix_.getValue(i, 2));
            ++i;
        }
    }
}

