/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class GPSinglChannelLoader
implements FileLoader {
    private static int b532_col_;
    private static int b635_col_;
    private static int b_col_;
    private static int columns_header_line_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    private static int f532_col_;
    private static int f635_col_;
    private static int f_col_;
    private static int flag_col_;
    private static boolean import_ok_;
    private static int max_lines_;
    private static int progress_;
    private static int r_or_g_available_;

    static {
        max_lines_ = 0;
        data_start_line_ = 0;
        columns_header_line_ = 0;
        data_lines_ = 0;
        r_or_g_available_ = 0;
        import_ok_ = true;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        int first_row = 0;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                ++max_lines_;
                read_line.replaceAll("\"", "");
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                tokenizer.getCount();
                if (first_row != 0 || tokenizer.getCount() <= 20) continue;
                data_start_line_ = max_lines_ + 1;
                columns_header_line_ = max_lines_;
                ++first_row;
                int gpr_cols = tokenizer.getCount();
                int i = 0;
                while (i < gpr_cols) {
                    String col_name = tokenizer.nextToken();
                    if (col_name.equals("\"F635 Median\"") || col_name.equals("F635 Median")) {
                        f635_col_ = i;
                    }
                    if (col_name.equals("\"B635 Median\"") || col_name.equals("B635 Median")) {
                        b635_col_ = i;
                    }
                    if (col_name.equals("\"F532 Median\"") || col_name.equals("F532 Median")) {
                        f532_col_ = i;
                    }
                    if (col_name.equals("\"B532 Median\"") || col_name.equals("B532 Median")) {
                        b532_col_ = i;
                    }
                    if (col_name.equals("\"Flags\"") || col_name.equals("Flags")) {
                        flag_col_ = i;
                    }
                    ++i;
                }
            }
            file_reader.close();
            data_lines_ = ++max_lines_ - data_start_line_;
        }
        catch (IOException e) {
            e.printStackTrace();
            import_ok_ = false;
        }
        if (f635_col_ == 0) {
            r_or_g_available_ = 1;
            f_col_ = f532_col_;
            b_col_ = b532_col_;
        } else if (f532_col_ == 0) {
            r_or_g_available_ = 0;
            f_col_ = f635_col_;
            b_col_ = b635_col_;
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            SlideMatrix dummy_1 = this.uploadGprFileAdaptive(input_file);
            dummy_1.findMetaIndicesForGenePix();
            dummy_ma = new MicroArrayData(dummy_1, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
            import_ok_ = false;
        }
        return dummy_ma;
    }

    private SlideMatrix uploadGprFileAdaptive(File file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        progress_ = 0;
        float f_pseudo_mean = 4000.0f;
        float b_pseudo_mean = 400.0f;
        SlideMatrix dummy_slide_matrix = new SlideMatrix(data_lines_, 4);
        dummy_slide_matrix.spot_nbr_[0] = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (read_line.equals(null)) continue;
            dummy_slide_matrix.spot_nbr_[GPSinglChannelLoader.data_line_count_] = data_line_count_ + 1;
            StringTokenizer tokenizer = new StringTokenizer(read_line);
            if (++line < data_start_line_) continue;
            try {
                dummy_slide_matrix.bloc_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(0));
                dummy_slide_matrix.column_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(1));
                dummy_slide_matrix.row_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(2));
                dummy_slide_matrix.gene_name_[GPSinglChannelLoader.data_line_count_] = tokenizer.getToken(3);
                dummy_slide_matrix.gene_id_[GPSinglChannelLoader.data_line_count_] = tokenizer.getToken(4);
                dummy_slide_matrix.x_coord_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(5));
                dummy_slide_matrix.y_coord_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(6));
                if (r_or_g_available_ == 0) {
                    dummy_slide_matrix.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 2, f_pseudo_mean);
                    dummy_slide_matrix.setValue(data_line_count_, 3, b_pseudo_mean);
                } else if (r_or_g_available_ == 1) {
                    dummy_slide_matrix.setValue(data_line_count_, 0, f_pseudo_mean);
                    dummy_slide_matrix.setValue(data_line_count_, 1, b_pseudo_mean);
                    dummy_slide_matrix.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b_col_)));
                }
                dummy_slide_matrix.flag_[GPSinglChannelLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(flag_col_));
            }
            catch (NumberFormatException ex) {
                import_ok_ = false;
                ex.printStackTrace();
            }
            ++data_line_count_;
        }
        file_reader.close();
        return dummy_slide_matrix;
    }
}

