/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class MarsFormatLoader
implements FileLoader {
    private static int b532_col_;
    private static int b635_col_;
    private static int block_col_;
    private static int col_col_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    private static int f532_col_;
    private static int f635_col_;
    private static int flag_col_;
    private static int id_col_;
    private static int mars_element_col_;
    private static int marsid_col_;
    private static int max_lines_;
    private static int name_col_;
    private static int row_col_;
    private static int x_col_;
    private static int y_col_;

    static {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        int first_row = 0;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                ++max_lines_;
                read_line = read_line.replaceAll("\"", "");
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                if (first_row != 0 || tokenizer.getCount() <= 40) continue;
                data_start_line_ = max_lines_ + 1;
                ++first_row;
                int gpr_cols = tokenizer.getCount();
                int i = 0;
                while (i < gpr_cols) {
                    String col_name = tokenizer.nextToken();
                    if (col_name.equals("\"Mars ID\"") || col_name.equals("Mars ID")) {
                        marsid_col_ = i;
                    }
                    if (col_name.equals("\"Element\"") || col_name.equals("Element")) {
                        mars_element_col_ = i;
                    }
                    if (col_name.equals("\"Block\"") || col_name.equals("Block")) {
                        block_col_ = i;
                    }
                    if (col_name.equals("\"Columnn\"") || col_name.equals("Columnn")) {
                        col_col_ = i;
                    }
                    if (col_name.equals("\"Row\"") || col_name.equals("Row")) {
                        row_col_ = i;
                    }
                    if (col_name.equals("\"Name\"") || col_name.equals("Name")) {
                        name_col_ = i;
                    }
                    if (col_name.equals("\"ID\"") || col_name.equals("ID")) {
                        id_col_ = i;
                    }
                    if (col_name.equals("\"X\"") || col_name.equals("X")) {
                        x_col_ = i;
                    }
                    if (col_name.equals("\"Y\"") || col_name.equals("Y")) {
                        y_col_ = i;
                    }
                    if (col_name.equals("\"Channel 1.fMedian\"") || col_name.equals("Channel 1.fMedian")) {
                        f635_col_ = i;
                    }
                    if (col_name.equals("\"Channel 1.bMedian\"") || col_name.equals("Channel 1.bMedian")) {
                        b635_col_ = i;
                    }
                    if (col_name.equals("\"Channel 2.fMedian\"") || col_name.equals("Channel 2.fMedian")) {
                        f532_col_ = i;
                    }
                    if (col_name.equals("\"Channel 2.bMedian\"") || col_name.equals("Channel 2.bMedian")) {
                        b532_col_ = i;
                    }
                    if (col_name.equals("\"filter\"") || col_name.equals("filter")) {
                        flag_col_ = i;
                    }
                    ++i;
                }
            }
            file_reader.close();
            data_lines_ = ++max_lines_ - data_start_line_;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        try {
            System.out.println("[MarsFormatLoader]: *********** parsing the file = " + input_file.getName());
            this.getInputFileInfo(input_file);
            SlideMatrix dummy_1 = this.uploadGprFileAdaptive(input_file);
            dummy_ma = new MicroArrayData(dummy_1, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dummy_ma;
    }

    private SlideMatrix uploadGprFileAdaptive(File file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        SlideMatrix dummy_slide_matrix = new SlideMatrix(data_lines_, 4);
        dummy_slide_matrix.spot_nbr_[0] = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (read_line.equals(null)) continue;
            dummy_slide_matrix.spot_nbr_[MarsFormatLoader.data_line_count_] = data_line_count_ + 1;
            StringTokenizer tokenizer = new StringTokenizer(read_line);
            if (++line < data_start_line_) continue;
            try {
                String nulltest = tokenizer.getToken(0);
                dummy_slide_matrix.mars_id_[MarsFormatLoader.data_line_count_] = !nulltest.equals("null") ? Integer.parseInt(tokenizer.getToken(0)) : 0;
                nulltest = tokenizer.getToken(8);
                dummy_slide_matrix.mars_element_[MarsFormatLoader.data_line_count_] = !nulltest.equals("null") ? Long.parseLong(tokenizer.getToken(8)) : 0L;
                dummy_slide_matrix.bloc_[MarsFormatLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(1));
                dummy_slide_matrix.column_[MarsFormatLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(2));
                dummy_slide_matrix.row_[MarsFormatLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(3));
                dummy_slide_matrix.gene_name_[MarsFormatLoader.data_line_count_] = tokenizer.getToken(7);
                dummy_slide_matrix.gene_id_[MarsFormatLoader.data_line_count_] = tokenizer.getToken(6);
                nulltest = tokenizer.getToken(4);
                dummy_slide_matrix.x_coord_[MarsFormatLoader.data_line_count_] = !nulltest.equals("null") ? (int)Float.parseFloat(tokenizer.getToken(4)) : 0;
                nulltest = tokenizer.getToken(5);
                dummy_slide_matrix.y_coord_[MarsFormatLoader.data_line_count_] = !nulltest.equals("null") ? (int)Float.parseFloat(tokenizer.getToken(5)) : 0;
                nulltest = tokenizer.getToken(f635_col_);
                if (!nulltest.equals("null")) {
                    dummy_slide_matrix.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635_col_)));
                }
                if (!(nulltest = tokenizer.getToken(b635_col_)).equals("null")) {
                    dummy_slide_matrix.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635_col_)));
                }
                if (!(nulltest = tokenizer.getToken(f532_col_)).equals("null")) {
                    dummy_slide_matrix.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f532_col_)));
                }
                if (!(nulltest = tokenizer.getToken(b532_col_)).equals("null")) {
                    dummy_slide_matrix.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b532_col_)));
                }
                dummy_slide_matrix.flag_[MarsFormatLoader.data_line_count_] = (nulltest = tokenizer.getToken(flag_col_)) != null ? (nulltest.equals("GOOD") ? 0 : (nulltest.equals("null") ? -100 : -100)) : 0;
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            ++data_line_count_;
        }
        file_reader.close();
        return dummy_slide_matrix;
    }
}

