/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ZeptosensLoader
implements FileLoader {
    private static int b532_col_;
    private static int b635_col_;
    private static int column_col_;
    private static int comment_col_;
    private static int data_end_line_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    SlideMatrix dummy_1;
    SlideMatrix dummy_slide_matrix_;
    private static int f532_col_;
    private static int f635_col_;
    private String[] feature_comment_;
    private static int max_lines_;
    private static int row_col_;
    private static int subgrid_col_;

    static {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_end_line_ = 0;
        data_lines_ = 0;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        int first_row = 0;
        int last_row = 0;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                ++max_lines_;
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                if (first_row == 0 && tokenizer.getCount() > 30) {
                    data_start_line_ = max_lines_ + 1;
                    ++first_row;
                    int gpr_cols = tokenizer.getCount();
                    int i = 0;
                    while (i < gpr_cols) {
                        String col_name = tokenizer.nextToken();
                        if (col_name.equals("Comment")) {
                            comment_col_ = i;
                        }
                        if (col_name.equals("Subgrid")) {
                            subgrid_col_ = i;
                        }
                        if (col_name.equals("Column")) {
                            column_col_ = i;
                        }
                        if (col_name.equals("Row")) {
                            row_col_ = i;
                        }
                        if (col_name.equals("Mean_WL1")) {
                            f635_col_ = i;
                        }
                        if (col_name.equals("Mean_bkg_WL1")) {
                            b635_col_ = i;
                        }
                        if (col_name.equals("Mean_WL2")) {
                            f532_col_ = i;
                        }
                        if (col_name.equals("Mean_bkg_WL2")) {
                            b532_col_ = i;
                        }
                        ++i;
                    }
                }
                if (first_row == 0 || tokenizer.getCount() >= 2 || last_row != 0) continue;
                ++last_row;
                data_end_line_ = max_lines_;
            }
            ++max_lines_;
            file_reader.close();
            data_lines_ = data_end_line_ - data_start_line_;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            this.dummy_1 = this.uploadSensichipFileAdaptive(input_file);
            dummy_ma = new MicroArrayData(this.dummy_1, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dummy_ma;
    }

    private SlideMatrix uploadSensichipFileAdaptive(File file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        this.dummy_slide_matrix_ = new SlideMatrix(data_lines_, 4);
        this.dummy_slide_matrix_.spot_nbr_[0] = 0;
        this.feature_comment_ = new String[data_lines_];
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (read_line.equals(null)) continue;
            StringTokenizer tokenizer = new StringTokenizer(read_line);
            int tokens_in_line = tokenizer.getCount();
            if (++line < data_start_line_ || line >= data_end_line_) continue;
            try {
                this.dummy_slide_matrix_.bloc_[ZeptosensLoader.data_line_count_] = 1;
                this.dummy_slide_matrix_.column_[ZeptosensLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(column_col_));
                this.dummy_slide_matrix_.row_[ZeptosensLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(row_col_));
                this.dummy_slide_matrix_.x_coord_[ZeptosensLoader.data_line_count_] = 100 + 15 * this.dummy_slide_matrix_.column_[data_line_count_];
                this.dummy_slide_matrix_.y_coord_[ZeptosensLoader.data_line_count_] = 100 + 15 * this.dummy_slide_matrix_.row_[data_line_count_];
                this.dummy_slide_matrix_.gene_name_[ZeptosensLoader.data_line_count_] = tokenizer.getToken(0);
                this.dummy_slide_matrix_.gene_id_[ZeptosensLoader.data_line_count_] = tokenizer.getToken(0);
                this.dummy_slide_matrix_.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635_col_)));
                this.dummy_slide_matrix_.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635_col_)));
                this.dummy_slide_matrix_.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f532_col_)));
                this.dummy_slide_matrix_.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b532_col_)));
                this.dummy_slide_matrix_.flag_[ZeptosensLoader.data_line_count_] = 0;
                this.feature_comment_[ZeptosensLoader.data_line_count_] = tokenizer.getToken(comment_col_);
                if (this.feature_comment_[data_line_count_].indexOf("excluded") > 0) {
                    this.dummy_slide_matrix_.flag_[ZeptosensLoader.data_line_count_] = -100;
                }
                if (this.dummy_slide_matrix_.gene_name_[data_line_count_].startsWith("H")) {
                    this.dummy_slide_matrix_.gene_name_[ZeptosensLoader.data_line_count_] = "CP_" + this.dummy_slide_matrix_.gene_name_[data_line_count_];
                }
                if (this.dummy_slide_matrix_.gene_name_[data_line_count_].startsWith("P")) {
                    this.dummy_slide_matrix_.gene_name_[ZeptosensLoader.data_line_count_] = "CN_" + this.dummy_slide_matrix_.gene_name_[data_line_count_];
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("crashed while reading file _ " + ex);
                ex.printStackTrace();
            }
            ++data_line_count_;
        }
        file_reader.close();
        return this.dummy_slide_matrix_;
    }
}

