/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.filter;

import at.tugraz.genome.arraynormcore.filter.FilterMethod;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.math.MathFunctions;

public class DyeswapSymmFixFilter
implements FilterMethod {
    private static float[][] averageDyeswapped(ExperimentData.ExpClass exp_class) {
        float mean_temp = 0.0f;
        int row = 3;
        int num_spots = exp_class.num_spots_;
        int num_dys_slids = exp_class.num_dysw_slides_;
        float[][] help_matrix = new float[num_dys_slids][num_spots];
        float[] temp = new float[num_dys_slids];
        float[][] ave_data = new float[3][num_spots];
        int k_ = 0;
        while (k_ < 2) {
            int he = 0;
            while (he < num_dys_slids) {
                help_matrix[he] = exp_class.expclass_dysw_data_[he][k_];
                ++he;
            }
            int j_ = 0;
            while (j_ < num_spots) {
                int i_ = 0;
                while (i_ < num_dys_slids) {
                    temp[i_] = help_matrix[i_][j_];
                    ++i_;
                }
                ave_data[k_][j_] = mean_temp = MathFunctions.mean(temp);
                ++j_;
            }
            ++k_;
        }
        ave_data[2] = MathFunctions.ratioOfArrays(ave_data[0], ave_data[1]);
        return ave_data;
    }

    public int filter(ExperimentData.ExpClass exp_class, float factor) {
        int num_filtered_spots = 0;
        if (exp_class.all_dyeswapped_) {
            System.out.println("filtering not possible, all are dyeswapped...");
        } else if (!exp_class.any_dyeswapt_) {
            System.out.println("filtering not possible, none are dyeswapped...");
        } else {
            int num_normal = exp_class.num_normal_slides_;
            int num_dysw = exp_class.num_dysw_slides_;
            int[] pindex_normal = exp_class.pairs_index_normal_;
            int[] pindex_dysw = exp_class.pairs_index_dysw_;
            if (num_normal == pindex_normal.length) {
                System.out.println("hepp, correct number of normal slides");
            } else {
                System.out.println("uje, no correct number of normal slides");
            }
            if (num_dysw == pindex_dysw.length) {
                System.out.println("hepp, correct number of dysw slides");
            } else {
                System.out.println("uje, no correct number of dysw slides");
            }
            float[][] ave_dysw = DyeswapSymmFixFilter.averageDyeswapped(exp_class);
            int cnt_i = 0;
            while (cnt_i < num_normal) {
                if (pindex_normal[cnt_i] == 0) {
                    System.out.println("index of normal was zero, take the template!");
                    num_filtered_spots = DyeswapSymmFixFilter.filterEngine(exp_class.expclass_normal_data_[cnt_i], ave_dysw, factor);
                    exp_class.expclass_dysw_data_[cnt_i][0] = ave_dysw[0];
                    exp_class.expclass_dysw_data_[cnt_i][1] = ave_dysw[1];
                } else if (pindex_normal[cnt_i] != 0) {
                    System.out.println("index of normal was " + pindex_normal[cnt_i]);
                    int cnt_j = 0;
                    while (cnt_j < num_dysw) {
                        if (pindex_normal[cnt_i] == pindex_dysw[cnt_j]) {
                            System.out.println("pair found:: slide_norm " + cnt_i + " slide_dysw " + cnt_j);
                            num_filtered_spots = DyeswapSymmFixFilter.filterEngine(exp_class.expclass_normal_data_[cnt_i], exp_class.expclass_dysw_data_[cnt_j], factor);
                        } else if (pindex_normal[cnt_i] != pindex_dysw[cnt_j]) {
                            System.out.println("no matching pindex at " + pindex_dysw[cnt_j]);
                        }
                        ++cnt_j;
                    }
                }
                ++cnt_i;
            }
        }
        exp_class.class_norm_method_ = "dyeswapMean1FixFiltered";
        return num_filtered_spots;
    }

    private static int filterEngine(float[][] normal, float[][] dysw, float factor) {
        int filtered_spots = 0;
        float[] cy5_n = normal[0];
        float[] cy3_n = normal[1];
        float[] cy5_d = dysw[0];
        float[] cy3_d = dysw[1];
        System.out.println("-------you are going to filter the data!-------------");
        float[] t1 = MathFunctions.ratioOfArrays(cy5_n, cy3_n);
        float[] t2 = MathFunctions.ratioOfArrays(cy5_d, cy3_d);
        float[] t1_log = MathFunctions.log2(t1);
        float[] t2_log = MathFunctions.log2(t2);
        System.out.println("[DyeswapRegressionFilter::filterengine] -> num_good_spots in t1 = " + MathFunctions.countReliableValues(t1_log));
        System.out.println("[DyeswapRegressionFilter::filterengine] -> num_good_spots in t2 = " + MathFunctions.countReliableValues(t2_log));
        System.out.println("[DyeswapRegressionFilter::filterengine] -> filterfactor = " + factor);
        float filter_thres = factor;
        System.out.println("[DyeswapRegressionFilter::filterengine] -> filter_thres = " + filter_thres);
        float[] sum_abs = MathFunctions.addArrays(t1_log, t2_log);
        sum_abs = MathFunctions.absoluteArray(sum_abs);
        float[] sum_abs_norm = MathFunctions.divideArrayByConst(sum_abs, filter_thres);
        int i = 0;
        while (i < sum_abs_norm.length) {
            if (sum_abs_norm[i] > 1.0f) {
                ++filtered_spots;
                normal[0][i] = Float.NaN;
                normal[1][i] = Float.NaN;
                normal[2][i] = Float.NaN;
                dysw[0][i] = Float.NaN;
                dysw[1][i] = Float.NaN;
                dysw[2][i] = Float.NaN;
            }
            ++i;
        }
        System.out.println("[DyeswapRegressionFilter::filterengine] -> found filtered: " + filtered_spots);
        return filtered_spots;
    }
}

