/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.filtering;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;

public class FilterFunctions {
    private static final boolean DEBUG = true;

    public static void filterForeBackCriterion(ExperimentData.ExpClass exp_class) {
        int i;
        int num_spots = exp_class.num_spots_;
        int slide_cnt = 0;
        while (slide_cnt < exp_class.num_normal_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_normal_data_[slide_cnt][0][i] < exp_class.expclass_normal_data_[slide_cnt][3][i] || exp_class.expclass_normal_data_[slide_cnt][1][i] < exp_class.expclass_normal_data_[slide_cnt][4][i]) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
        slide_cnt = 0;
        while (slide_cnt < exp_class.num_dysw_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_dysw_data_[slide_cnt][0][i] < exp_class.expclass_dysw_data_[slide_cnt][3][i] || exp_class.expclass_dysw_data_[slide_cnt][1][i] < exp_class.expclass_dysw_data_[slide_cnt][4][i]) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
    }

    public static void filterMaxCriterion(ExperimentData.ExpClass exp_class, float max_intens) {
        int i;
        int num_spots = exp_class.num_spots_;
        int slide_cnt = 0;
        while (slide_cnt < exp_class.num_normal_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_normal_data_[slide_cnt][0][i] > max_intens || exp_class.expclass_normal_data_[slide_cnt][1][i] > max_intens) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
        slide_cnt = 0;
        while (slide_cnt < exp_class.num_dysw_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_dysw_data_[slide_cnt][0][i] > max_intens || exp_class.expclass_dysw_data_[slide_cnt][1][i] > max_intens) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
    }

    public static void filterMinCriterion(ExperimentData.ExpClass exp_class, float min_intens) {
        int i;
        int num_spots = exp_class.num_spots_;
        int slide_cnt = 0;
        while (slide_cnt < exp_class.num_normal_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_normal_data_[slide_cnt][0][i] < min_intens || exp_class.expclass_normal_data_[slide_cnt][1][i] < min_intens) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
        slide_cnt = 0;
        while (slide_cnt < exp_class.num_dysw_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_dysw_data_[slide_cnt][0][i] < min_intens || exp_class.expclass_dysw_data_[slide_cnt][1][i] < min_intens) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
    }

    public static void filterSumOfForegroundsCriterion(ExperimentData.ExpClass exp_class, float min_sum) {
        int i;
        int num_spots = exp_class.num_spots_;
        int slide_cnt = 0;
        while (slide_cnt < exp_class.num_normal_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_normal_data_[slide_cnt][0][i] + exp_class.expclass_normal_data_[slide_cnt][1][i] < min_sum) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
        slide_cnt = 0;
        while (slide_cnt < exp_class.num_dysw_slides_) {
            i = 0;
            while (i < num_spots) {
                if (exp_class.expclass_dysw_data_[slide_cnt][0][i] + exp_class.expclass_dysw_data_[slide_cnt][1][i] < min_sum) {
                    exp_class.flag_[i] = -100;
                }
                ++i;
            }
            ++slide_cnt;
        }
    }
}

