/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.math;

public class SpecialFunctions {
    double betacf(double a, double b, double x) {
        int maxIterations = 50;
        int m = 1;
        double eps = 3.0E-5;
        double am = 1.0;
        double bm = 1.0;
        double az = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * x / qap;
        double aold = 0.0;
        while (m < maxIterations && Math.abs(az - aold) >= eps * Math.abs(az)) {
            double em = m;
            double tem = em + em;
            double d = em * (b - (double)m) * x / ((qam + tem) * (a + tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -(a + em) * (qab + em) * x / ((a + tem) * (qap + tem));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            aold = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            ++m;
        }
        return az;
    }

    public double betai(double a, double b, double x) {
        Double er = new Double(0.0);
        double bt = 0.0;
        double beta = Double.POSITIVE_INFINITY;
        if (x == 0.0 || x == 1.0) {
            bt = 0.0;
        } else if (x > 0.0 && x < 1.0) {
            bt = this.gamma(a + b) * Math.pow(x, a) * Math.pow(1.0 - x, b) / (this.gamma(a) * this.gamma(b));
        }
        beta = x < (a + 1.0) / (a + b + 2.0) ? bt * this.betacf(a, b, x) / a : 1.0 - bt * this.betacf(b, a, 1.0 - x) / b;
        return beta;
    }

    public double fDist(double v1, double v2, double f) {
        double p = this.betai(v1 / 2.0, v2 / 2.0, v1 / (v1 + v2 * f));
        return p;
    }

    public double gamma(double x) {
        double f = 1.0E100;
        double g = 1.0;
        if (x > 0.0) {
            while (x < 3.0) {
                g *= x;
                x += 1.0;
            }
            f = (1.0 - 2.0 / (7.0 * Math.pow(x, 2.0)) * (1.0 - 2.0 / (3.0 * Math.pow(x, 2.0)))) / (30.0 * Math.pow(x, 2.0));
            f = (1.0 - f) / (12.0 * x) + x * (Math.log(x) - 1.0);
            f = Math.exp(f) / g * Math.pow(Math.PI * 2 / x, 0.5);
        } else {
            Double er = new Double(0.0);
            f = Double.POSITIVE_INFINITY;
        }
        return f;
    }

    public double logGamma(double xx) {
        double stp = 2.50662827465;
        double[] cof = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp = (x + 0.5) * Math.log(tmp) - tmp;
        double ser = 1.0;
        int j = 0;
        while (j < 6) {
            ser += cof[j] / (x += 1.0);
            ++j;
        }
        double retVal = tmp + Math.log(stp * ser);
        return retVal;
    }

    public double stDist(double v, double t) {
        double sm = 0.5;
        double u = 0.0;
        double sign = 1.0;
        double stepSize = t / 5000.0;
        if (t < 0.0) {
            sign = -1.0;
        }
        u = 0.0;
        while (u <= sign * t) {
            sm += stepSize * this.student_tDen(v, u);
            u += stepSize;
        }
        sm = sign < 0.0 ? 0.5 - sm : 1.0 - sm;
        if (sm < 0.0) {
            sm = 0.0;
        } else if (sm > 1.0) {
            sm = 1.0;
        }
        return sm;
    }

    public double student_c(double v) {
        return Math.exp(this.logGamma((v + 1.0) / 2.0)) / (Math.sqrt(Math.PI * v) * Math.exp(this.logGamma(v / 2.0)));
    }

    public double student_tDen(double v, double t) {
        return this.student_c(v) * Math.pow(1.0 + t * t / v, -0.5 * (v + 1.0));
    }
}

