/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.math;

public class StatisticFunctions {
    public static double[] calcLinRegression(double[] x_in, double[] y_in) {
        double[] data_out = new double[3];
        int N = 0;
        int num_points_in = 0;
        double sumx = 0.0;
        double sumy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sumxy = 0.0;
        double x = 0.0;
        double y = 0.0;
        num_points_in = x_in.length;
        int i = 0;
        while (i < num_points_in) {
            x = x_in[i];
            y = y_in[i];
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                sumx += x;
                sumy += y;
                sumx2 += x * x;
                sumy2 += y * y;
                sumxy += x * y;
                ++N;
            }
            ++i;
        }
        double a = ((double)N * sumxy - sumx * sumy) / ((double)N * sumx2 - sumx * sumx);
        double b = (sumy - a * sumx) / (double)N;
        double r = ((double)N * sumxy - sumx * sumy) / Math.sqrt(((double)N * sumx2 - sumx * sumx) * ((double)N * sumy2 - sumy * sumy));
        data_out[0] = a;
        data_out[1] = b;
        data_out[2] = r;
        return data_out;
    }

    public static void main(String[] args) {
        StatisticFunctions.testDriver();
    }

    private static void testDriver() {
        double[] xin = new double[]{3.0, 2.0, Double.NaN, 5.0, 6.0, 34.0};
        double[] yin = new double[]{9.0, 7.0, 12.0, 15.0, 17.0, 12.0};
        double[] result = StatisticFunctions.calcLinRegression(xin, yin);
        double a = result[0];
        double b = result[1];
        double r = result[2];
        System.out.println("[StatisticFunction::testDriver -> ");
        System.out.println("---------> a = " + a);
        System.out.println("---------> b = " + b);
        System.out.println("---------> r = " + r);
    }
}

