/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.microarrayobjects;

import at.tugraz.genome.arraynormcore.microarrayobjects.FloatMatrix;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.math.MathFunctions;
import java.util.Vector;

public class MicroArrayData
extends FloatMatrix {
    private static final int NUM_OF_DATA_COLUMS = 4;
    public int absent_spots_;
    private float[] b532mean_;
    private float[] b532median_;
    private float[] b532sd_;
    private float[] b635mean_;
    private float[] b635median_;
    private float[] b635sd_;
    public int bad_spots_;
    private String barcode_;
    public int[] column_;
    private String comment_;
    private String creator_;
    private String date_time_;
    private float[] f532mean_;
    private float[] f532median_;
    private float[] f532sd_;
    private float[] f635mean_;
    private float[] f635median_;
    private float[] f635sd_;
    public int[] flag_;
    private String gal_file_;
    public String[] gene_id_;
    public String[] gene_name_;
    private Vector grid_object_ = null;
    public boolean has_controls_;
    public boolean has_rep_spots_;
    private String imagefiles_;
    public int[] index_;
    public boolean is_dyeswapped_;
    private String laser_powers_;
    private String lasers_on_time_;
    public int[] mars_id_;
    public float max_intens_value_ = 80000.0f;
    private float[] meanofratios_ch12_;
    private float[] medianofratios_ch12_;
    public int[] meta_bloc_;
    public int[] meta_column_;
    public int[] meta_row_;
    public float min_intens_value_ = 100.0f;
    private String normalization_factors_;
    private String normalization_method_;
    public int notfound_spots_;
    public int num_biol_cond_;
    public int num_blocs_;
    public int num_genes_;
    public int num_reps_;
    public int num_spots_;
    private float[][] original_data_matrix_;
    private String pmt_gains_;
    public int quicksort_level = 0;
    private float[] ratioofmeans_ch12_;
    private float[] ratioofmedians_ch12_;
    private float[] rng_ratios_;
    public int[] row_;
    private String scan_powers_;
    private String scanner_;
    public int selfnorm_pair_;
    public String short_info_;
    public Long slide_id_;
    private Vector slide_information_vector_ = null;
    public String slide_name_;
    public int src_file_index_;
    private String temperature_;
    private String type_;
    private String wavelenghts_;

    public MicroArrayData(SlideMatrix src_matrix, Vector info_set) {
        super(src_matrix.num_spots_, 4);
        int[] fetch_int = (int[])info_set.get(0);
        boolean[] fetch_bool = (boolean[])info_set.get(2);
        this.src_file_index_ = fetch_int[0];
        this.num_biol_cond_ = fetch_int[1];
        this.is_dyeswapped_ = fetch_bool[0];
        this.has_rep_spots_ = fetch_bool[1];
        this.has_controls_ = fetch_bool[2];
        this.slide_name_ = (String)info_set.get(3);
        this.short_info_ = (String)info_set.get(4);
        this.slide_id_ = (Long)info_set.get(5);
        this.num_spots_ = src_matrix.num_spots_;
        this.num_reps_ = 1;
        this.num_genes_ = this.num_spots_ / this.num_reps_;
        this.index_ = new int[this.num_spots_];
        this.meta_bloc_ = new int[this.num_spots_];
        this.meta_column_ = new int[this.num_spots_];
        this.meta_row_ = new int[this.num_spots_];
        this.column_ = new int[this.num_spots_];
        this.row_ = new int[this.num_spots_];
        this.gene_id_ = new String[this.num_spots_];
        this.gene_name_ = new String[this.num_spots_];
        this.flag_ = new int[this.num_spots_];
        this.mars_id_ = new int[this.num_spots_];
        this.original_data_matrix_ = new float[this.num_spots_][4];
        this.index_ = src_matrix.spot_nbr_;
        this.meta_bloc_ = src_matrix.bloc_;
        this.meta_column_ = src_matrix.meta_column_;
        this.meta_row_ = src_matrix.meta_row_;
        this.column_ = src_matrix.column_;
        this.row_ = src_matrix.row_;
        this.gene_id_ = src_matrix.gene_id_;
        this.gene_name_ = src_matrix.gene_name_;
        this.flag_ = src_matrix.flag_;
        this.mars_id_ = src_matrix.mars_id_;
        this.DataMatrix_ = src_matrix.DataMatrix_;
        this.original_data_matrix_ = (float[][])this.DataMatrix_.clone();
        this.grid_object_ = new Vector();
        this.grid_object_.add(this.meta_bloc_);
        this.grid_object_.add(this.meta_column_);
        this.grid_object_.add(this.meta_row_);
        this.grid_object_.add(this.column_);
        this.grid_object_.add(this.row_);
        int[] add_ints = new int[]{this.num_spots_, this.num_genes_, this.num_reps_};
        this.slide_information_vector_ = new Vector();
        this.slide_information_vector_.add(add_ints);
        this.checkIfForegroundHigherThanBackground();
        this.setAbsentOrNotFoundSpotsToBad();
        this.setValuesOfBadSpotsToNaN();
        this.f635median_ = new float[this.lines_];
        int i = 0;
        while (i < this.lines_) {
            this.f635median_[i] = this.DataMatrix_[i][0];
            ++i;
        }
        this.b635median_ = new float[this.lines_];
        int i2 = 0;
        while (i2 < this.lines_) {
            this.b635median_[i2] = this.DataMatrix_[i2][1];
            ++i2;
        }
        this.f532median_ = new float[this.lines_];
        int i3 = 0;
        while (i3 < this.lines_) {
            this.f532median_[i3] = this.DataMatrix_[i3][2];
            ++i3;
        }
        this.b532median_ = new float[this.lines_];
        int i4 = 0;
        while (i4 < this.lines_) {
            this.b532median_[i4] = this.DataMatrix_[i4][3];
            ++i4;
        }
    }

    private void checkIfForegroundHigherThanBackground() {
        int cnt = 0;
        while (cnt < this.num_spots_) {
            if (this.flag_[cnt] > -50) {
                if (this.DataMatrix_[cnt][0] <= this.DataMatrix_[cnt][1]) {
                    this.flag_[cnt] = -100;
                }
                if (this.DataMatrix_[cnt][2] <= this.DataMatrix_[cnt][3]) {
                    this.flag_[cnt] = -100;
                }
            }
            ++cnt;
        }
    }

    public float[] getB532mean_() {
        return this.b532mean_;
    }

    public float[] getB532median_() {
        return this.b532median_;
    }

    public float[] getB532sd_() {
        return this.b532sd_;
    }

    public float[] getB635mean_() {
        return this.b635mean_;
    }

    public float[] getB635median_() {
        return this.b635median_;
    }

    public float[] getB635sd_() {
        return this.b635sd_;
    }

    public String getBarcode_() {
        return this.barcode_;
    }

    public String getComment_() {
        return this.comment_;
    }

    public String getCreator_() {
        return this.creator_;
    }

    public float[][] getDataMatrix() {
        return this.DataMatrix_;
    }

    public String getDate_time_() {
        return this.date_time_;
    }

    public float[] getF532mean_() {
        return this.f532mean_;
    }

    public float[] getF532median_() {
        return this.f532median_;
    }

    public float[] getF532sd_() {
        return this.f532sd_;
    }

    public float[] getF635mean_() {
        return this.f635mean_;
    }

    public float[] getF635median_() {
        return this.f635median_;
    }

    public float[] getF635sd_() {
        return this.f635sd_;
    }

    public String getGal_file_() {
        return this.gal_file_;
    }

    public Vector getGridObject() {
        return this.grid_object_;
    }

    public String getImagefiles_() {
        return this.imagefiles_;
    }

    public String getLaser_powers_() {
        return this.laser_powers_;
    }

    public String getLasers_on_time_() {
        return this.lasers_on_time_;
    }

    public float getMax_intens_value_() {
        return this.max_intens_value_;
    }

    public float[] getMeanofratios_ch12_() {
        return this.meanofratios_ch12_;
    }

    public float[] getMedianofratios_ch12_() {
        return this.medianofratios_ch12_;
    }

    public String getNormalization_factors_() {
        return this.normalization_factors_;
    }

    public String getNormalization_method_() {
        return this.normalization_method_;
    }

    public float[][] getOriginalMatrix() {
        return this.original_data_matrix_;
    }

    public String getPmt_gains_() {
        return this.pmt_gains_;
    }

    public float[] getRatioofmeans_ch12_() {
        return this.ratioofmeans_ch12_;
    }

    public float[] getRatioofmedians_ch12_() {
        return this.ratioofmedians_ch12_;
    }

    public float[] getRng_ratios_() {
        return this.rng_ratios_;
    }

    public String getScan_powers_() {
        return this.scan_powers_;
    }

    public String getScanner_() {
        return this.scanner_;
    }

    public Vector getSlide_information_vector_() {
        return this.slide_information_vector_;
    }

    public String getTemperature_() {
        return this.temperature_;
    }

    public String getType_() {
        return this.type_;
    }

    public String getWavelenghts_() {
        return this.wavelenghts_;
    }

    public void precalculateImprotantData() {
        this.f635mean_ = new float[this.lines_];
        int i = 0;
        while (i < this.lines_) {
            this.f635mean_[i] = this.DataMatrix_[i][4];
            ++i;
        }
        this.b635mean_ = new float[this.lines_];
        int i2 = 0;
        while (i2 < this.lines_) {
            this.b635mean_[i2] = this.DataMatrix_[i2][5];
            ++i2;
        }
        this.f532mean_ = new float[this.lines_];
        int i3 = 0;
        while (i3 < this.lines_) {
            this.f532mean_[i3] = this.DataMatrix_[i3][6];
            ++i3;
        }
        this.b532mean_ = new float[this.lines_];
        int i4 = 0;
        while (i4 < this.lines_) {
            this.b532mean_[i4] = this.DataMatrix_[i4][7];
            ++i4;
        }
        this.f635sd_ = new float[this.lines_];
        int i5 = 0;
        while (i5 < this.lines_) {
            this.f635sd_[i5] = this.DataMatrix_[i5][8];
            ++i5;
        }
        this.b635sd_ = new float[this.lines_];
        int i6 = 0;
        while (i6 < this.lines_) {
            this.b635sd_[i6] = this.DataMatrix_[i6][9];
            ++i6;
        }
        this.f532sd_ = new float[this.lines_];
        int i7 = 0;
        while (i7 < this.lines_) {
            this.f532sd_[i7] = this.DataMatrix_[i7][10];
            ++i7;
        }
        this.b532sd_ = new float[this.lines_];
        int i8 = 0;
        while (i8 < this.lines_) {
            this.b532sd_[i8] = this.DataMatrix_[i8][11];
            ++i8;
        }
        this.ratioofmedians_ch12_ = new float[this.lines_];
        int i9 = 0;
        while (i9 < this.lines_) {
            this.ratioofmedians_ch12_[i9] = this.DataMatrix_[i9][12];
            ++i9;
        }
        this.ratioofmeans_ch12_ = new float[this.lines_];
        int i10 = 0;
        while (i10 < this.lines_) {
            this.ratioofmeans_ch12_[i10] = this.DataMatrix_[i10][13];
            ++i10;
        }
        this.medianofratios_ch12_ = new float[this.lines_];
        int i11 = 0;
        while (i11 < this.lines_) {
            this.medianofratios_ch12_[i11] = this.DataMatrix_[i11][14];
            ++i11;
        }
        this.meanofratios_ch12_ = new float[this.lines_];
        int i12 = 0;
        while (i12 < this.lines_) {
            this.meanofratios_ch12_[i12] = this.DataMatrix_[i12][15];
            ++i12;
        }
        this.rng_ratios_ = new float[this.lines_];
        int i13 = 0;
        while (i13 < this.lines_) {
            this.rng_ratios_[i13] = this.DataMatrix_[i13][16];
            ++i13;
        }
    }

    public void printSomeValues() {
        System.out.println("[MicroArrayData::printsomevalues]-----------------------");
        int i = 100;
        while (i < 120) {
            System.out.println("f635med[" + i + "] = " + this.getF635median_()[i]);
            ++i;
        }
        int i2 = 100;
        while (i2 < 120) {
            System.out.println("f532med[" + i2 + "] = " + this.getF532median_()[i2]);
            ++i2;
        }
    }

    private void quickSort(float[] elements, int sort_index, int low_index, int high_index) {
        float[] trans = new float[4];
        ++this.quicksort_level;
        int low_to_high_index = low_index;
        int high_to_low_index = high_index;
        int pivot_index = (low_to_high_index + high_to_low_index) / 2;
        float pivotValue = elements[pivot_index];
        int new_low_index = high_index + 1;
        int new_high_index = low_index - 1;
        while (new_high_index + 1 < new_low_index) {
            float low_to_high_value = elements[low_to_high_index];
            while (low_to_high_index < new_low_index & low_to_high_value < pivotValue) {
                new_high_index = low_to_high_index++;
                low_to_high_value = elements[low_to_high_index];
            }
            float high_to_low_value = elements[high_to_low_index];
            while (new_high_index <= high_to_low_index & high_to_low_value > pivotValue) {
                new_low_index = high_to_low_index--;
                high_to_low_value = elements[high_to_low_index];
            }
            if (low_to_high_index == high_to_low_index) {
                new_high_index = low_to_high_index;
                continue;
            }
            if (low_to_high_index >= high_to_low_index || !(low_to_high_value >= high_to_low_value)) continue;
            float parking = low_to_high_value;
            elements[low_to_high_index] = high_to_low_value;
            elements[high_to_low_index] = parking;
            int col_cnt = 0;
            while (col_cnt < 4) {
                trans[col_cnt] = this.DataMatrix_[low_to_high_index][col_cnt];
                this.DataMatrix_[low_to_high_index][col_cnt] = this.DataMatrix_[high_to_low_index][col_cnt];
                this.DataMatrix_[high_to_low_index][col_cnt] = trans[col_cnt];
                ++col_cnt;
            }
            int trans_meta_column = this.meta_column_[low_to_high_index];
            int trans_meta_row = this.meta_row_[low_to_high_index];
            int trans_column = this.column_[low_to_high_index];
            int trans_row = this.row_[low_to_high_index];
            String trans_gene_id = this.gene_id_[low_to_high_index];
            String trans_gene_name = this.gene_name_[low_to_high_index];
            int trans_flag = this.flag_[low_to_high_index];
            this.meta_column_[low_to_high_index] = this.meta_column_[high_to_low_index];
            this.meta_row_[low_to_high_index] = this.meta_row_[high_to_low_index];
            this.column_[low_to_high_index] = this.column_[high_to_low_index];
            this.row_[low_to_high_index] = this.row_[high_to_low_index];
            this.gene_id_[low_to_high_index] = this.gene_id_[high_to_low_index];
            this.gene_name_[low_to_high_index] = this.gene_name_[high_to_low_index];
            this.flag_[low_to_high_index] = this.flag_[high_to_low_index];
            this.meta_column_[high_to_low_index] = trans_meta_column;
            this.meta_row_[high_to_low_index] = trans_meta_row;
            this.column_[high_to_low_index] = trans_column;
            this.row_[high_to_low_index] = trans_row;
            this.gene_id_[high_to_low_index] = trans_gene_id;
            this.gene_name_[high_to_low_index] = trans_gene_name;
            this.flag_[high_to_low_index] = trans_flag;
            new_low_index = high_to_low_index--;
            new_high_index = low_to_high_index++;
        }
        if (low_index < new_high_index) {
            this.quickSort(elements, sort_index, low_index, new_high_index);
        }
        if (new_low_index < high_index) {
            this.quickSort(elements, sort_index, new_low_index, high_index);
        }
    }

    public void quickSortEntire(int col_index) {
        float[] sort_input = new float[this.num_spots_];
        int i = 0;
        while (i < this.num_spots_) {
            sort_input[i] = this.DataMatrix_[i][col_index];
            ++i;
        }
        this.quickSort(sort_input, col_index, 0, sort_input.length - 1);
    }

    private void renameGeneIDsAndNames() {
        int i = 0;
        while (i < this.num_spots_) {
            try {
                this.gene_id_[i] = this.gene_id_[i].replaceAll("\"", "");
                this.gene_name_[i] = this.gene_name_[i].replaceAll("\"", "");
            }
            catch (Exception ex) {
                System.out.println("aufgehauen in line:: " + i);
                ex.printStackTrace();
            }
            ++i;
        }
    }

    private void setAbsentOrNotFoundSpotsToBad() {
        this.bad_spots_ = 0;
        this.notfound_spots_ = 0;
        this.absent_spots_ = 0;
        int cnt = 0;
        while (cnt < this.num_spots_) {
            if (this.flag_[cnt] == -50) {
                this.flag_[cnt] = -100;
                ++this.notfound_spots_;
                ++this.bad_spots_;
            } else if (this.flag_[cnt] == -75) {
                this.flag_[cnt] = -100;
                ++this.absent_spots_;
                ++this.bad_spots_;
            } else if (this.flag_[cnt] == -100) {
                ++this.bad_spots_;
            }
            ++cnt;
        }
    }

    public void setBarcode_(String barcode_) {
        this.barcode_ = barcode_;
    }

    public void setComment_(String comment_) {
        this.comment_ = comment_;
    }

    public void setCreator_(String creator_) {
        this.creator_ = creator_;
    }

    public void setDate_time_(String date_time_) {
        this.date_time_ = date_time_;
    }

    private void setExtremeSpotsToBad() {
        int down_spots = 0;
        boolean up_spots = false;
        int i = 0;
        while (i < this.num_spots_) {
            if (this.DataMatrix_[i][0] < this.min_intens_value_ || this.DataMatrix_[i][2] < this.min_intens_value_) {
                this.flag_[i] = -100;
                ++down_spots;
            } else if (this.DataMatrix_[i][0] > this.max_intens_value_ || this.DataMatrix_[i][2] > this.max_intens_value_) {
                this.flag_[i] = -100;
            }
            ++i;
        }
    }

    public void setGal_file_(String gal_file_) {
        this.gal_file_ = gal_file_;
    }

    public void setImagefiles_(String imagefiles_) {
        this.imagefiles_ = imagefiles_;
    }

    public void setLaser_powers_(String laser_powers_) {
        this.laser_powers_ = laser_powers_;
    }

    public void setLasers_on_time_(String lasers_on_time_) {
        this.lasers_on_time_ = lasers_on_time_;
    }

    public void setNormalization_factors_(String normalization_factors_) {
        this.normalization_factors_ = normalization_factors_;
    }

    public void setNormalization_method_(String normalization_method_) {
        this.normalization_method_ = normalization_method_;
    }

    public void setPmt_gains_(String pmt_gains_) {
        this.pmt_gains_ = pmt_gains_;
    }

    public void setScan_powers_(String scan_powers_) {
        this.scan_powers_ = scan_powers_;
    }

    public void setScanner_(String scanner_) {
        this.scanner_ = scanner_;
    }

    public void setTemperature_(String temperature_) {
        this.temperature_ = temperature_;
    }

    public void setType_(String type_) {
        this.type_ = type_;
    }

    private void setValuesOfBadSpotsToNaN() {
        int len = this.DataMatrix_[0].length;
        int cnt = 0;
        while (cnt < this.num_spots_) {
            if (this.flag_[cnt] == -100) {
                int i = 0;
                while (i < len) {
                    this.DataMatrix_[cnt][i] = Float.NaN;
                    ++i;
                }
            }
            ++cnt;
        }
    }

    public void setWavelenghts_(String wavelenghts_) {
        this.wavelenghts_ = wavelenghts_;
    }

    public Vector slideReport() {
        Vector<Object[]> slide_report = new Vector<Object[]>();
        int[] add_int = new int[6];
        boolean[] add_bool = new boolean[3];
        float[] add_float = new float[8];
        float f635_mean = MathFunctions.mean(this.getF635median_());
        float f635_med = MathFunctions.median(this.getF635median_());
        float f635_stddev = MathFunctions.stddeviation(this.getF635median_());
        float f532_mean = MathFunctions.mean(this.getF532median_());
        float f532_med = MathFunctions.median(this.getF532median_());
        float f532_stddev = MathFunctions.stddeviation(this.getF532median_());
        float[] dummy_ratio = MathFunctions.ratioOfArrays(this.getF635median_(), this.getF532median_());
        float ratio_mean = MathFunctions.mean(dummy_ratio);
        float ratio_stddev = MathFunctions.stddeviation(dummy_ratio);
        add_float[0] = f635_mean;
        add_float[1] = f635_med;
        add_float[2] = f635_stddev;
        add_float[3] = f532_mean;
        add_float[4] = f532_med;
        add_float[5] = f532_stddev;
        add_float[6] = ratio_mean;
        add_float[7] = ratio_stddev;
        float dum_flo1 = (float)this.num_spots_ + 0.0f;
        float dum_flo2 = (float)this.bad_spots_ + 0.0f;
        this.num_blocs_ = MathFunctions.max(this.meta_bloc_);
        float bad_to_all = dum_flo2 > 0.0f ? dum_flo2 / dum_flo1 * 100.0f : 0.0f;
        add_int[0] = this.num_blocs_;
        add_int[1] = this.num_spots_;
        add_int[2] = this.absent_spots_;
        add_int[3] = this.notfound_spots_;
        add_int[4] = this.bad_spots_;
        add_int[5] = Math.round(bad_to_all);
        add_bool[0] = this.is_dyeswapped_;
        add_bool[1] = this.has_controls_;
        add_bool[2] = this.has_rep_spots_;
        slide_report.add(add_float);
        slide_report.add(add_int);
        slide_report.add(add_bool);
        return slide_report;
    }

    public void sortMicroArrayByColumn(int col_index) {
        float[] dummy = new float[this.num_spots_];
        float[] trans = new float[4];
        int i = 0;
        while (i < this.num_spots_) {
            dummy[i] = this.DataMatrix_[i][col_index];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.num_spots_ - 1) {
            int j = this.num_spots_ - 1;
            while (j > i2) {
                if (dummy[j] < dummy[j - 1]) {
                    int col_cnt = 0;
                    while (col_cnt < 4) {
                        trans[col_cnt] = this.DataMatrix_[j][col_cnt];
                        this.DataMatrix_[j][col_cnt] = this.DataMatrix_[j - 1][col_cnt];
                        this.DataMatrix_[j - 1][col_cnt] = trans[col_cnt];
                        ++col_cnt;
                    }
                    int trans_meta_column = this.meta_column_[j];
                    int trans_meta_row = this.meta_row_[j];
                    int trans_column = this.column_[j];
                    int trans_row = this.row_[j];
                    String trans_gene_id = this.gene_id_[j];
                    String trans_gene_name = this.gene_name_[j];
                    int trans_flag = this.flag_[j];
                    this.meta_column_[j] = this.meta_column_[j - 1];
                    this.meta_row_[j] = this.meta_row_[j - 1];
                    this.column_[j] = this.column_[j - 1];
                    this.row_[j] = this.row_[j - 1];
                    this.gene_id_[j] = this.gene_id_[j - 1];
                    this.gene_name_[j] = this.gene_name_[j - 1];
                    this.flag_[j] = this.flag_[j - 1];
                    this.meta_column_[j - 1] = trans_meta_column;
                    this.meta_row_[j - 1] = trans_meta_row;
                    this.column_[j - 1] = trans_column;
                    this.row_[j - 1] = trans_row;
                    this.gene_id_[j - 1] = trans_gene_id;
                    this.gene_name_[j - 1] = trans_gene_name;
                    this.flag_[j - 1] = trans_flag;
                }
                --j;
            }
            ++i2;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public float[][] splitSlideIntoBlocs(float[] dummy_array) {
        int max_blocs = 0;
        int spots_per_bloc = 0;
        max_blocs = MathFunctions.max(this.meta_bloc_);
        int max_cols = MathFunctions.max(this.column_);
        int max_rows = MathFunctions.max(this.row_);
        spots_per_bloc = max_cols * max_rows;
        float[][] meta_array = new float[max_blocs][spots_per_bloc];
        int bloc_cnt = 0;
        while (bloc_cnt < max_blocs) {
            int spot_cnt = 0;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    meta_array[bloc_cnt][spot_cnt] = dummy_array[spot_cnt + bloc_cnt * spots_per_bloc];
                    ++spot_cnt;
                }
                if (spot_cnt + bloc_cnt * spots_per_bloc >= this.num_spots_) break;
            } while (this.meta_bloc_[spot_cnt + bloc_cnt * spots_per_bloc] == bloc_cnt + 1);
            ++bloc_cnt;
        }
        return meta_array;
    }
}

