/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.microarrayobjects;

import at.tugraz.genome.arraynormcore.microarrayobjects.FloatMatrix;
import at.tugraz.genome.math.MathFunctions;

public class SlideMatrix
extends FloatMatrix {
    public int[] bloc_;
    public int[] column_;
    private int count_;
    public int[] flag_;
    public String[] gene_id_;
    public String[] gene_name_;
    public long[] mars_element_;
    public int[] mars_id_;
    public int[] meta_column_;
    public int[] meta_row_;
    public int num_spots_ = 0;
    public int[] row_;
    public int[] spot_nbr_;
    public int[] x_coord_;
    public int[] y_coord_;

    public SlideMatrix(int num_of_spots, int dim_x) {
        super(num_of_spots, dim_x, 0.0f);
        this.spot_nbr_ = new int[num_of_spots];
        this.bloc_ = new int[num_of_spots];
        this.meta_column_ = new int[num_of_spots];
        this.meta_row_ = new int[num_of_spots];
        this.column_ = new int[num_of_spots];
        this.row_ = new int[num_of_spots];
        this.gene_id_ = new String[num_of_spots];
        this.gene_name_ = new String[num_of_spots];
        this.flag_ = new int[num_of_spots];
        this.x_coord_ = new int[num_of_spots];
        this.y_coord_ = new int[num_of_spots];
        this.mars_id_ = new int[num_of_spots];
        this.mars_element_ = new long[num_of_spots];
        this.num_spots_ = num_of_spots;
    }

    public void findBlocksForImagGene() {
        int metacol_max = MathFunctions.max(this.meta_column_);
        int i = 0;
        while (i < this.num_spots_) {
            this.bloc_[i] = (this.meta_row_[i] - 1) * metacol_max + this.meta_column_[i];
            ++i;
        }
    }

    public void findColsAndRowsForArrayVision() {
        int num_cols = 36;
        int cnt_row = 0;
        int cnt_col = 0;
        int num_rows = this.num_spots_ / num_cols;
        int i = 0;
        while (i < this.num_spots_) {
            this.column_[i] = cnt_col++;
            this.row_[i] = cnt_row++;
            if (cnt_col == num_cols) {
                cnt_col = 0;
            }
            ++i;
        }
    }

    public void findColsAndRowsForArrayVisionTresBon() {
        int num_cols = 36;
        int cnt_row = 0;
        int cnt_col = 0;
        int cnt_block = 0;
        float spot2spot_distance = this.x_coord_[1] - this.x_coord_[0];
        spot2spot_distance += (float)(this.x_coord_[2] - this.x_coord_[1]);
        spot2spot_distance += (float)(this.x_coord_[3] - this.x_coord_[2]);
        spot2spot_distance += (float)(this.x_coord_[4] - this.x_coord_[3]);
        spot2spot_distance += (float)(this.x_coord_[5] - this.x_coord_[4]);
        float block2block_gap_x = (spot2spot_distance /= 5.0f) * 1.8f;
        float block2block_gap_y = spot2spot_distance * 1.5f;
        this.column_[0] = 0;
        this.row_[0] = 0;
        this.bloc_[0] = 0;
        this.meta_column_[0] = cnt_block;
        this.meta_row_[0] = 1;
        int i = 1;
        while (i < this.num_spots_) {
            if ((float)(this.x_coord_[i] - this.x_coord_[i - 1]) > block2block_gap_x) {
                cnt_col = 0;
                cnt_row = 0;
            }
            this.column_[i] = cnt_col++;
            this.row_[i] = cnt_row++;
            this.bloc_[i] = ++cnt_block;
            this.meta_column_[i] = cnt_block;
            this.meta_row_[i] = 1;
            if (cnt_col == num_cols) {
                cnt_col = 0;
            }
            ++i;
        }
    }

    public void findMetaIndicesForGenePix() {
        int delta_x_ave = 0;
        int delta_y_ave = 0;
        int max_row = 0;
        int max_col = 0;
        int max_blocks = 0;
        int spots_per_subgrid = 0;
        int m_col = 0;
        int m_row = 0;
        int[] cent_of_subgrid = new int[2];
        int block_gap = 450;
        max_row = MathFunctions.max(this.row_);
        max_col = MathFunctions.max(this.column_);
        spots_per_subgrid = max_row * max_col;
        max_blocks = MathFunctions.max(this.bloc_);
        int[] x_block = new int[spots_per_subgrid];
        int[] y_block = new int[spots_per_subgrid];
        int[] delta_x = new int[max_blocks];
        int[] delta_y = new int[max_blocks];
        int count_bl = 0;
        while (count_bl < max_blocks) {
            this.count_ = 0;
            while (this.count_ < spots_per_subgrid) {
                x_block[this.count_] = this.x_coord_[this.count_ + spots_per_subgrid * count_bl];
                y_block[this.count_] = this.y_coord_[this.count_ + spots_per_subgrid * count_bl];
                ++this.count_;
            }
            delta_x[count_bl] = MathFunctions.max(x_block) - MathFunctions.min(x_block);
            delta_y[count_bl] = MathFunctions.max(y_block) - MathFunctions.min(y_block);
            ++count_bl;
        }
        delta_x_ave = MathFunctions.mean(delta_x);
        delta_y_ave = MathFunctions.mean(delta_y);
        delta_x_ave += block_gap;
        delta_y_ave += block_gap;
        float[] x_centers = new float[max_blocks];
        float[] y_centers = new float[max_blocks];
        this.count_ = 0;
        while (this.count_ < max_blocks) {
            cent_of_subgrid[0] = this.x_coord_[spots_per_subgrid / 2 + this.count_ * spots_per_subgrid];
            cent_of_subgrid[1] = this.y_coord_[spots_per_subgrid / 2 + this.count_ * spots_per_subgrid];
            x_centers[this.count_] = cent_of_subgrid[0];
            y_centers[this.count_] = cent_of_subgrid[1];
            m_col = cent_of_subgrid[0] / delta_x_ave + 1;
            m_row = cent_of_subgrid[1] / delta_y_ave + 1;
            float mcol = (float)cent_of_subgrid[0] / (float)delta_x_ave;
            float mrow = (float)cent_of_subgrid[1] / (float)delta_y_ave;
            int cnt = 0;
            while (cnt < spots_per_subgrid) {
                this.meta_column_[cnt + this.count_ * spots_per_subgrid] = m_col;
                this.meta_row_[cnt + this.count_ * spots_per_subgrid] = m_row;
                ++cnt;
            }
            ++this.count_;
        }
    }

    public int getFlag(int i) {
        return this.flag_[i];
    }

    public float getValue(int x, int y) {
        try {
            return super.get(x, y);
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public int getbloc_(int i) {
        return this.bloc_[i];
    }

    public int getcolumn_(int i) {
        return this.column_[i];
    }

    public String getgene_id_(int i) {
        return this.gene_id_[i];
    }

    public String getgene_name_(int i) {
        return this.gene_name_[i];
    }

    public int getrow_(int i) {
        return this.row_[i];
    }

    public int getspot_nbr_(int i) {
        return this.spot_nbr_[i];
    }

    public void setValue(int x, int y, float Value2) {
        super.set(x, y, Value2);
    }
}

