/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import java.util.Arrays;

public class LowessAlgorithm {
    public static Object[] lowess(float[] x, float[] y, int n, float f, int nsteps, float delta) {
        boolean ok = false;
        int data_len = x.length;
        float[] y_fit = new float[data_len];
        float[] rob_weight = new float[data_len];
        float[] residual = new float[data_len];
        int z = 0;
        while (z < data_len) {
            y_fit[z] = 0.0f;
            rob_weight[z] = 0.0f;
            residual[z] = 0.0f;
            ++z;
        }
        if (n < 2) {
            y_fit[0] = y[0];
            return new Object[]{y_fit, rob_weight, residual};
        }
        int ns = Math.max(2, Math.min(n, (int)((double)(f * (float)n) + 1.0E-7))) - 1;
        int iterations = 1;
        while (iterations <= nsteps + 1) {
            float cmad;
            int nleft = 0;
            int nright = ns;
            int last_index = -1;
            int i = 0;
            while (true) {
                float d2;
                float d1;
                if (nright < n - 1 && (d1 = x[i] - x[nleft]) > (d2 = x[nright + 1] - x[i])) {
                    ++nleft;
                    ++nright;
                    continue;
                }
                Object[] dummyResult = LowessAlgorithm.lowest(x, y, n, x[i], nleft, nright, residual, iterations > 1, rob_weight);
                y_fit[i] = ((Double)dummyResult[0]).floatValue();
                residual = (float[])dummyResult[1];
                ok = (Boolean)dummyResult[2];
                if (!ok) {
                    y_fit[i] = y[i];
                }
                if (last_index < i - 1) {
                    float denom = x[i] - x[last_index];
                    int j = last_index + 1;
                    while (j < i) {
                        float alpha = (x[j] - x[last_index]) / denom;
                        y_fit[j] = alpha * y_fit[i] + (1.0f - alpha) * y_fit[last_index];
                        ++j;
                    }
                }
                last_index = i;
                float cut = x[last_index] + delta;
                i = last_index + 1;
                while (i <= n - 1) {
                    if (x[i] > cut) break;
                    if (x[i] == x[last_index]) {
                        y_fit[i] = y_fit[last_index];
                        last_index = i;
                    }
                    ++i;
                }
                i = Math.max(last_index + 1, i - 1);
                if (last_index >= n - 1) break;
            }
            i = 0;
            while (i < n) {
                residual[i] = y[i] - y_fit[i];
                ++i;
            }
            if (iterations > nsteps) break;
            i = 0;
            while (i < n) {
                rob_weight[i] = Math.abs(residual[i]);
                ++i;
            }
            int m1 = n / 2;
            Arrays.sort(rob_weight, 0, n);
            if (n % 2 == 0) {
                int m2 = n - m1 - 1;
                cmad = 3.0f * (rob_weight[m1] + rob_weight[m2]);
            } else {
                cmad = 6.0f * rob_weight[m1];
            }
            float c9 = 0.999f * cmad;
            float c1 = 0.001f * cmad;
            i = 0;
            while (i < n) {
                float r = Math.abs(residual[i]);
                rob_weight[i] = r <= c1 ? 1.0f : (r <= c9 ? LowessAlgorithm.power2(1.0f - LowessAlgorithm.power2(r / cmad)) : 0.0f);
                ++i;
            }
            ++iterations;
        }
        return new Object[]{y_fit, rob_weight, residual};
    }

    static Object[] lowest(float[] x, float[] y, int n, float xs, int nleft, int nright, float[] w, boolean userw, float[] rw) {
        float ys = 0.0f;
        boolean ok = false;
        float range = x[n - 1] - x[0];
        float h = Math.max(xs - x[nleft], x[nright] - xs);
        float h9 = 0.999f * h;
        float h1 = 0.001f * h;
        float a = 0.0f;
        int j = nleft;
        while (j <= n - 1) {
            w[j] = 0.0f;
            float r = Math.abs(x[j] - xs);
            if (r <= h9) {
                w[j] = r <= h1 ? 1.0f : LowessAlgorithm.power3(1.0f - LowessAlgorithm.power3(r / h));
                if (userw) {
                    int n2 = j;
                    w[n2] = w[n2] * rw[j];
                }
                a += w[j];
            } else if (x[j] > xs) break;
            ++j;
        }
        int nrt = j - 1;
        if (a <= 0.0f) {
            ok = false;
        } else {
            ok = true;
            j = nleft;
            while (j <= nrt) {
                int n3 = j++;
                w[n3] = w[n3] / a;
            }
            if (h > 0.0f) {
                a = 0.0f;
                j = nleft;
                while (j <= nrt) {
                    a += w[j] * x[j];
                    ++j;
                }
                float b = xs - a;
                float c = 0.0f;
                j = nleft;
                while (j <= nrt) {
                    c += w[j] * LowessAlgorithm.power2(x[j] - a);
                    ++j;
                }
                if (Math.sqrt(c) > (double)(0.001f * range)) {
                    b /= c;
                    j = nleft;
                    while (j <= nrt) {
                        int n4 = j;
                        w[n4] = w[n4] * (b * (x[j] - a) + 1.0f);
                        ++j;
                    }
                }
            }
            ys = 0.0f;
            j = nleft;
            while (j <= nrt) {
                ys += w[j] * y[j];
                ++j;
            }
        }
        return new Object[]{new Double(ys), w, new Boolean(ok)};
    }

    public static void main(String[] args) {
        LowessAlgorithm.testDriver();
    }

    static float power2(float x) {
        return (float)Math.pow(x, 2.0);
    }

    static float power3(float x) {
        return (float)Math.pow(x, 3.0);
    }

    private static void testDriver() {
        float[] xin = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 50.0f};
        float[] yin = new float[]{18.0f, 2.0f, 15.0f, 6.0f, 10.0f, 4.0f, 16.0f, 11.0f, 7.0f, 3.0f, 14.0f, 17.0f, 20.0f, 12.0f, 9.0f, 13.0f, 1.0f, 8.0f, 5.0f, 19.0f};
        Object[] result = LowessAlgorithm.lowess(xin, yin, xin.length, 0.25f, 0, 0.0f);
        float[] ys = (float[])result[0];
        System.out.println("[LowessAlgorithm::testDriver -> f=0.25, nsteps=0, delta=0.0] ys:");
        int i = 0;
        while (i < ys.length) {
            System.out.println(" " + ys[i]);
            ++i;
        }
        result = LowessAlgorithm.lowess(xin, yin, xin.length, 0.25f, 0, 3.0f);
        ys = (float[])result[0];
        System.out.println("[LowessAlgorithm::testDriver -> f=0.25, nsteps=0, delta=3.0] ys:");
        int i2 = 0;
        while (i2 < ys.length) {
            System.out.println(" " + ys[i2]);
            ++i2;
        }
        result = LowessAlgorithm.lowess(xin, yin, xin.length, 0.25f, 2, 0.0f);
        ys = (float[])result[0];
        System.out.println("[LowessAlgorithm::testDriver -> f=0.25, nsteps=2, delta=0.0] ys:");
        int i3 = 0;
        while (i3 < ys.length) {
            System.out.println(" " + ys[i3]);
            ++i3;
        }
    }
}

