/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SpotData;
import at.tugraz.genome.arraynormcore.normalize.LowessAlgorithm;
import at.tugraz.genome.arraynormcore.normalize.NormalizeMethod;
import at.tugraz.genome.arraynormcore.util.SpotAValueComparator;
import at.tugraz.genome.arraynormcore.util.SpotIndexComparator;
import at.tugraz.genome.math.MathFunctions;
import java.util.ArrayList;
import java.util.Collections;

public class LowessMethod
implements NormalizeMethod {
    private float[] calculateLowess(float[] x_in, float[] y_in) {
        Object[] result = LowessAlgorithm.lowess(x_in, y_in, x_in.length, 0.1f, 0, 0.0f);
        float[] y_fit = (float[])result[0];
        return y_fit;
    }

    public void normalize(ExperimentData.ExpClass exp_class) {
        this.normalizeNormalSlides(exp_class);
        this.normalizeReverseSlides(exp_class);
    }

    private void normalizeNormalSlides(ExperimentData.ExpClass exp_class) {
        int mcnt = 0;
        int num_spots = exp_class.num_spots_;
        int num_normal_slides = exp_class.num_normal_slides_;
        int slide_cnt = 0;
        while (slide_cnt < num_normal_slides) {
            float[] dummy_1 = (float[])exp_class.expclass_normal_data_[slide_cnt][0].clone();
            float[] dummy_2 = (float[])exp_class.expclass_normal_data_[slide_cnt][1].clone();
            int xcntbefore = MathFunctions.countReliableValues(dummy_1);
            int ycntbefore = MathFunctions.countReliableValues(dummy_2);
            System.out.println("[LowessMethod::normalizeNormalSlides] -> xcntbefore = " + xcntbefore + ",  ycntbefore = " + ycntbefore);
            float[] m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            float[] dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            float[] a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            ArrayList<SpotData> spotlist = new ArrayList<SpotData>();
            SpotData[] spots = new SpotData[num_spots];
            int i = 0;
            while (i < num_spots) {
                spots[i] = new SpotData();
                spots[i].setIndex(new Integer(i));
                spots[i].setF635(new Float(dummy_1[i]));
                spots[i].setF532(new Float(dummy_2[i]));
                spots[i].setAvalue(new Float(a_in[i]));
                spots[i].setMValue(new Float(m_in[i]));
                spotlist.add(spots[i]);
                ++i;
            }
            SpotAValueComparator compi_a = new SpotAValueComparator();
            Collections.sort(spotlist, compi_a);
            float[] m_sorted = new float[num_spots];
            float[] a_sorted = new float[num_spots];
            int i2 = 0;
            while (i2 < num_spots) {
                m_sorted[i2] = ((SpotData)spotlist.get(i2)).getMValue().floatValue();
                a_sorted[i2] = ((SpotData)spotlist.get(i2)).getAvalue().floatValue();
                ++i2;
            }
            mcnt = MathFunctions.countReliableValues(m_sorted);
            System.out.println("[LowessMethod::normalizeNormalSlides] -> mcnt = " + mcnt);
            float[] new_m_sorted = new float[mcnt];
            float[] new_a_sorted = new float[mcnt];
            int i3 = 0;
            while (i3 < mcnt) {
                new_m_sorted[i3] = m_sorted[i3];
                new_a_sorted[i3] = a_sorted[i3];
                ++i3;
            }
            float[] ys = this.calculateLowess(new_a_sorted, new_m_sorted);
            int xscnt = MathFunctions.countReliableValues(ys);
            System.out.println("[LowessMethod::normalizeNormalSlides] -> xscnt = " + xscnt);
            float[] const_1 = MathFunctions.exp2(ys);
            int const1cnt = MathFunctions.countReliableValues(const_1);
            System.out.println("[LowessMethod::normalizeNormalSlides] -> const1cnt = " + const1cnt);
            int i4 = 0;
            while (i4 < mcnt) {
                float f532_corr = ((SpotData)spotlist.get(i4)).getF532().floatValue() * const_1[i4];
                ((SpotData)spotlist.get(i4)).setF532(new Float(f532_corr));
                ++i4;
            }
            int i5 = 0;
            while (i5 < num_spots) {
                float f635_dummy = ((SpotData)spotlist.get(i5)).getF635().floatValue();
                float f532_dummy = ((SpotData)spotlist.get(i5)).getF532().floatValue();
                float m_corr = f635_dummy / f532_dummy;
                m_corr = MathFunctions.log2(m_corr);
                float a_corr = (MathFunctions.log2(f635_dummy) + MathFunctions.log2(f532_dummy)) / 2.0f;
                ((SpotData)spotlist.get(i5)).setAvalue(new Float(a_corr));
                ((SpotData)spotlist.get(i5)).setMValue(new Float(m_corr));
                ++i5;
            }
            SpotIndexComparator compi_index = new SpotIndexComparator();
            Collections.sort(spotlist, compi_index);
            int i6 = 0;
            while (i6 < num_spots) {
                dummy_1[i6] = ((SpotData)spotlist.get(i6)).getF635().floatValue();
                dummy_2[i6] = ((SpotData)spotlist.get(i6)).getF532().floatValue();
                ++i6;
            }
            exp_class.expclass_normal_data_[slide_cnt][0] = (float[])dummy_1.clone();
            exp_class.expclass_normal_data_[slide_cnt][1] = (float[])dummy_2.clone();
            ++slide_cnt;
        }
    }

    private void normalizeReverseSlides(ExperimentData.ExpClass exp_class) {
        int mcnt = 0;
        int num_spots = exp_class.num_spots_;
        int num_dysw_slides = exp_class.num_dysw_slides_;
        int slide_cnt = 0;
        while (slide_cnt < num_dysw_slides) {
            float[] dummy_1 = (float[])exp_class.expclass_dysw_data_[slide_cnt][0].clone();
            float[] dummy_2 = (float[])exp_class.expclass_dysw_data_[slide_cnt][1].clone();
            float[] m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            float[] dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            float[] a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            ArrayList<SpotData> spotlist = new ArrayList<SpotData>();
            SpotData[] spots = new SpotData[num_spots];
            int i = 0;
            while (i < num_spots) {
                spots[i] = new SpotData();
                spots[i].setIndex(new Integer(i));
                spots[i].setF635(new Float(dummy_1[i]));
                spots[i].setF532(new Float(dummy_2[i]));
                spots[i].setAvalue(new Float(a_in[i]));
                spots[i].setMValue(new Float(m_in[i]));
                spotlist.add(spots[i]);
                ++i;
            }
            SpotAValueComparator compi_a = new SpotAValueComparator();
            Collections.sort(spotlist, compi_a);
            float[] m_sorted = new float[num_spots];
            float[] a_sorted = new float[num_spots];
            int i2 = 0;
            while (i2 < num_spots) {
                m_sorted[i2] = ((SpotData)spotlist.get(i2)).getMValue().floatValue();
                a_sorted[i2] = ((SpotData)spotlist.get(i2)).getAvalue().floatValue();
                ++i2;
            }
            mcnt = MathFunctions.countReliableValues(m_sorted);
            float[] new_m_sorted = new float[mcnt];
            float[] new_a_sorted = new float[mcnt];
            int i3 = 0;
            while (i3 < mcnt) {
                new_m_sorted[i3] = m_sorted[i3];
                new_a_sorted[i3] = a_sorted[i3];
                ++i3;
            }
            float[] ys = this.calculateLowess(new_a_sorted, new_m_sorted);
            float[] const_1 = MathFunctions.exp2(ys);
            int i4 = 0;
            while (i4 < mcnt) {
                float f532_corr = ((SpotData)spotlist.get(i4)).getF532().floatValue() * const_1[i4];
                ((SpotData)spotlist.get(i4)).setF532(new Float(f532_corr));
                ++i4;
            }
            int i5 = 0;
            while (i5 < num_spots) {
                float f635_dummy = ((SpotData)spotlist.get(i5)).getF635().floatValue();
                float f532_dummy = ((SpotData)spotlist.get(i5)).getF532().floatValue();
                float m_corr = f635_dummy / f532_dummy;
                m_corr = MathFunctions.log2(m_corr);
                float a_corr = (MathFunctions.log2(f635_dummy) + MathFunctions.log2(f532_dummy)) / 2.0f;
                ((SpotData)spotlist.get(i5)).setAvalue(new Float(a_corr));
                ((SpotData)spotlist.get(i5)).setMValue(new Float(m_corr));
                ++i5;
            }
            SpotIndexComparator compi_index = new SpotIndexComparator();
            Collections.sort(spotlist, compi_index);
            int i6 = 0;
            while (i6 < num_spots) {
                exp_class.expclass_dysw_data_[slide_cnt][0][i6] = ((SpotData)spotlist.get(i6)).getF635().floatValue();
                exp_class.expclass_dysw_data_[slide_cnt][1][i6] = ((SpotData)spotlist.get(i6)).getF532().floatValue();
                ++i6;
            }
            ++slide_cnt;
        }
    }
}

