/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.normalize.NormalizeMethod;
import at.tugraz.genome.math.MathFunctions;

public class LowessRegressionSubgridMethod
implements NormalizeMethod {
    public float[] calculateLowess(float[] x_in, float[] y_in) {
        int num_genes = x_in.length;
        float[] x_neighbours = new float[30];
        float[] y_neighbours = new float[30];
        float[] x_out = new float[num_genes];
        float[] y_out = new float[num_genes];
        int cnt_i = 0;
        while (cnt_i < num_genes) {
            float value = x_in[cnt_i];
            if (!Float.isNaN(value)) {
                float distance = 0.0f;
                int points = 0;
                int cnt_j = 0;
                while (cnt_j < num_genes) {
                    float dist_1;
                    float value_1 = x_in[cnt_j];
                    if (!Float.isNaN(value_1) && (cnt_j > cnt_i || cnt_j < cnt_i) && (double)(dist_1 = Math.abs(value - x_in[cnt_j])) < 2.0 && points < 30) {
                        x_neighbours[points] = x_in[cnt_j];
                        y_neighbours[points] = y_in[cnt_j];
                        if (distance < dist_1) {
                            distance = dist_1;
                        }
                        ++points;
                    }
                    ++cnt_j;
                }
                float[] x_2 = MathFunctions.zerosArray(30);
                int i = 0;
                while (i < points) {
                    x_2[i] = value;
                    ++i;
                }
                float[] d_1 = new float[30];
                d_1 = MathFunctions.subtractArrays(x_2, x_neighbours);
                float[] b_1 = new float[30];
                b_1 = MathFunctions.divideArrayByConst(d_1, distance);
                b_1 = MathFunctions.absoluteArray(b_1);
                float sum_w = MathFunctions.sum(b_1);
                b_1 = MathFunctions.powerArray(b_1, 3);
                float[] o_1 = MathFunctions.onesArray(30);
                float[] weight = new float[30];
                weight = MathFunctions.subtractArrays(o_1, b_1);
                weight = MathFunctions.powerArray(weight, 3);
                sum_w = MathFunctions.sum(weight);
                float sum_x_neig = MathFunctions.sum(x_neighbours);
                float[] dummy_product = MathFunctions.innerProduct(weight, x_neighbours);
                float sum_wx = MathFunctions.sum(dummy_product);
                dummy_product = MathFunctions.innerProduct(weight, y_neighbours);
                float sum_wy = MathFunctions.sum(dummy_product);
                float[] dummy_powered = MathFunctions.powerArray(x_neighbours, 2);
                dummy_product = MathFunctions.innerProduct(weight, dummy_powered);
                float sum_wx2 = MathFunctions.sum(dummy_product);
                dummy_powered = MathFunctions.powerArray(y_neighbours, 2);
                dummy_product = MathFunctions.innerProduct(weight, dummy_powered);
                float sum_wy2 = MathFunctions.sum(dummy_product);
                dummy_product = MathFunctions.innerProduct(x_neighbours, y_neighbours);
                dummy_product = MathFunctions.innerProduct(weight, dummy_product);
                float sum_wxy = MathFunctions.sum(dummy_product);
                float numerator = sum_w * sum_wxy - sum_wx * sum_wy;
                float del_1 = sum_w * sum_wx2 - (float)Math.pow(sum_wx, 2.0);
                float del_2 = sum_w * sum_wy2 - (float)Math.pow(sum_wy, 2.0);
                float slope = numerator / del_1;
                float intercept = (sum_wx2 * sum_wy - sum_wx * sum_wxy) / del_1;
                x_out[cnt_i] = value;
                y_out[cnt_i] = slope * x_in[cnt_i] + intercept;
            }
            ++cnt_i;
        }
        return y_out;
    }

    public void normalize(ExperimentData.ExpClass exp_class) {
        int j_;
        int i_;
        float[] const_1;
        boolean spot_cnt;
        int bloc_cnt;
        float[] a_in;
        float[] dummy_3;
        float[] m_in;
        float[] dummy_2;
        float[] dummy_1;
        int indy = 0;
        int indy1 = 0;
        int num_spots = exp_class.num_spots_;
        int[] meta_block = exp_class.bloc_;
        int[] sing_col = exp_class.column_;
        int[] sing_row = exp_class.row_;
        int max_blocks = MathFunctions.max(meta_block);
        int max_cols = MathFunctions.max(sing_col);
        int max_rows = MathFunctions.max(sing_row);
        int spots_per_block = max_cols * max_rows;
        float[][] meta_array_1 = new float[max_blocks][spots_per_block];
        float[][] meta_array_2 = new float[max_blocks][spots_per_block];
        float[][] meta_keep_red = new float[max_blocks][spots_per_block];
        float[][] meta_keep_green = new float[max_blocks][spots_per_block];
        int ns_cnt = 0;
        while (ns_cnt < exp_class.num_normal_slides_) {
            dummy_1 = (float[])exp_class.expclass_normal_data_[ns_cnt][0].clone();
            dummy_2 = (float[])exp_class.expclass_normal_data_[ns_cnt][1].clone();
            m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            indy = 0;
            int i_2 = 0;
            while (i_2 < max_blocks) {
                int j_2 = 0;
                while (j_2 < spots_per_block) {
                    indy = i_2 * spots_per_block + j_2;
                    meta_array_1[i_2][j_2] = a_in[indy];
                    meta_array_2[i_2][j_2] = m_in[indy];
                    meta_keep_green[i_2][j_2] = dummy_2[indy];
                    ++j_2;
                }
                ++i_2;
            }
            bloc_cnt = 0;
            while (bloc_cnt < max_blocks) {
                spot_cnt = false;
                float[] result_y = this.calculateLowess(meta_array_1[bloc_cnt], meta_array_2[bloc_cnt]);
                const_1 = MathFunctions.exp2(result_y);
                meta_keep_green[bloc_cnt] = MathFunctions.innerProduct(meta_keep_green[bloc_cnt], const_1);
                ++bloc_cnt;
            }
            indy1 = 0;
            i_ = 0;
            while (i_ < max_blocks) {
                j_ = 0;
                while (j_ < spots_per_block) {
                    indy1 = i_ * spots_per_block + j_;
                    dummy_2[indy1] = meta_keep_green[i_][j_];
                    ++j_;
                }
                ++i_;
            }
            exp_class.expclass_normal_data_[ns_cnt][1] = dummy_2;
            dummy_3 = MathFunctions.ratioOfArrays(exp_class.expclass_normal_data_[ns_cnt][0], exp_class.expclass_normal_data_[ns_cnt][1]);
            exp_class.expclass_normal_data_[ns_cnt][2] = dummy_3;
            ++ns_cnt;
        }
        int ds_cnt = 0;
        while (ds_cnt < exp_class.num_dysw_slides_) {
            dummy_1 = (float[])exp_class.expclass_dysw_data_[ds_cnt][0].clone();
            dummy_2 = (float[])exp_class.expclass_dysw_data_[ds_cnt][1].clone();
            m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            indy = 0;
            i_ = 0;
            while (i_ < max_blocks) {
                j_ = 0;
                while (j_ < spots_per_block) {
                    indy = i_ * spots_per_block + j_;
                    meta_array_1[i_][j_] = a_in[indy];
                    meta_array_2[i_][j_] = m_in[indy];
                    meta_keep_green[i_][j_] = dummy_2[indy];
                    ++j_;
                }
                ++i_;
            }
            bloc_cnt = 0;
            while (bloc_cnt < max_blocks) {
                spot_cnt = false;
                float[] result_y = this.calculateLowess(meta_array_1[bloc_cnt], meta_array_2[bloc_cnt]);
                const_1 = MathFunctions.exp2(result_y);
                meta_keep_green[bloc_cnt] = MathFunctions.innerProduct(meta_keep_green[bloc_cnt], const_1);
                ++bloc_cnt;
            }
            indy1 = 0;
            int i_3 = 0;
            while (i_3 < max_blocks) {
                int j_3 = 0;
                while (j_3 < spots_per_block) {
                    indy1 = i_3 * spots_per_block + j_3;
                    dummy_2[indy1] = meta_keep_green[i_3][j_3];
                    ++j_3;
                }
                ++i_3;
            }
            exp_class.expclass_dysw_data_[ds_cnt][1] = dummy_2;
            dummy_3 = MathFunctions.ratioOfArrays(exp_class.expclass_dysw_data_[ds_cnt][0], exp_class.expclass_dysw_data_[ds_cnt][1]);
            exp_class.expclass_dysw_data_[ds_cnt][2] = dummy_3;
            ++ds_cnt;
        }
    }
}

