/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.math.Univariate;
import at.tugraz.genome.math.MathFunctions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class BoxPlot
extends JPanel {
    public static final Color DEFAULT_AXES_COLOR;
    private static final Font DEFAULT_FONT;
    public static final Color DEFAULT_GRAPHBACKGROUD_COLOR;
    public static final Color DEFAULT_GRAPHIC_COLOR;
    public static final int DEFAULT_HEIGHT = 590;
    public static final Color DEFAULT_IQRBOXES_COLOR;
    public static final Color DEFAULT_MEDIANLINE_COLOR;
    public static final int DEFAULT_WIDTH = 680;
    public static final Color DEFAULT_ZEROLINE_COLOR;
    private float[] Q1_;
    private float[] Q3_;
    private static final int X_OFFSET = 40;
    private static final int Y_OFFSET = 30;
    private int bottom_;
    private JPanel box_plot_panel_;
    private Univariate[] data_ = null;
    float[][] data_in_;
    private float[][] data_sorted_ = null;
    private float glob_max_;
    private float glob_min_;
    private int height_;
    private float[] iq_range_;
    private int left_;
    private float[] lf_;
    private int[] lwi_;
    private int[] margins_;
    private float[] max_;
    private float[] median_;
    private float[] min_;
    int mouse_x_;
    int mouse_y_;
    private int num_of_boxes_ = 1;
    private JPopupMenu popup_menu_;
    private int right_;
    private boolean scale_fix_;
    private String title_;
    private int top_;
    private float[] uf_;
    private int[] uwi_;
    private int width_;
    private String x_label_;
    private String y_label_;

    static {
        DEFAULT_GRAPHBACKGROUD_COLOR = Color.white;
        DEFAULT_GRAPHIC_COLOR = Color.black;
        DEFAULT_IQRBOXES_COLOR = Color.lightGray;
        DEFAULT_MEDIANLINE_COLOR = Color.red;
        DEFAULT_ZEROLINE_COLOR = Color.green;
        DEFAULT_AXES_COLOR = Color.blue;
        DEFAULT_FONT = new Font("TimesRoman", 0, 12);
    }

    public BoxPlot(Vector info_set) {
        this.data_in_ = (float[][])info_set.get(0);
        this.x_label_ = (String)info_set.get(1);
        this.y_label_ = (String)info_set.get(2);
        boolean[] dummy_bool = (boolean[])info_set.get(3);
        this.scale_fix_ = dummy_bool[0];
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.newData(this.data_in_);
    }

    void jbInit() throws Exception {
        this.width_ = 680;
        this.height_ = 590;
        this.setSize(this.width_, this.height_);
        this.bottom_ = 60;
        this.left_ = 30;
        this.top_ = 10;
        this.right_ = 20;
        this.setPreferredSize(new Dimension(this.width_, this.height_));
    }

    public void newData(float[][] data_in) {
        this.num_of_boxes_ = data_in.length;
        this.data_ = new Univariate[this.num_of_boxes_];
        this.min_ = new float[this.num_of_boxes_];
        this.max_ = new float[this.num_of_boxes_];
        this.Q1_ = new float[this.num_of_boxes_];
        this.median_ = new float[this.num_of_boxes_];
        this.Q3_ = new float[this.num_of_boxes_];
        this.iq_range_ = new float[this.num_of_boxes_];
        this.lf_ = new float[this.num_of_boxes_];
        this.uf_ = new float[this.num_of_boxes_];
        this.lwi_ = new int[this.num_of_boxes_];
        this.uwi_ = new int[this.num_of_boxes_];
        int i = 0;
        while (i < this.num_of_boxes_) {
            float[] temp = data_in[i];
            this.data_[i] = new Univariate(temp);
            this.min_[i] = this.data_[i].min();
            this.max_[i] = this.data_[i].max();
            ++i;
        }
        if (this.scale_fix_) {
            this.glob_min_ = -4.0f;
            this.glob_max_ = 4.0f;
        } else {
            this.glob_min_ = MathFunctions.min(this.min_);
            this.glob_max_ = MathFunctions.max(this.max_);
        }
        this.setBoxParams();
    }

    public void paint(Graphics g) {
        Graphics2D graphix_2d = (Graphics2D)g;
        if (this.data_ == null) {
            return;
        }
        int y_origin_1 = this.height_ - this.bottom_;
        int x_origin_1 = this.left_;
        float y_scale = (float)(this.height_ - this.top_ - this.bottom_) / (this.glob_max_ - this.glob_min_);
        int y_correct = (int)(y_scale * this.glob_min_);
        int y_zeroline = y_origin_1 + y_correct;
        FontMetrics fm = this.getFontMetrics(DEFAULT_FONT);
        graphix_2d.setFont(DEFAULT_FONT);
        graphix_2d.setColor(DEFAULT_GRAPHBACKGROUD_COLOR);
        graphix_2d.fillRect(0, 0, this.width_, this.height_);
        graphix_2d.setColor(DEFAULT_AXES_COLOR);
        graphix_2d.drawLine(x_origin_1, y_origin_1, x_origin_1, y_origin_1 - this.height_ + this.top_ + this.bottom_);
        graphix_2d.drawLine(x_origin_1, y_origin_1 + 10, x_origin_1 + this.width_ - this.right_ - this.left_, y_origin_1 + 10);
        graphix_2d.setColor(DEFAULT_ZEROLINE_COLOR);
        graphix_2d.drawLine(x_origin_1, y_zeroline, this.width_ - this.right_ - this.left_, y_zeroline);
        graphix_2d.setColor(DEFAULT_AXES_COLOR);
        int y_tick = (int)((double)(this.height_ - this.top_ - this.bottom_) * 0.25);
        int count = 0;
        while (count < 5) {
            graphix_2d.drawLine(x_origin_1, y_origin_1 - count * y_tick - 30, x_origin_1 + 5, y_origin_1 - count * y_tick - 30);
            float y_label = this.glob_min_ + (float)count * (this.glob_max_ - this.glob_min_) / 4.0f;
            graphix_2d.drawString(Float.toString(y_label), x_origin_1 + 5, y_origin_1 - count * y_tick + 5);
            ++count;
        }
        int x_tick = (this.width_ - this.left_ - this.right_ - 40) / this.num_of_boxes_;
        count = 0;
        while (count < this.num_of_boxes_) {
            graphix_2d.drawLine(x_origin_1 + 40 + count * x_tick, y_origin_1 + 10, x_origin_1 + 40 + count * x_tick, y_origin_1 + 5);
            graphix_2d.drawString(Integer.toString(count + 1), x_origin_1 + 40 - 3 + count * x_tick, y_origin_1 + 25);
            ++count;
        }
        graphix_2d.drawString("x = " + this.x_label_, x_origin_1 + (this.width_ - this.left_ - this.right_) / 2, y_origin_1 + 45);
        graphix_2d.drawString("y = " + this.y_label_, x_origin_1, this.bottom_ - 12);
        int[] x_subplot = new int[this.num_of_boxes_];
        int box_width = Math.min(20, x_tick / 4);
        count = 0;
        while (count < this.num_of_boxes_) {
            x_subplot[count] = x_origin_1 + count * x_tick + 40;
            ++count;
        }
        int count_sub = 0;
        while (count_sub < this.num_of_boxes_) {
            graphix_2d.setColor(DEFAULT_IQRBOXES_COLOR);
            graphix_2d.fillRect(x_subplot[count_sub] - box_width, y_origin_1 - (int)(this.Q1_[count_sub] * y_scale) - (int)(this.iq_range_[count_sub] * y_scale) + y_correct, 2 * box_width, (int)(this.iq_range_[count_sub] * y_scale));
            graphix_2d.setColor(DEFAULT_MEDIANLINE_COLOR);
            graphix_2d.drawLine(x_subplot[count_sub] - box_width, y_origin_1 - (int)(this.median_[count_sub] * y_scale) + y_correct, x_subplot[count_sub] + box_width, y_origin_1 - (int)(this.median_[count_sub] * y_scale) + y_correct);
            graphix_2d.setColor(DEFAULT_GRAPHIC_COLOR);
            graphix_2d.drawRect(x_subplot[count_sub] - box_width, y_origin_1 - (int)(this.Q1_[count_sub] * y_scale) - (int)(this.iq_range_[count_sub] * y_scale) + y_correct, 2 * box_width, (int)(this.iq_range_[count_sub] * y_scale));
            graphix_2d.drawLine(x_subplot[count_sub], y_origin_1 - (int)(this.data_sorted_[count_sub][this.lwi_[count_sub]] * y_scale) + y_correct, x_subplot[count_sub], y_origin_1 - (int)(this.Q1_[count_sub] * y_scale) + y_correct);
            graphix_2d.drawLine(x_subplot[count_sub] - box_width, y_origin_1 - (int)(this.data_sorted_[count_sub][this.lwi_[count_sub]] * y_scale) + y_correct, x_subplot[count_sub] + box_width, y_origin_1 - (int)(this.data_sorted_[count_sub][this.lwi_[count_sub]] * y_scale) + y_correct);
            graphix_2d.drawLine(x_subplot[count_sub], y_origin_1 - (int)(this.data_sorted_[count_sub][this.uwi_[count_sub]] * y_scale) + y_correct, x_subplot[count_sub], y_origin_1 - (int)(this.Q3_[count_sub] * y_scale) + y_correct);
            graphix_2d.drawLine(x_subplot[count_sub] - box_width, y_origin_1 - (int)(this.data_sorted_[count_sub][this.uwi_[count_sub]] * y_scale) + y_correct, x_subplot[count_sub] + box_width, y_origin_1 - (int)(this.data_sorted_[count_sub][this.uwi_[count_sub]] * y_scale) + y_correct);
            count = 0;
            while (count < this.lwi_[count_sub]) {
                graphix_2d.drawString("*", x_subplot[count_sub], (int)(this.data_sorted_[count_sub][count] * y_scale));
                ++count;
            }
            ++count_sub;
        }
    }

    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    private void setBoxParams() {
        this.data_sorted_ = new float[this.num_of_boxes_][1];
        int count = 0;
        while (count < this.num_of_boxes_) {
            this.data_sorted_[count] = this.data_[count].sort();
            this.Q1_[count] = this.data_[count].quant(0.25f);
            this.median_[count] = this.data_[count].quant(0.5f);
            this.Q3_[count] = this.data_[count].quant(0.75f);
            this.iq_range_[count] = this.Q3_[count] - this.Q1_[count];
            this.lf_[count] = this.median_[count] - 1.5f * this.iq_range_[count];
            this.uf_[count] = this.median_[count] + 1.5f * this.iq_range_[count];
            this.lwi_[count] = this.data_[count].compare(this.lf_[count]);
            this.uwi_[count] = this.data_[count].compare(this.uf_[count]);
            ++count;
        }
    }
}

