/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.math.MathFunctions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class OverUnderExpViewer
extends JPanel {
    private static final int MAX_INTENS_VAL = 60000;
    private static final int RGB_MAX_VAL = 256;
    private MicroArrayData array_data_;
    Graphics2D array_view_graphix_1_;
    public BufferedImage array_view_image_1_;
    int border_correction_ = 20;
    int col_scale_height_ = 60;
    private Color[] color_table_;
    private int loop_cnt_;
    private float max_intens_;
    private int meta_gap_size_;
    int mouse_x_;
    int mouse_y_;
    private String name_;
    private JPanel panel_;
    private JPopupMenu pop_menu_;
    private float scal_factor_;
    private int show_colorscale_;
    private int show_metagap_;
    private int spot_size_;
    private int view_mode_;

    public OverUnderExpViewer(Vector info_set) {
        int[] dummy_int = new int[4];
        this.array_data_ = (MicroArrayData)info_set.get(0);
        this.name_ = this.array_data_.slide_name_;
        this.panel_ = this;
        dummy_int = (int[])info_set.get(1);
        this.view_mode_ = dummy_int[0];
        this.show_metagap_ = dummy_int[1];
        this.show_colorscale_ = dummy_int[2];
        this.spot_size_ = dummy_int[3];
        this.meta_gap_size_ = this.show_metagap_ == 1 ? this.spot_size_ : 0;
        this.createImage();
        this.setToolTipText("Slide " + this.name_ + " - arrayview");
    }

    private void colorLookupTable() {
        this.color_table_ = new Color[256];
        switch (this.view_mode_) {
            case 500: {
                this.loop_cnt_ = 0;
                while (this.loop_cnt_ < 256) {
                    this.color_table_[this.loop_cnt_] = new Color(this.loop_cnt_, 0, 0);
                    ++this.loop_cnt_;
                }
                break;
            }
            case 502: {
                this.loop_cnt_ = 0;
                while (this.loop_cnt_ < 256) {
                    this.color_table_[this.loop_cnt_] = new Color(0, this.loop_cnt_, 0);
                    ++this.loop_cnt_;
                }
                break;
            }
            case 501: {
                this.loop_cnt_ = 0;
                while (this.loop_cnt_ < 256) {
                    this.color_table_[this.loop_cnt_] = new Color(this.loop_cnt_, 0, 0);
                    ++this.loop_cnt_;
                }
                break;
            }
            case 503: {
                this.loop_cnt_ = 0;
                while (this.loop_cnt_ < 256) {
                    this.color_table_[this.loop_cnt_] = new Color(0, this.loop_cnt_, 0);
                    ++this.loop_cnt_;
                }
                break;
            }
            default: {
                this.loop_cnt_ = 0;
                while (this.loop_cnt_ < 256) {
                    this.color_table_[this.loop_cnt_] = new Color(this.loop_cnt_, 0, 0);
                    ++this.loop_cnt_;
                }
                break block0;
            }
        }
    }

    public void createImage() {
        Vector grid_object_vector = this.array_data_.getGridObject();
        Vector array_info_vector = this.array_data_.getSlide_information_vector_();
        int sing_col_max = 0;
        int sing_row_max = 0;
        int meta_col_max = 0;
        int meta_row_max = 0;
        int num_spots = ((int[])array_info_vector.get(0))[0];
        int[] meta_col = new int[num_spots];
        int[] meta_row = new int[num_spots];
        int[] sing_col = new int[num_spots];
        int[] sing_row = new int[num_spots];
        int[] result_col = new int[num_spots];
        int[] result_row = new int[num_spots];
        int[] spot_pos_x = new int[num_spots];
        int[] spot_pos_y = new int[num_spots];
        float[] plot_data_1 = new float[num_spots];
        float[] plot_data_2 = new float[num_spots];
        int[] plot_data_flag_ = new int[num_spots];
        String[] spot_gene_name_ = new String[num_spots];
        String frame_title = "Digital Genes";
        meta_col = (int[])grid_object_vector.get(1);
        meta_row = (int[])grid_object_vector.get(2);
        sing_col = (int[])grid_object_vector.get(3);
        sing_row = (int[])grid_object_vector.get(4);
        sing_col_max = MathFunctions.max(sing_col);
        sing_row_max = MathFunctions.max(sing_row);
        meta_col_max = MathFunctions.max(meta_col);
        meta_row_max = MathFunctions.max(meta_row);
        int x_origin = this.border_correction_;
        int y_origin = this.border_correction_ + this.col_scale_height_;
        this.loop_cnt_ = 0;
        while (this.loop_cnt_ < num_spots) {
            result_col[this.loop_cnt_] = sing_col[this.loop_cnt_] + (meta_col[this.loop_cnt_] - 1) * (sing_col_max + this.meta_gap_size_);
            result_row[this.loop_cnt_] = sing_row[this.loop_cnt_] + (meta_row[this.loop_cnt_] - 1) * (sing_row_max + this.meta_gap_size_);
            spot_pos_x[this.loop_cnt_] = result_col[this.loop_cnt_] * this.spot_size_ + x_origin;
            spot_pos_y[this.loop_cnt_] = result_row[this.loop_cnt_] * this.spot_size_ + y_origin;
            ++this.loop_cnt_;
        }
        int image_size_x = meta_col_max * sing_col_max * this.spot_size_ + (meta_col_max - 1) * this.meta_gap_size_ * this.spot_size_ + 2 * this.border_correction_;
        int image_size_y = meta_row_max * sing_row_max * this.spot_size_ + (meta_row_max - 1) * this.meta_gap_size_ * this.spot_size_ + 2 * this.border_correction_ + this.col_scale_height_;
        if (image_size_x < 256) {
            image_size_x = 256;
        }
        this.array_view_image_1_ = new BufferedImage(image_size_x, image_size_y, 5);
        this.array_view_graphix_1_ = (Graphics2D)this.array_view_image_1_.getGraphics();
        this.array_view_graphix_1_.setColor(new Color(100, 100, 100));
        this.array_view_graphix_1_.setColor(Color.GRAY);
        this.array_view_graphix_1_.fillRect(0, 0, this.array_view_image_1_.getWidth(), this.array_view_image_1_.getHeight());
        plot_data_1 = this.array_data_.getF635median_();
        plot_data_2 = this.array_data_.getF532median_();
        plot_data_1 = MathFunctions.ratioOfArrays(plot_data_1, plot_data_2);
        plot_data_1 = MathFunctions.log2(plot_data_1);
        plot_data_flag_ = this.array_data_.flag_;
        spot_gene_name_ = this.array_data_.gene_name_;
        this.paintHeader();
        this.array_view_graphix_1_.setColor(Color.black);
        this.loop_cnt_ = 0;
        while (this.loop_cnt_ < num_spots) {
            if (plot_data_1[this.loop_cnt_] > 1.5f) {
                this.array_view_graphix_1_.setColor(Color.red);
            } else if (plot_data_1[this.loop_cnt_] < -1.5f) {
                this.array_view_graphix_1_.setColor(Color.blue);
            } else {
                this.array_view_graphix_1_.setColor(Color.white);
            }
            if (plot_data_flag_[this.loop_cnt_] == -100) {
                this.array_view_graphix_1_.setColor(Color.darkGray);
            }
            this.array_view_graphix_1_.fillRect(spot_pos_x[this.loop_cnt_], spot_pos_y[this.loop_cnt_], this.spot_size_, this.spot_size_);
            ++this.loop_cnt_;
        }
    }

    private Color getColorFromTable(float prim_intens, float sek_intens, boolean pre_scaled) {
        int lookup_index_sek;
        int lookup_index_prim2;
        this.scal_factor_ = this.max_intens_ / 256.0f;
        if (sek_intens == 0.0f) {
            if (prim_intens > 60000.0f) {
                prim_intens = 60000.0f;
            }
            int lookup_index_prim2 = pre_scaled ? Math.round(prim_intens) : Math.round(prim_intens / this.scal_factor_);
            if (lookup_index_prim2 >= 256) {
                lookup_index_prim2 = 255;
            }
            return this.color_table_[lookup_index_prim2];
        }
        if (prim_intens > 60000.0f) {
            prim_intens = 60000.0f;
        }
        if (sek_intens > 60000.0f) {
            sek_intens = 60000.0f;
        }
        if (pre_scaled) {
            lookup_index_prim2 = Math.round(prim_intens);
            lookup_index_sek = Math.round(sek_intens);
        } else {
            lookup_index_prim2 = Math.round(prim_intens / 400.0f);
            lookup_index_sek = Math.round(sek_intens / 400.0f);
        }
        if (lookup_index_prim2 > 256) {
            lookup_index_prim2 = 256;
        }
        if (lookup_index_sek > 256) {
            lookup_index_sek = 256;
        }
        Color red_green_mix = new Color(lookup_index_prim2, lookup_index_sek, 0);
        return red_green_mix;
    }

    public void paint(Graphics g) {
        g.drawImage(this.array_view_image_1_, 0, 0, this);
        this.setSize(this.array_view_image_1_.getWidth(), this.array_view_image_1_.getHeight());
        this.setPreferredSize(new Dimension(this.array_view_image_1_.getWidth(), this.array_view_image_1_.getHeight()));
    }

    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    private void paintHeader() {
        this.array_view_graphix_1_.setColor(Color.black);
        this.array_view_graphix_1_.fillRect(0, 0, this.array_view_image_1_.getWidth(), this.col_scale_height_);
        int sing_col_width = this.array_view_image_1_.getWidth() / 3;
        this.array_view_graphix_1_.setColor(Color.red);
        this.array_view_graphix_1_.fillRect(0, 0, sing_col_width, this.col_scale_height_ - 40);
        this.array_view_graphix_1_.setColor(Color.white);
        this.array_view_graphix_1_.fillRect(sing_col_width + 1, 0, this.array_view_image_1_.getWidth() - sing_col_width, this.col_scale_height_ - 40);
        this.array_view_graphix_1_.setColor(Color.blue);
        this.array_view_graphix_1_.fillRect(this.array_view_image_1_.getWidth() - sing_col_width + 1, 0, this.array_view_image_1_.getWidth(), this.col_scale_height_ - 40);
        String channel = "log-Ratios";
        this.array_view_graphix_1_.setColor(Color.white);
        this.array_view_graphix_1_.drawString("> log2(1.5)", 0, 32);
        this.array_view_graphix_1_.drawString("< log2(1.5)", this.array_view_image_1_.getWidth() - 60, 32);
        this.array_view_graphix_1_.drawString("" + this.name_ + " ,  " + channel, 2, this.col_scale_height_ - 2);
        this.array_view_graphix_1_.drawRect(0, 0, this.array_view_image_1_.getWidth(), this.col_scale_height_ - 40);
        this.array_view_graphix_1_.drawLine(0, this.col_scale_height_, this.array_view_image_1_.getWidth(), this.col_scale_height_);
    }
}

